/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.batch.v1alpha.BatchServiceSettings;
import com.google.cloud.batch.v1alpha.CreateJobRequest;
import com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.DeleteJobRequest;
import com.google.cloud.batch.v1alpha.DeleteResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetJobRequest;
import com.google.cloud.batch.v1alpha.GetResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetTaskRequest;
import com.google.cloud.batch.v1alpha.Job;
import com.google.cloud.batch.v1alpha.JobName;
import com.google.cloud.batch.v1alpha.ListJobsRequest;
import com.google.cloud.batch.v1alpha.ListJobsResponse;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesRequest;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesResponse;
import com.google.cloud.batch.v1alpha.ListTasksRequest;
import com.google.cloud.batch.v1alpha.ListTasksResponse;
import com.google.cloud.batch.v1alpha.LocationName;
import com.google.cloud.batch.v1alpha.OperationMetadata;
import com.google.cloud.batch.v1alpha.ResourceAllowance;
import com.google.cloud.batch.v1alpha.ResourceAllowanceName;
import com.google.cloud.batch.v1alpha.Task;
import com.google.cloud.batch.v1alpha.TaskGroupName;
import com.google.cloud.batch.v1alpha.TaskName;
import com.google.cloud.batch.v1alpha.UpdateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStub;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BatchServiceClient
implements BackgroundResource {
    private final BatchServiceSettings settings;
    private final BatchServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final BatchServiceClient create() throws IOException {
        return BatchServiceClient.create(BatchServiceSettings.newBuilder().build());
    }

    public static final BatchServiceClient create(BatchServiceSettings settings) throws IOException {
        return new BatchServiceClient(settings);
    }

    public static final BatchServiceClient create(BatchServiceStub stub) {
        return new BatchServiceClient(stub);
    }

    protected BatchServiceClient(BatchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BatchServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected BatchServiceClient(BatchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final BatchServiceSettings getSettings() {
        return this.settings;
    }

    public BatchServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Job createJob(LocationName parent, Job job, String jobId) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJob(job).setJobId(jobId).build();
        return this.createJob(request);
    }

    public final Job createJob(String parent, Job job, String jobId) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent).setJob(job).setJobId(jobId).build();
        return this.createJob(request);
    }

    public final Job createJob(CreateJobRequest request) {
        return (Job)this.createJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.stub.createJobCallable();
    }

    public final Job getJob(JobName name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJob(request);
    }

    public final Job getJob(String name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteJobAsync(String name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name).build();
        return this.deleteJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteJobAsync(DeleteJobRequest request) {
        return this.deleteJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable() {
        return this.stub.deleteJobOperationCallable();
    }

    public final UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final ListJobsPagedResponse listJobs(String parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final Task getTask(TaskName name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTask(request);
    }

    public final Task getTask(String name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name).build();
        return this.getTask(request);
    }

    public final Task getTask(GetTaskRequest request) {
        return (Task)this.getTaskCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.stub.getTaskCallable();
    }

    public final ListTasksPagedResponse listTasks(TaskGroupName parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(String parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(ListTasksRequest request) {
        return (ListTasksPagedResponse)((Object)this.listTasksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTasksRequest, ListTasksPagedResponse> listTasksPagedCallable() {
        return this.stub.listTasksPagedCallable();
    }

    public final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.stub.listTasksCallable();
    }

    public final ResourceAllowance createResourceAllowance(LocationName parent, ResourceAllowance resourceAllowance, String resourceAllowanceId) {
        CreateResourceAllowanceRequest request = CreateResourceAllowanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setResourceAllowance(resourceAllowance).setResourceAllowanceId(resourceAllowanceId).build();
        return this.createResourceAllowance(request);
    }

    public final ResourceAllowance createResourceAllowance(String parent, ResourceAllowance resourceAllowance, String resourceAllowanceId) {
        CreateResourceAllowanceRequest request = CreateResourceAllowanceRequest.newBuilder().setParent(parent).setResourceAllowance(resourceAllowance).setResourceAllowanceId(resourceAllowanceId).build();
        return this.createResourceAllowance(request);
    }

    public final ResourceAllowance createResourceAllowance(CreateResourceAllowanceRequest request) {
        return (ResourceAllowance)this.createResourceAllowanceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceCallable() {
        return this.stub.createResourceAllowanceCallable();
    }

    public final ResourceAllowance getResourceAllowance(ResourceAllowanceName name) {
        GetResourceAllowanceRequest request = GetResourceAllowanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResourceAllowance(request);
    }

    public final ResourceAllowance getResourceAllowance(String name) {
        GetResourceAllowanceRequest request = GetResourceAllowanceRequest.newBuilder().setName(name).build();
        return this.getResourceAllowance(request);
    }

    public final ResourceAllowance getResourceAllowance(GetResourceAllowanceRequest request) {
        return (ResourceAllowance)this.getResourceAllowanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceCallable() {
        return this.stub.getResourceAllowanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteResourceAllowanceAsync(ResourceAllowanceName name) {
        DeleteResourceAllowanceRequest request = DeleteResourceAllowanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteResourceAllowanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteResourceAllowanceAsync(String name) {
        DeleteResourceAllowanceRequest request = DeleteResourceAllowanceRequest.newBuilder().setName(name).build();
        return this.deleteResourceAllowanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteResourceAllowanceAsync(DeleteResourceAllowanceRequest request) {
        return this.deleteResourceAllowanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationCallable() {
        return this.stub.deleteResourceAllowanceOperationCallable();
    }

    public final UnaryCallable<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceCallable() {
        return this.stub.deleteResourceAllowanceCallable();
    }

    public final ListResourceAllowancesPagedResponse listResourceAllowances(LocationName parent) {
        ListResourceAllowancesRequest request = ListResourceAllowancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResourceAllowances(request);
    }

    public final ListResourceAllowancesPagedResponse listResourceAllowances(String parent) {
        ListResourceAllowancesRequest request = ListResourceAllowancesRequest.newBuilder().setParent(parent).build();
        return this.listResourceAllowances(request);
    }

    public final ListResourceAllowancesPagedResponse listResourceAllowances(ListResourceAllowancesRequest request) {
        return (ListResourceAllowancesPagedResponse)((Object)this.listResourceAllowancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourceAllowancesRequest, ListResourceAllowancesPagedResponse> listResourceAllowancesPagedCallable() {
        return this.stub.listResourceAllowancesPagedCallable();
    }

    public final UnaryCallable<ListResourceAllowancesRequest, ListResourceAllowancesResponse> listResourceAllowancesCallable() {
        return this.stub.listResourceAllowancesCallable();
    }

    public final ResourceAllowance updateResourceAllowance(ResourceAllowance resourceAllowance, FieldMask updateMask) {
        UpdateResourceAllowanceRequest request = UpdateResourceAllowanceRequest.newBuilder().setResourceAllowance(resourceAllowance).setUpdateMask(updateMask).build();
        return this.updateResourceAllowance(request);
    }

    public final ResourceAllowance updateResourceAllowance(UpdateResourceAllowanceRequest request) {
        return (ResourceAllowance)this.updateResourceAllowanceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceCallable() {
        return this.stub.updateResourceAllowanceCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourceAllowancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance, ListResourceAllowancesPage, ListResourceAllowancesFixedSizeCollection> {
        private ListResourceAllowancesFixedSizeCollection(List<ListResourceAllowancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourceAllowancesFixedSizeCollection createEmptyCollection() {
            return new ListResourceAllowancesFixedSizeCollection(null, 0);
        }

        protected ListResourceAllowancesFixedSizeCollection createCollection(List<ListResourceAllowancesPage> pages, int collectionSize) {
            return new ListResourceAllowancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourceAllowancesPage
    extends AbstractPage<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance, ListResourceAllowancesPage> {
        private ListResourceAllowancesPage(PageContext<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance> context, ListResourceAllowancesResponse response) {
            super(context, (Object)response);
        }

        private static ListResourceAllowancesPage createEmptyPage() {
            return new ListResourceAllowancesPage(null, null);
        }

        protected ListResourceAllowancesPage createPage(PageContext<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance> context, ListResourceAllowancesResponse response) {
            return new ListResourceAllowancesPage(context, response);
        }

        public ApiFuture<ListResourceAllowancesPage> createPageAsync(PageContext<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance> context, ApiFuture<ListResourceAllowancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourceAllowancesPagedResponse
    extends AbstractPagedListResponse<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance, ListResourceAllowancesPage, ListResourceAllowancesFixedSizeCollection> {
        public static ApiFuture<ListResourceAllowancesPagedResponse> createAsync(PageContext<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance> context, ApiFuture<ListResourceAllowancesResponse> futureResponse) {
            ApiFuture<ListResourceAllowancesPage> futurePage = ListResourceAllowancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourceAllowancesPagedResponse((ListResourceAllowancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourceAllowancesPagedResponse(ListResourceAllowancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourceAllowancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTasksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        private ListTasksFixedSizeCollection(List<ListTasksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTasksFixedSizeCollection createEmptyCollection() {
            return new ListTasksFixedSizeCollection(null, 0);
        }

        protected ListTasksFixedSizeCollection createCollection(List<ListTasksPage> pages, int collectionSize) {
            return new ListTasksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTasksPage
    extends AbstractPage<ListTasksRequest, ListTasksResponse, Task, ListTasksPage> {
        private ListTasksPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            super(context, (Object)response);
        }

        private static ListTasksPage createEmptyPage() {
            return new ListTasksPage(null, null);
        }

        protected ListTasksPage createPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            return new ListTasksPage(context, response);
        }

        public ApiFuture<ListTasksPage> createPageAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTasksPagedResponse
    extends AbstractPagedListResponse<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        public static ApiFuture<ListTasksPagedResponse> createAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            ApiFuture<ListTasksPage> futurePage = ListTasksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTasksPagedResponse((ListTasksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTasksPagedResponse(ListTasksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTasksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobsPagedResponse((ListJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

