/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.batch.v1alpha.BatchServiceSettings;
import com.google.cloud.batch.v1alpha.CreateJobRequest;
import com.google.cloud.batch.v1alpha.DeleteJobRequest;
import com.google.cloud.batch.v1alpha.GetJobRequest;
import com.google.cloud.batch.v1alpha.GetTaskRequest;
import com.google.cloud.batch.v1alpha.Job;
import com.google.cloud.batch.v1alpha.JobName;
import com.google.cloud.batch.v1alpha.ListJobsRequest;
import com.google.cloud.batch.v1alpha.ListJobsResponse;
import com.google.cloud.batch.v1alpha.ListTasksRequest;
import com.google.cloud.batch.v1alpha.ListTasksResponse;
import com.google.cloud.batch.v1alpha.LocationName;
import com.google.cloud.batch.v1alpha.OperationMetadata;
import com.google.cloud.batch.v1alpha.Task;
import com.google.cloud.batch.v1alpha.TaskGroupName;
import com.google.cloud.batch.v1alpha.TaskName;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStub;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BatchServiceClient
implements BackgroundResource {
    private final BatchServiceSettings settings;
    private final BatchServiceStub stub;
    private final OperationsClient operationsClient;

    public static final BatchServiceClient create() throws IOException {
        return BatchServiceClient.create(BatchServiceSettings.newBuilder().build());
    }

    public static final BatchServiceClient create(BatchServiceSettings settings) throws IOException {
        return new BatchServiceClient(settings);
    }

    public static final BatchServiceClient create(BatchServiceStub stub) {
        return new BatchServiceClient(stub);
    }

    protected BatchServiceClient(BatchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BatchServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected BatchServiceClient(BatchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final BatchServiceSettings getSettings() {
        return this.settings;
    }

    public BatchServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Job createJob(LocationName parent, Job job, String jobId) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJob(job).setJobId(jobId).build();
        return this.createJob(request);
    }

    public final Job createJob(String parent, Job job, String jobId) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent).setJob(job).setJobId(jobId).build();
        return this.createJob(request);
    }

    public final Job createJob(CreateJobRequest request) {
        return (Job)this.createJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.stub.createJobCallable();
    }

    public final Job getJob(JobName name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJob(request);
    }

    public final Job getJob(String name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteJobAsync(String name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name).build();
        return this.deleteJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteJobAsync(DeleteJobRequest request) {
        return this.deleteJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable() {
        return this.stub.deleteJobOperationCallable();
    }

    public final UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final ListJobsPagedResponse listJobs(String parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final Task getTask(TaskName name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTask(request);
    }

    public final Task getTask(String name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name).build();
        return this.getTask(request);
    }

    public final Task getTask(GetTaskRequest request) {
        return (Task)this.getTaskCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.stub.getTaskCallable();
    }

    public final ListTasksPagedResponse listTasks(TaskGroupName parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(String parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(ListTasksRequest request) {
        return (ListTasksPagedResponse)((Object)this.listTasksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTasksRequest, ListTasksPagedResponse> listTasksPagedCallable() {
        return this.stub.listTasksPagedCallable();
    }

    public final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.stub.listTasksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTasksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        private ListTasksFixedSizeCollection(List<ListTasksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTasksFixedSizeCollection createEmptyCollection() {
            return new ListTasksFixedSizeCollection(null, 0);
        }

        protected ListTasksFixedSizeCollection createCollection(List<ListTasksPage> pages, int collectionSize) {
            return new ListTasksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTasksPage
    extends AbstractPage<ListTasksRequest, ListTasksResponse, Task, ListTasksPage> {
        private ListTasksPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            super(context, (Object)response);
        }

        private static ListTasksPage createEmptyPage() {
            return new ListTasksPage(null, null);
        }

        protected ListTasksPage createPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            return new ListTasksPage(context, response);
        }

        public ApiFuture<ListTasksPage> createPageAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTasksPagedResponse
    extends AbstractPagedListResponse<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        public static ApiFuture<ListTasksPagedResponse> createAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            ApiFuture<ListTasksPage> futurePage = ListTasksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTasksPagedResponse((ListTasksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTasksPagedResponse(ListTasksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTasksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobsPagedResponse((ListJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

