/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.baremetalsolution.v2.BareMetalSolutionSettings;
import com.google.cloud.baremetalsolution.v2.CreateNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest;
import com.google.cloud.baremetalsolution.v2.CreateSSHKeyRequest;
import com.google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.DeleteNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.DeleteSSHKeyRequest;
import com.google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.DetachLunRequest;
import com.google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleRequest;
import com.google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleResponse;
import com.google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleRequest;
import com.google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleResponse;
import com.google.cloud.baremetalsolution.v2.EvictLunRequest;
import com.google.cloud.baremetalsolution.v2.EvictVolumeRequest;
import com.google.cloud.baremetalsolution.v2.GetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.GetLunRequest;
import com.google.cloud.baremetalsolution.v2.GetNetworkRequest;
import com.google.cloud.baremetalsolution.v2.GetNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.GetProvisioningConfigRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.Instance;
import com.google.cloud.baremetalsolution.v2.InstanceName;
import com.google.cloud.baremetalsolution.v2.ListInstancesRequest;
import com.google.cloud.baremetalsolution.v2.ListInstancesResponse;
import com.google.cloud.baremetalsolution.v2.ListLunsRequest;
import com.google.cloud.baremetalsolution.v2.ListLunsResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworkUsageRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworkUsageResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworksRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworksResponse;
import com.google.cloud.baremetalsolution.v2.ListNfsSharesRequest;
import com.google.cloud.baremetalsolution.v2.ListNfsSharesResponse;
import com.google.cloud.baremetalsolution.v2.ListOSImagesRequest;
import com.google.cloud.baremetalsolution.v2.ListOSImagesResponse;
import com.google.cloud.baremetalsolution.v2.ListProvisioningQuotasRequest;
import com.google.cloud.baremetalsolution.v2.ListProvisioningQuotasResponse;
import com.google.cloud.baremetalsolution.v2.ListSSHKeysRequest;
import com.google.cloud.baremetalsolution.v2.ListSSHKeysResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumesRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumesResponse;
import com.google.cloud.baremetalsolution.v2.LocationName;
import com.google.cloud.baremetalsolution.v2.Lun;
import com.google.cloud.baremetalsolution.v2.LunName;
import com.google.cloud.baremetalsolution.v2.NFSShareName;
import com.google.cloud.baremetalsolution.v2.Network;
import com.google.cloud.baremetalsolution.v2.NetworkName;
import com.google.cloud.baremetalsolution.v2.NfsShare;
import com.google.cloud.baremetalsolution.v2.OSImage;
import com.google.cloud.baremetalsolution.v2.OperationMetadata;
import com.google.cloud.baremetalsolution.v2.ProvisioningConfig;
import com.google.cloud.baremetalsolution.v2.ProvisioningConfigName;
import com.google.cloud.baremetalsolution.v2.ProvisioningQuota;
import com.google.cloud.baremetalsolution.v2.RenameInstanceRequest;
import com.google.cloud.baremetalsolution.v2.RenameNetworkRequest;
import com.google.cloud.baremetalsolution.v2.RenameNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.RenameVolumeRequest;
import com.google.cloud.baremetalsolution.v2.ResetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.ResetInstanceResponse;
import com.google.cloud.baremetalsolution.v2.ResizeVolumeRequest;
import com.google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.SSHKey;
import com.google.cloud.baremetalsolution.v2.SshKeyName;
import com.google.cloud.baremetalsolution.v2.StartInstanceRequest;
import com.google.cloud.baremetalsolution.v2.StartInstanceResponse;
import com.google.cloud.baremetalsolution.v2.StopInstanceRequest;
import com.google.cloud.baremetalsolution.v2.StopInstanceResponse;
import com.google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest;
import com.google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse;
import com.google.cloud.baremetalsolution.v2.UpdateInstanceRequest;
import com.google.cloud.baremetalsolution.v2.UpdateNetworkRequest;
import com.google.cloud.baremetalsolution.v2.UpdateNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest;
import com.google.cloud.baremetalsolution.v2.UpdateVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Volume;
import com.google.cloud.baremetalsolution.v2.VolumeName;
import com.google.cloud.baremetalsolution.v2.VolumeSnapshot;
import com.google.cloud.baremetalsolution.v2.VolumeSnapshotName;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStub;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BareMetalSolutionClient
implements BackgroundResource {
    private final BareMetalSolutionSettings settings;
    private final BareMetalSolutionStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final BareMetalSolutionClient create() throws IOException {
        return BareMetalSolutionClient.create(BareMetalSolutionSettings.newBuilder().build());
    }

    public static final BareMetalSolutionClient create(BareMetalSolutionSettings settings) throws IOException {
        return new BareMetalSolutionClient(settings);
    }

    public static final BareMetalSolutionClient create(BareMetalSolutionStub stub) {
        return new BareMetalSolutionClient(stub);
    }

    protected BareMetalSolutionClient(BareMetalSolutionSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BareMetalSolutionStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected BareMetalSolutionClient(BareMetalSolutionStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final BareMetalSolutionSettings getSettings() {
        return this.settings;
    }

    public BareMetalSolutionStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(Instance instance, FieldMask updateMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setUpdateMask(updateMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final Instance renameInstance(InstanceName name, String newInstanceId) {
        RenameInstanceRequest request = RenameInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).setNewInstanceId(newInstanceId).build();
        return this.renameInstance(request);
    }

    public final Instance renameInstance(String name, String newInstanceId) {
        RenameInstanceRequest request = RenameInstanceRequest.newBuilder().setName(name).setNewInstanceId(newInstanceId).build();
        return this.renameInstance(request);
    }

    public final Instance renameInstance(RenameInstanceRequest request) {
        return (Instance)this.renameInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<RenameInstanceRequest, Instance> renameInstanceCallable() {
        return this.stub.renameInstanceCallable();
    }

    public final OperationFuture<ResetInstanceResponse, OperationMetadata> resetInstanceAsync(InstanceName name) {
        ResetInstanceRequest request = ResetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resetInstanceAsync(request);
    }

    public final OperationFuture<ResetInstanceResponse, OperationMetadata> resetInstanceAsync(String name) {
        ResetInstanceRequest request = ResetInstanceRequest.newBuilder().setName(name).build();
        return this.resetInstanceAsync(request);
    }

    public final OperationFuture<ResetInstanceResponse, OperationMetadata> resetInstanceAsync(ResetInstanceRequest request) {
        return this.resetInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationCallable() {
        return this.stub.resetInstanceOperationCallable();
    }

    public final UnaryCallable<ResetInstanceRequest, Operation> resetInstanceCallable() {
        return this.stub.resetInstanceCallable();
    }

    public final OperationFuture<StartInstanceResponse, OperationMetadata> startInstanceAsync(InstanceName name) {
        StartInstanceRequest request = StartInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startInstanceAsync(request);
    }

    public final OperationFuture<StartInstanceResponse, OperationMetadata> startInstanceAsync(String name) {
        StartInstanceRequest request = StartInstanceRequest.newBuilder().setName(name).build();
        return this.startInstanceAsync(request);
    }

    public final OperationFuture<StartInstanceResponse, OperationMetadata> startInstanceAsync(StartInstanceRequest request) {
        return this.startInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartInstanceRequest, StartInstanceResponse, OperationMetadata> startInstanceOperationCallable() {
        return this.stub.startInstanceOperationCallable();
    }

    public final UnaryCallable<StartInstanceRequest, Operation> startInstanceCallable() {
        return this.stub.startInstanceCallable();
    }

    public final OperationFuture<StopInstanceResponse, OperationMetadata> stopInstanceAsync(InstanceName name) {
        StopInstanceRequest request = StopInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopInstanceAsync(request);
    }

    public final OperationFuture<StopInstanceResponse, OperationMetadata> stopInstanceAsync(String name) {
        StopInstanceRequest request = StopInstanceRequest.newBuilder().setName(name).build();
        return this.stopInstanceAsync(request);
    }

    public final OperationFuture<StopInstanceResponse, OperationMetadata> stopInstanceAsync(StopInstanceRequest request) {
        return this.stopInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopInstanceRequest, StopInstanceResponse, OperationMetadata> stopInstanceOperationCallable() {
        return this.stub.stopInstanceOperationCallable();
    }

    public final UnaryCallable<StopInstanceRequest, Operation> stopInstanceCallable() {
        return this.stub.stopInstanceCallable();
    }

    public final OperationFuture<EnableInteractiveSerialConsoleResponse, OperationMetadata> enableInteractiveSerialConsoleAsync(InstanceName name) {
        EnableInteractiveSerialConsoleRequest request = EnableInteractiveSerialConsoleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.enableInteractiveSerialConsoleAsync(request);
    }

    public final OperationFuture<EnableInteractiveSerialConsoleResponse, OperationMetadata> enableInteractiveSerialConsoleAsync(String name) {
        EnableInteractiveSerialConsoleRequest request = EnableInteractiveSerialConsoleRequest.newBuilder().setName(name).build();
        return this.enableInteractiveSerialConsoleAsync(request);
    }

    public final OperationFuture<EnableInteractiveSerialConsoleResponse, OperationMetadata> enableInteractiveSerialConsoleAsync(EnableInteractiveSerialConsoleRequest request) {
        return this.enableInteractiveSerialConsoleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableInteractiveSerialConsoleRequest, EnableInteractiveSerialConsoleResponse, OperationMetadata> enableInteractiveSerialConsoleOperationCallable() {
        return this.stub.enableInteractiveSerialConsoleOperationCallable();
    }

    public final UnaryCallable<EnableInteractiveSerialConsoleRequest, Operation> enableInteractiveSerialConsoleCallable() {
        return this.stub.enableInteractiveSerialConsoleCallable();
    }

    public final OperationFuture<DisableInteractiveSerialConsoleResponse, OperationMetadata> disableInteractiveSerialConsoleAsync(InstanceName name) {
        DisableInteractiveSerialConsoleRequest request = DisableInteractiveSerialConsoleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disableInteractiveSerialConsoleAsync(request);
    }

    public final OperationFuture<DisableInteractiveSerialConsoleResponse, OperationMetadata> disableInteractiveSerialConsoleAsync(String name) {
        DisableInteractiveSerialConsoleRequest request = DisableInteractiveSerialConsoleRequest.newBuilder().setName(name).build();
        return this.disableInteractiveSerialConsoleAsync(request);
    }

    public final OperationFuture<DisableInteractiveSerialConsoleResponse, OperationMetadata> disableInteractiveSerialConsoleAsync(DisableInteractiveSerialConsoleRequest request) {
        return this.disableInteractiveSerialConsoleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableInteractiveSerialConsoleRequest, DisableInteractiveSerialConsoleResponse, OperationMetadata> disableInteractiveSerialConsoleOperationCallable() {
        return this.stub.disableInteractiveSerialConsoleOperationCallable();
    }

    public final UnaryCallable<DisableInteractiveSerialConsoleRequest, Operation> disableInteractiveSerialConsoleCallable() {
        return this.stub.disableInteractiveSerialConsoleCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> detachLunAsync(InstanceName instance, LunName lun) {
        DetachLunRequest request = DetachLunRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setLun(lun == null ? null : lun.toString()).build();
        return this.detachLunAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> detachLunAsync(InstanceName instance, String lun) {
        DetachLunRequest request = DetachLunRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setLun(lun).build();
        return this.detachLunAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> detachLunAsync(String instance, LunName lun) {
        DetachLunRequest request = DetachLunRequest.newBuilder().setInstance(instance).setLun(lun == null ? null : lun.toString()).build();
        return this.detachLunAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> detachLunAsync(String instance, String lun) {
        DetachLunRequest request = DetachLunRequest.newBuilder().setInstance(instance).setLun(lun).build();
        return this.detachLunAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> detachLunAsync(DetachLunRequest request) {
        return this.detachLunOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DetachLunRequest, Instance, OperationMetadata> detachLunOperationCallable() {
        return this.stub.detachLunOperationCallable();
    }

    public final UnaryCallable<DetachLunRequest, Operation> detachLunCallable() {
        return this.stub.detachLunCallable();
    }

    public final ListSSHKeysPagedResponse listSSHKeys(LocationName parent) {
        ListSSHKeysRequest request = ListSSHKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSSHKeys(request);
    }

    public final ListSSHKeysPagedResponse listSSHKeys(String parent) {
        ListSSHKeysRequest request = ListSSHKeysRequest.newBuilder().setParent(parent).build();
        return this.listSSHKeys(request);
    }

    public final ListSSHKeysPagedResponse listSSHKeys(ListSSHKeysRequest request) {
        return (ListSSHKeysPagedResponse)((Object)this.listSSHKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSSHKeysRequest, ListSSHKeysPagedResponse> listSSHKeysPagedCallable() {
        return this.stub.listSSHKeysPagedCallable();
    }

    public final UnaryCallable<ListSSHKeysRequest, ListSSHKeysResponse> listSSHKeysCallable() {
        return this.stub.listSSHKeysCallable();
    }

    public final SSHKey createSSHKey(LocationName parent, SSHKey sshKey, String sshKeyId) {
        CreateSSHKeyRequest request = CreateSSHKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSshKey(sshKey).setSshKeyId(sshKeyId).build();
        return this.createSSHKey(request);
    }

    public final SSHKey createSSHKey(String parent, SSHKey sshKey, String sshKeyId) {
        CreateSSHKeyRequest request = CreateSSHKeyRequest.newBuilder().setParent(parent).setSshKey(sshKey).setSshKeyId(sshKeyId).build();
        return this.createSSHKey(request);
    }

    public final SSHKey createSSHKey(CreateSSHKeyRequest request) {
        return (SSHKey)this.createSSHKeyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSSHKeyRequest, SSHKey> createSSHKeyCallable() {
        return this.stub.createSSHKeyCallable();
    }

    public final void deleteSSHKey(SshKeyName name) {
        DeleteSSHKeyRequest request = DeleteSSHKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSSHKey(request);
    }

    public final void deleteSSHKey(String name) {
        DeleteSSHKeyRequest request = DeleteSSHKeyRequest.newBuilder().setName(name).build();
        this.deleteSSHKey(request);
    }

    public final void deleteSSHKey(DeleteSSHKeyRequest request) {
        this.deleteSSHKeyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSSHKeyRequest, Empty> deleteSSHKeyCallable() {
        return this.stub.deleteSSHKeyCallable();
    }

    public final ListVolumesPagedResponse listVolumes(LocationName parent) {
        ListVolumesRequest request = ListVolumesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVolumes(request);
    }

    public final ListVolumesPagedResponse listVolumes(String parent) {
        ListVolumesRequest request = ListVolumesRequest.newBuilder().setParent(parent).build();
        return this.listVolumes(request);
    }

    public final ListVolumesPagedResponse listVolumes(ListVolumesRequest request) {
        return (ListVolumesPagedResponse)((Object)this.listVolumesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVolumesRequest, ListVolumesPagedResponse> listVolumesPagedCallable() {
        return this.stub.listVolumesPagedCallable();
    }

    public final UnaryCallable<ListVolumesRequest, ListVolumesResponse> listVolumesCallable() {
        return this.stub.listVolumesCallable();
    }

    public final Volume getVolume(VolumeName name) {
        GetVolumeRequest request = GetVolumeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVolume(request);
    }

    public final Volume getVolume(String name) {
        GetVolumeRequest request = GetVolumeRequest.newBuilder().setName(name).build();
        return this.getVolume(request);
    }

    public final Volume getVolume(GetVolumeRequest request) {
        return (Volume)this.getVolumeCallable().call((Object)request);
    }

    public final UnaryCallable<GetVolumeRequest, Volume> getVolumeCallable() {
        return this.stub.getVolumeCallable();
    }

    public final OperationFuture<Volume, OperationMetadata> updateVolumeAsync(Volume volume, FieldMask updateMask) {
        UpdateVolumeRequest request = UpdateVolumeRequest.newBuilder().setVolume(volume).setUpdateMask(updateMask).build();
        return this.updateVolumeAsync(request);
    }

    public final OperationFuture<Volume, OperationMetadata> updateVolumeAsync(UpdateVolumeRequest request) {
        return this.updateVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationCallable() {
        return this.stub.updateVolumeOperationCallable();
    }

    public final UnaryCallable<UpdateVolumeRequest, Operation> updateVolumeCallable() {
        return this.stub.updateVolumeCallable();
    }

    public final Volume renameVolume(VolumeName name, String newVolumeId) {
        RenameVolumeRequest request = RenameVolumeRequest.newBuilder().setName(name == null ? null : name.toString()).setNewVolumeId(newVolumeId).build();
        return this.renameVolume(request);
    }

    public final Volume renameVolume(String name, String newVolumeId) {
        RenameVolumeRequest request = RenameVolumeRequest.newBuilder().setName(name).setNewVolumeId(newVolumeId).build();
        return this.renameVolume(request);
    }

    public final Volume renameVolume(RenameVolumeRequest request) {
        return (Volume)this.renameVolumeCallable().call((Object)request);
    }

    public final UnaryCallable<RenameVolumeRequest, Volume> renameVolumeCallable() {
        return this.stub.renameVolumeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> evictVolumeAsync(VolumeName name) {
        EvictVolumeRequest request = EvictVolumeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.evictVolumeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> evictVolumeAsync(String name) {
        EvictVolumeRequest request = EvictVolumeRequest.newBuilder().setName(name).build();
        return this.evictVolumeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> evictVolumeAsync(EvictVolumeRequest request) {
        return this.evictVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EvictVolumeRequest, Empty, OperationMetadata> evictVolumeOperationCallable() {
        return this.stub.evictVolumeOperationCallable();
    }

    public final UnaryCallable<EvictVolumeRequest, Operation> evictVolumeCallable() {
        return this.stub.evictVolumeCallable();
    }

    public final OperationFuture<Volume, OperationMetadata> resizeVolumeAsync(VolumeName volume, long sizeGib) {
        ResizeVolumeRequest request = ResizeVolumeRequest.newBuilder().setVolume(volume == null ? null : volume.toString()).setSizeGib(sizeGib).build();
        return this.resizeVolumeAsync(request);
    }

    public final OperationFuture<Volume, OperationMetadata> resizeVolumeAsync(String volume, long sizeGib) {
        ResizeVolumeRequest request = ResizeVolumeRequest.newBuilder().setVolume(volume).setSizeGib(sizeGib).build();
        return this.resizeVolumeAsync(request);
    }

    public final OperationFuture<Volume, OperationMetadata> resizeVolumeAsync(ResizeVolumeRequest request) {
        return this.resizeVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResizeVolumeRequest, Volume, OperationMetadata> resizeVolumeOperationCallable() {
        return this.stub.resizeVolumeOperationCallable();
    }

    public final UnaryCallable<ResizeVolumeRequest, Operation> resizeVolumeCallable() {
        return this.stub.resizeVolumeCallable();
    }

    public final ListNetworksPagedResponse listNetworks(LocationName parent) {
        ListNetworksRequest request = ListNetworksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNetworks(request);
    }

    public final ListNetworksPagedResponse listNetworks(String parent) {
        ListNetworksRequest request = ListNetworksRequest.newBuilder().setParent(parent).build();
        return this.listNetworks(request);
    }

    public final ListNetworksPagedResponse listNetworks(ListNetworksRequest request) {
        return (ListNetworksPagedResponse)((Object)this.listNetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.stub.listNetworksPagedCallable();
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable() {
        return this.stub.listNetworksCallable();
    }

    public final ListNetworkUsageResponse listNetworkUsage(LocationName location) {
        ListNetworkUsageRequest request = ListNetworkUsageRequest.newBuilder().setLocation(location == null ? null : location.toString()).build();
        return this.listNetworkUsage(request);
    }

    public final ListNetworkUsageResponse listNetworkUsage(String location) {
        ListNetworkUsageRequest request = ListNetworkUsageRequest.newBuilder().setLocation(location).build();
        return this.listNetworkUsage(request);
    }

    public final ListNetworkUsageResponse listNetworkUsage(ListNetworkUsageRequest request) {
        return (ListNetworkUsageResponse)this.listNetworkUsageCallable().call((Object)request);
    }

    public final UnaryCallable<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageCallable() {
        return this.stub.listNetworkUsageCallable();
    }

    public final Network getNetwork(NetworkName name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(String name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(GetNetworkRequest request) {
        return (Network)this.getNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkRequest, Network> getNetworkCallable() {
        return this.stub.getNetworkCallable();
    }

    public final OperationFuture<Network, OperationMetadata> updateNetworkAsync(Network network, FieldMask updateMask) {
        UpdateNetworkRequest request = UpdateNetworkRequest.newBuilder().setNetwork(network).setUpdateMask(updateMask).build();
        return this.updateNetworkAsync(request);
    }

    public final OperationFuture<Network, OperationMetadata> updateNetworkAsync(UpdateNetworkRequest request) {
        return this.updateNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateNetworkRequest, Network, OperationMetadata> updateNetworkOperationCallable() {
        return this.stub.updateNetworkOperationCallable();
    }

    public final UnaryCallable<UpdateNetworkRequest, Operation> updateNetworkCallable() {
        return this.stub.updateNetworkCallable();
    }

    public final VolumeSnapshot createVolumeSnapshot(VolumeName parent, VolumeSnapshot volumeSnapshot) {
        CreateVolumeSnapshotRequest request = CreateVolumeSnapshotRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVolumeSnapshot(volumeSnapshot).build();
        return this.createVolumeSnapshot(request);
    }

    public final VolumeSnapshot createVolumeSnapshot(String parent, VolumeSnapshot volumeSnapshot) {
        CreateVolumeSnapshotRequest request = CreateVolumeSnapshotRequest.newBuilder().setParent(parent).setVolumeSnapshot(volumeSnapshot).build();
        return this.createVolumeSnapshot(request);
    }

    public final VolumeSnapshot createVolumeSnapshot(CreateVolumeSnapshotRequest request) {
        return (VolumeSnapshot)this.createVolumeSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotCallable() {
        return this.stub.createVolumeSnapshotCallable();
    }

    public final OperationFuture<VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotAsync(VolumeSnapshotName volumeSnapshot) {
        RestoreVolumeSnapshotRequest request = RestoreVolumeSnapshotRequest.newBuilder().setVolumeSnapshot(volumeSnapshot == null ? null : volumeSnapshot.toString()).build();
        return this.restoreVolumeSnapshotAsync(request);
    }

    public final OperationFuture<VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotAsync(String volumeSnapshot) {
        RestoreVolumeSnapshotRequest request = RestoreVolumeSnapshotRequest.newBuilder().setVolumeSnapshot(volumeSnapshot).build();
        return this.restoreVolumeSnapshotAsync(request);
    }

    public final OperationFuture<VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotAsync(RestoreVolumeSnapshotRequest request) {
        return this.restoreVolumeSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationCallable() {
        return this.stub.restoreVolumeSnapshotOperationCallable();
    }

    public final UnaryCallable<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotCallable() {
        return this.stub.restoreVolumeSnapshotCallable();
    }

    public final void deleteVolumeSnapshot(VolumeSnapshotName name) {
        DeleteVolumeSnapshotRequest request = DeleteVolumeSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteVolumeSnapshot(request);
    }

    public final void deleteVolumeSnapshot(String name) {
        DeleteVolumeSnapshotRequest request = DeleteVolumeSnapshotRequest.newBuilder().setName(name).build();
        this.deleteVolumeSnapshot(request);
    }

    public final void deleteVolumeSnapshot(DeleteVolumeSnapshotRequest request) {
        this.deleteVolumeSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotCallable() {
        return this.stub.deleteVolumeSnapshotCallable();
    }

    public final VolumeSnapshot getVolumeSnapshot(VolumeSnapshotName name) {
        GetVolumeSnapshotRequest request = GetVolumeSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVolumeSnapshot(request);
    }

    public final VolumeSnapshot getVolumeSnapshot(String name) {
        GetVolumeSnapshotRequest request = GetVolumeSnapshotRequest.newBuilder().setName(name).build();
        return this.getVolumeSnapshot(request);
    }

    public final VolumeSnapshot getVolumeSnapshot(GetVolumeSnapshotRequest request) {
        return (VolumeSnapshot)this.getVolumeSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotCallable() {
        return this.stub.getVolumeSnapshotCallable();
    }

    public final ListVolumeSnapshotsPagedResponse listVolumeSnapshots(VolumeName parent) {
        ListVolumeSnapshotsRequest request = ListVolumeSnapshotsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVolumeSnapshots(request);
    }

    public final ListVolumeSnapshotsPagedResponse listVolumeSnapshots(String parent) {
        ListVolumeSnapshotsRequest request = ListVolumeSnapshotsRequest.newBuilder().setParent(parent).build();
        return this.listVolumeSnapshots(request);
    }

    public final ListVolumeSnapshotsPagedResponse listVolumeSnapshots(ListVolumeSnapshotsRequest request) {
        return (ListVolumeSnapshotsPagedResponse)((Object)this.listVolumeSnapshotsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVolumeSnapshotsRequest, ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsPagedCallable() {
        return this.stub.listVolumeSnapshotsPagedCallable();
    }

    public final UnaryCallable<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse> listVolumeSnapshotsCallable() {
        return this.stub.listVolumeSnapshotsCallable();
    }

    public final Lun getLun(LunName name) {
        GetLunRequest request = GetLunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLun(request);
    }

    public final Lun getLun(String name) {
        GetLunRequest request = GetLunRequest.newBuilder().setName(name).build();
        return this.getLun(request);
    }

    public final Lun getLun(GetLunRequest request) {
        return (Lun)this.getLunCallable().call((Object)request);
    }

    public final UnaryCallable<GetLunRequest, Lun> getLunCallable() {
        return this.stub.getLunCallable();
    }

    public final ListLunsPagedResponse listLuns(VolumeName parent) {
        ListLunsRequest request = ListLunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLuns(request);
    }

    public final ListLunsPagedResponse listLuns(String parent) {
        ListLunsRequest request = ListLunsRequest.newBuilder().setParent(parent).build();
        return this.listLuns(request);
    }

    public final ListLunsPagedResponse listLuns(ListLunsRequest request) {
        return (ListLunsPagedResponse)((Object)this.listLunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLunsRequest, ListLunsPagedResponse> listLunsPagedCallable() {
        return this.stub.listLunsPagedCallable();
    }

    public final UnaryCallable<ListLunsRequest, ListLunsResponse> listLunsCallable() {
        return this.stub.listLunsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> evictLunAsync(LunName name) {
        EvictLunRequest request = EvictLunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.evictLunAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> evictLunAsync(String name) {
        EvictLunRequest request = EvictLunRequest.newBuilder().setName(name).build();
        return this.evictLunAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> evictLunAsync(EvictLunRequest request) {
        return this.evictLunOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EvictLunRequest, Empty, OperationMetadata> evictLunOperationCallable() {
        return this.stub.evictLunOperationCallable();
    }

    public final UnaryCallable<EvictLunRequest, Operation> evictLunCallable() {
        return this.stub.evictLunCallable();
    }

    public final NfsShare getNfsShare(NFSShareName name) {
        GetNfsShareRequest request = GetNfsShareRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNfsShare(request);
    }

    public final NfsShare getNfsShare(String name) {
        GetNfsShareRequest request = GetNfsShareRequest.newBuilder().setName(name).build();
        return this.getNfsShare(request);
    }

    public final NfsShare getNfsShare(GetNfsShareRequest request) {
        return (NfsShare)this.getNfsShareCallable().call((Object)request);
    }

    public final UnaryCallable<GetNfsShareRequest, NfsShare> getNfsShareCallable() {
        return this.stub.getNfsShareCallable();
    }

    public final ListNfsSharesPagedResponse listNfsShares(LocationName parent) {
        ListNfsSharesRequest request = ListNfsSharesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNfsShares(request);
    }

    public final ListNfsSharesPagedResponse listNfsShares(String parent) {
        ListNfsSharesRequest request = ListNfsSharesRequest.newBuilder().setParent(parent).build();
        return this.listNfsShares(request);
    }

    public final ListNfsSharesPagedResponse listNfsShares(ListNfsSharesRequest request) {
        return (ListNfsSharesPagedResponse)((Object)this.listNfsSharesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNfsSharesRequest, ListNfsSharesPagedResponse> listNfsSharesPagedCallable() {
        return this.stub.listNfsSharesPagedCallable();
    }

    public final UnaryCallable<ListNfsSharesRequest, ListNfsSharesResponse> listNfsSharesCallable() {
        return this.stub.listNfsSharesCallable();
    }

    public final OperationFuture<NfsShare, OperationMetadata> updateNfsShareAsync(NfsShare nfsShare, FieldMask updateMask) {
        UpdateNfsShareRequest request = UpdateNfsShareRequest.newBuilder().setNfsShare(nfsShare).setUpdateMask(updateMask).build();
        return this.updateNfsShareAsync(request);
    }

    public final OperationFuture<NfsShare, OperationMetadata> updateNfsShareAsync(UpdateNfsShareRequest request) {
        return this.updateNfsShareOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateNfsShareRequest, NfsShare, OperationMetadata> updateNfsShareOperationCallable() {
        return this.stub.updateNfsShareOperationCallable();
    }

    public final UnaryCallable<UpdateNfsShareRequest, Operation> updateNfsShareCallable() {
        return this.stub.updateNfsShareCallable();
    }

    public final OperationFuture<NfsShare, OperationMetadata> createNfsShareAsync(LocationName parent, NfsShare nfsShare) {
        CreateNfsShareRequest request = CreateNfsShareRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNfsShare(nfsShare).build();
        return this.createNfsShareAsync(request);
    }

    public final OperationFuture<NfsShare, OperationMetadata> createNfsShareAsync(String parent, NfsShare nfsShare) {
        CreateNfsShareRequest request = CreateNfsShareRequest.newBuilder().setParent(parent).setNfsShare(nfsShare).build();
        return this.createNfsShareAsync(request);
    }

    public final OperationFuture<NfsShare, OperationMetadata> createNfsShareAsync(CreateNfsShareRequest request) {
        return this.createNfsShareOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNfsShareRequest, NfsShare, OperationMetadata> createNfsShareOperationCallable() {
        return this.stub.createNfsShareOperationCallable();
    }

    public final UnaryCallable<CreateNfsShareRequest, Operation> createNfsShareCallable() {
        return this.stub.createNfsShareCallable();
    }

    public final NfsShare renameNfsShare(NFSShareName name, String newNfsshareId) {
        RenameNfsShareRequest request = RenameNfsShareRequest.newBuilder().setName(name == null ? null : name.toString()).setNewNfsshareId(newNfsshareId).build();
        return this.renameNfsShare(request);
    }

    public final NfsShare renameNfsShare(String name, String newNfsshareId) {
        RenameNfsShareRequest request = RenameNfsShareRequest.newBuilder().setName(name).setNewNfsshareId(newNfsshareId).build();
        return this.renameNfsShare(request);
    }

    public final NfsShare renameNfsShare(RenameNfsShareRequest request) {
        return (NfsShare)this.renameNfsShareCallable().call((Object)request);
    }

    public final UnaryCallable<RenameNfsShareRequest, NfsShare> renameNfsShareCallable() {
        return this.stub.renameNfsShareCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNfsShareAsync(NFSShareName name) {
        DeleteNfsShareRequest request = DeleteNfsShareRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNfsShareAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNfsShareAsync(String name) {
        DeleteNfsShareRequest request = DeleteNfsShareRequest.newBuilder().setName(name).build();
        return this.deleteNfsShareAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNfsShareAsync(DeleteNfsShareRequest request) {
        return this.deleteNfsShareOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNfsShareRequest, Empty, OperationMetadata> deleteNfsShareOperationCallable() {
        return this.stub.deleteNfsShareOperationCallable();
    }

    public final UnaryCallable<DeleteNfsShareRequest, Operation> deleteNfsShareCallable() {
        return this.stub.deleteNfsShareCallable();
    }

    public final ListProvisioningQuotasPagedResponse listProvisioningQuotas(LocationName parent) {
        ListProvisioningQuotasRequest request = ListProvisioningQuotasRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProvisioningQuotas(request);
    }

    public final ListProvisioningQuotasPagedResponse listProvisioningQuotas(String parent) {
        ListProvisioningQuotasRequest request = ListProvisioningQuotasRequest.newBuilder().setParent(parent).build();
        return this.listProvisioningQuotas(request);
    }

    public final ListProvisioningQuotasPagedResponse listProvisioningQuotas(ListProvisioningQuotasRequest request) {
        return (ListProvisioningQuotasPagedResponse)((Object)this.listProvisioningQuotasPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProvisioningQuotasRequest, ListProvisioningQuotasPagedResponse> listProvisioningQuotasPagedCallable() {
        return this.stub.listProvisioningQuotasPagedCallable();
    }

    public final UnaryCallable<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse> listProvisioningQuotasCallable() {
        return this.stub.listProvisioningQuotasCallable();
    }

    public final SubmitProvisioningConfigResponse submitProvisioningConfig(LocationName parent, ProvisioningConfig provisioningConfig) {
        SubmitProvisioningConfigRequest request = SubmitProvisioningConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProvisioningConfig(provisioningConfig).build();
        return this.submitProvisioningConfig(request);
    }

    public final SubmitProvisioningConfigResponse submitProvisioningConfig(String parent, ProvisioningConfig provisioningConfig) {
        SubmitProvisioningConfigRequest request = SubmitProvisioningConfigRequest.newBuilder().setParent(parent).setProvisioningConfig(provisioningConfig).build();
        return this.submitProvisioningConfig(request);
    }

    public final SubmitProvisioningConfigResponse submitProvisioningConfig(SubmitProvisioningConfigRequest request) {
        return (SubmitProvisioningConfigResponse)this.submitProvisioningConfigCallable().call((Object)request);
    }

    public final UnaryCallable<SubmitProvisioningConfigRequest, SubmitProvisioningConfigResponse> submitProvisioningConfigCallable() {
        return this.stub.submitProvisioningConfigCallable();
    }

    public final ProvisioningConfig getProvisioningConfig(ProvisioningConfigName name) {
        GetProvisioningConfigRequest request = GetProvisioningConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProvisioningConfig(request);
    }

    public final ProvisioningConfig getProvisioningConfig(String name) {
        GetProvisioningConfigRequest request = GetProvisioningConfigRequest.newBuilder().setName(name).build();
        return this.getProvisioningConfig(request);
    }

    public final ProvisioningConfig getProvisioningConfig(GetProvisioningConfigRequest request) {
        return (ProvisioningConfig)this.getProvisioningConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetProvisioningConfigRequest, ProvisioningConfig> getProvisioningConfigCallable() {
        return this.stub.getProvisioningConfigCallable();
    }

    public final ProvisioningConfig createProvisioningConfig(LocationName parent, ProvisioningConfig provisioningConfig) {
        CreateProvisioningConfigRequest request = CreateProvisioningConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProvisioningConfig(provisioningConfig).build();
        return this.createProvisioningConfig(request);
    }

    public final ProvisioningConfig createProvisioningConfig(String parent, ProvisioningConfig provisioningConfig) {
        CreateProvisioningConfigRequest request = CreateProvisioningConfigRequest.newBuilder().setParent(parent).setProvisioningConfig(provisioningConfig).build();
        return this.createProvisioningConfig(request);
    }

    public final ProvisioningConfig createProvisioningConfig(CreateProvisioningConfigRequest request) {
        return (ProvisioningConfig)this.createProvisioningConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProvisioningConfigRequest, ProvisioningConfig> createProvisioningConfigCallable() {
        return this.stub.createProvisioningConfigCallable();
    }

    public final ProvisioningConfig updateProvisioningConfig(ProvisioningConfig provisioningConfig, FieldMask updateMask) {
        UpdateProvisioningConfigRequest request = UpdateProvisioningConfigRequest.newBuilder().setProvisioningConfig(provisioningConfig).setUpdateMask(updateMask).build();
        return this.updateProvisioningConfig(request);
    }

    public final ProvisioningConfig updateProvisioningConfig(UpdateProvisioningConfigRequest request) {
        return (ProvisioningConfig)this.updateProvisioningConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProvisioningConfigRequest, ProvisioningConfig> updateProvisioningConfigCallable() {
        return this.stub.updateProvisioningConfigCallable();
    }

    public final Network renameNetwork(NetworkName name, String newNetworkId) {
        RenameNetworkRequest request = RenameNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).setNewNetworkId(newNetworkId).build();
        return this.renameNetwork(request);
    }

    public final Network renameNetwork(String name, String newNetworkId) {
        RenameNetworkRequest request = RenameNetworkRequest.newBuilder().setName(name).setNewNetworkId(newNetworkId).build();
        return this.renameNetwork(request);
    }

    public final Network renameNetwork(RenameNetworkRequest request) {
        return (Network)this.renameNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<RenameNetworkRequest, Network> renameNetworkCallable() {
        return this.stub.renameNetworkCallable();
    }

    public final ListOSImagesPagedResponse listOSImages(LocationName parent) {
        ListOSImagesRequest request = ListOSImagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOSImages(request);
    }

    public final ListOSImagesPagedResponse listOSImages(String parent) {
        ListOSImagesRequest request = ListOSImagesRequest.newBuilder().setParent(parent).build();
        return this.listOSImages(request);
    }

    public final ListOSImagesPagedResponse listOSImages(ListOSImagesRequest request) {
        return (ListOSImagesPagedResponse)((Object)this.listOSImagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOSImagesRequest, ListOSImagesPagedResponse> listOSImagesPagedCallable() {
        return this.stub.listOSImagesPagedCallable();
    }

    public final UnaryCallable<ListOSImagesRequest, ListOSImagesResponse> listOSImagesCallable() {
        return this.stub.listOSImagesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOSImagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOSImagesRequest, ListOSImagesResponse, OSImage, ListOSImagesPage, ListOSImagesFixedSizeCollection> {
        private ListOSImagesFixedSizeCollection(List<ListOSImagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOSImagesFixedSizeCollection createEmptyCollection() {
            return new ListOSImagesFixedSizeCollection(null, 0);
        }

        protected ListOSImagesFixedSizeCollection createCollection(List<ListOSImagesPage> pages, int collectionSize) {
            return new ListOSImagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOSImagesPage
    extends AbstractPage<ListOSImagesRequest, ListOSImagesResponse, OSImage, ListOSImagesPage> {
        private ListOSImagesPage(PageContext<ListOSImagesRequest, ListOSImagesResponse, OSImage> context, ListOSImagesResponse response) {
            super(context, (Object)response);
        }

        private static ListOSImagesPage createEmptyPage() {
            return new ListOSImagesPage(null, null);
        }

        protected ListOSImagesPage createPage(PageContext<ListOSImagesRequest, ListOSImagesResponse, OSImage> context, ListOSImagesResponse response) {
            return new ListOSImagesPage(context, response);
        }

        public ApiFuture<ListOSImagesPage> createPageAsync(PageContext<ListOSImagesRequest, ListOSImagesResponse, OSImage> context, ApiFuture<ListOSImagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOSImagesPagedResponse
    extends AbstractPagedListResponse<ListOSImagesRequest, ListOSImagesResponse, OSImage, ListOSImagesPage, ListOSImagesFixedSizeCollection> {
        public static ApiFuture<ListOSImagesPagedResponse> createAsync(PageContext<ListOSImagesRequest, ListOSImagesResponse, OSImage> context, ApiFuture<ListOSImagesResponse> futureResponse) {
            ApiFuture<ListOSImagesPage> futurePage = ListOSImagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOSImagesPagedResponse((ListOSImagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOSImagesPagedResponse(ListOSImagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOSImagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProvisioningQuotasFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse, ProvisioningQuota, ListProvisioningQuotasPage, ListProvisioningQuotasFixedSizeCollection> {
        private ListProvisioningQuotasFixedSizeCollection(List<ListProvisioningQuotasPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProvisioningQuotasFixedSizeCollection createEmptyCollection() {
            return new ListProvisioningQuotasFixedSizeCollection(null, 0);
        }

        protected ListProvisioningQuotasFixedSizeCollection createCollection(List<ListProvisioningQuotasPage> pages, int collectionSize) {
            return new ListProvisioningQuotasFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProvisioningQuotasPage
    extends AbstractPage<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse, ProvisioningQuota, ListProvisioningQuotasPage> {
        private ListProvisioningQuotasPage(PageContext<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse, ProvisioningQuota> context, ListProvisioningQuotasResponse response) {
            super(context, (Object)response);
        }

        private static ListProvisioningQuotasPage createEmptyPage() {
            return new ListProvisioningQuotasPage(null, null);
        }

        protected ListProvisioningQuotasPage createPage(PageContext<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse, ProvisioningQuota> context, ListProvisioningQuotasResponse response) {
            return new ListProvisioningQuotasPage(context, response);
        }

        public ApiFuture<ListProvisioningQuotasPage> createPageAsync(PageContext<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse, ProvisioningQuota> context, ApiFuture<ListProvisioningQuotasResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProvisioningQuotasPagedResponse
    extends AbstractPagedListResponse<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse, ProvisioningQuota, ListProvisioningQuotasPage, ListProvisioningQuotasFixedSizeCollection> {
        public static ApiFuture<ListProvisioningQuotasPagedResponse> createAsync(PageContext<ListProvisioningQuotasRequest, ListProvisioningQuotasResponse, ProvisioningQuota> context, ApiFuture<ListProvisioningQuotasResponse> futureResponse) {
            ApiFuture<ListProvisioningQuotasPage> futurePage = ListProvisioningQuotasPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProvisioningQuotasPagedResponse((ListProvisioningQuotasPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProvisioningQuotasPagedResponse(ListProvisioningQuotasPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProvisioningQuotasFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNfsSharesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare, ListNfsSharesPage, ListNfsSharesFixedSizeCollection> {
        private ListNfsSharesFixedSizeCollection(List<ListNfsSharesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNfsSharesFixedSizeCollection createEmptyCollection() {
            return new ListNfsSharesFixedSizeCollection(null, 0);
        }

        protected ListNfsSharesFixedSizeCollection createCollection(List<ListNfsSharesPage> pages, int collectionSize) {
            return new ListNfsSharesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNfsSharesPage
    extends AbstractPage<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare, ListNfsSharesPage> {
        private ListNfsSharesPage(PageContext<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare> context, ListNfsSharesResponse response) {
            super(context, (Object)response);
        }

        private static ListNfsSharesPage createEmptyPage() {
            return new ListNfsSharesPage(null, null);
        }

        protected ListNfsSharesPage createPage(PageContext<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare> context, ListNfsSharesResponse response) {
            return new ListNfsSharesPage(context, response);
        }

        public ApiFuture<ListNfsSharesPage> createPageAsync(PageContext<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare> context, ApiFuture<ListNfsSharesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNfsSharesPagedResponse
    extends AbstractPagedListResponse<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare, ListNfsSharesPage, ListNfsSharesFixedSizeCollection> {
        public static ApiFuture<ListNfsSharesPagedResponse> createAsync(PageContext<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare> context, ApiFuture<ListNfsSharesResponse> futureResponse) {
            ApiFuture<ListNfsSharesPage> futurePage = ListNfsSharesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNfsSharesPagedResponse((ListNfsSharesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNfsSharesPagedResponse(ListNfsSharesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNfsSharesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLunsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLunsRequest, ListLunsResponse, Lun, ListLunsPage, ListLunsFixedSizeCollection> {
        private ListLunsFixedSizeCollection(List<ListLunsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLunsFixedSizeCollection createEmptyCollection() {
            return new ListLunsFixedSizeCollection(null, 0);
        }

        protected ListLunsFixedSizeCollection createCollection(List<ListLunsPage> pages, int collectionSize) {
            return new ListLunsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLunsPage
    extends AbstractPage<ListLunsRequest, ListLunsResponse, Lun, ListLunsPage> {
        private ListLunsPage(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ListLunsResponse response) {
            super(context, (Object)response);
        }

        private static ListLunsPage createEmptyPage() {
            return new ListLunsPage(null, null);
        }

        protected ListLunsPage createPage(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ListLunsResponse response) {
            return new ListLunsPage(context, response);
        }

        public ApiFuture<ListLunsPage> createPageAsync(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ApiFuture<ListLunsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLunsPagedResponse
    extends AbstractPagedListResponse<ListLunsRequest, ListLunsResponse, Lun, ListLunsPage, ListLunsFixedSizeCollection> {
        public static ApiFuture<ListLunsPagedResponse> createAsync(PageContext<ListLunsRequest, ListLunsResponse, Lun> context, ApiFuture<ListLunsResponse> futureResponse) {
            ApiFuture<ListLunsPage> futurePage = ListLunsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLunsPagedResponse((ListLunsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLunsPagedResponse(ListLunsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLunsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVolumeSnapshotsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot, ListVolumeSnapshotsPage, ListVolumeSnapshotsFixedSizeCollection> {
        private ListVolumeSnapshotsFixedSizeCollection(List<ListVolumeSnapshotsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVolumeSnapshotsFixedSizeCollection createEmptyCollection() {
            return new ListVolumeSnapshotsFixedSizeCollection(null, 0);
        }

        protected ListVolumeSnapshotsFixedSizeCollection createCollection(List<ListVolumeSnapshotsPage> pages, int collectionSize) {
            return new ListVolumeSnapshotsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVolumeSnapshotsPage
    extends AbstractPage<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot, ListVolumeSnapshotsPage> {
        private ListVolumeSnapshotsPage(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ListVolumeSnapshotsResponse response) {
            super(context, (Object)response);
        }

        private static ListVolumeSnapshotsPage createEmptyPage() {
            return new ListVolumeSnapshotsPage(null, null);
        }

        protected ListVolumeSnapshotsPage createPage(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ListVolumeSnapshotsResponse response) {
            return new ListVolumeSnapshotsPage(context, response);
        }

        public ApiFuture<ListVolumeSnapshotsPage> createPageAsync(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ApiFuture<ListVolumeSnapshotsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVolumeSnapshotsPagedResponse
    extends AbstractPagedListResponse<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot, ListVolumeSnapshotsPage, ListVolumeSnapshotsFixedSizeCollection> {
        public static ApiFuture<ListVolumeSnapshotsPagedResponse> createAsync(PageContext<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse, VolumeSnapshot> context, ApiFuture<ListVolumeSnapshotsResponse> futureResponse) {
            ApiFuture<ListVolumeSnapshotsPage> futurePage = ListVolumeSnapshotsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVolumeSnapshotsPagedResponse((ListVolumeSnapshotsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVolumeSnapshotsPagedResponse(ListVolumeSnapshotsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVolumeSnapshotsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        private ListNetworksFixedSizeCollection(List<ListNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworksFixedSizeCollection createEmptyCollection() {
            return new ListNetworksFixedSizeCollection(null, 0);
        }

        protected ListNetworksFixedSizeCollection createCollection(List<ListNetworksPage> pages, int collectionSize) {
            return new ListNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworksPage
    extends AbstractPage<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage> {
        private ListNetworksPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListNetworksPage createEmptyPage() {
            return new ListNetworksPage(null, null);
        }

        protected ListNetworksPage createPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            return new ListNetworksPage(context, response);
        }

        public ApiFuture<ListNetworksPage> createPageAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworksPagedResponse
    extends AbstractPagedListResponse<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        public static ApiFuture<ListNetworksPagedResponse> createAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            ApiFuture<ListNetworksPage> futurePage = ListNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworksPagedResponse((ListNetworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworksPagedResponse(ListNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVolumesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage, ListVolumesFixedSizeCollection> {
        private ListVolumesFixedSizeCollection(List<ListVolumesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVolumesFixedSizeCollection createEmptyCollection() {
            return new ListVolumesFixedSizeCollection(null, 0);
        }

        protected ListVolumesFixedSizeCollection createCollection(List<ListVolumesPage> pages, int collectionSize) {
            return new ListVolumesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVolumesPage
    extends AbstractPage<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage> {
        private ListVolumesPage(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ListVolumesResponse response) {
            super(context, (Object)response);
        }

        private static ListVolumesPage createEmptyPage() {
            return new ListVolumesPage(null, null);
        }

        protected ListVolumesPage createPage(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ListVolumesResponse response) {
            return new ListVolumesPage(context, response);
        }

        public ApiFuture<ListVolumesPage> createPageAsync(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ApiFuture<ListVolumesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVolumesPagedResponse
    extends AbstractPagedListResponse<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage, ListVolumesFixedSizeCollection> {
        public static ApiFuture<ListVolumesPagedResponse> createAsync(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ApiFuture<ListVolumesResponse> futureResponse) {
            ApiFuture<ListVolumesPage> futurePage = ListVolumesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVolumesPagedResponse((ListVolumesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVolumesPagedResponse(ListVolumesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVolumesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSSHKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSSHKeysRequest, ListSSHKeysResponse, SSHKey, ListSSHKeysPage, ListSSHKeysFixedSizeCollection> {
        private ListSSHKeysFixedSizeCollection(List<ListSSHKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSSHKeysFixedSizeCollection createEmptyCollection() {
            return new ListSSHKeysFixedSizeCollection(null, 0);
        }

        protected ListSSHKeysFixedSizeCollection createCollection(List<ListSSHKeysPage> pages, int collectionSize) {
            return new ListSSHKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSSHKeysPage
    extends AbstractPage<ListSSHKeysRequest, ListSSHKeysResponse, SSHKey, ListSSHKeysPage> {
        private ListSSHKeysPage(PageContext<ListSSHKeysRequest, ListSSHKeysResponse, SSHKey> context, ListSSHKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListSSHKeysPage createEmptyPage() {
            return new ListSSHKeysPage(null, null);
        }

        protected ListSSHKeysPage createPage(PageContext<ListSSHKeysRequest, ListSSHKeysResponse, SSHKey> context, ListSSHKeysResponse response) {
            return new ListSSHKeysPage(context, response);
        }

        public ApiFuture<ListSSHKeysPage> createPageAsync(PageContext<ListSSHKeysRequest, ListSSHKeysResponse, SSHKey> context, ApiFuture<ListSSHKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSSHKeysPagedResponse
    extends AbstractPagedListResponse<ListSSHKeysRequest, ListSSHKeysResponse, SSHKey, ListSSHKeysPage, ListSSHKeysFixedSizeCollection> {
        public static ApiFuture<ListSSHKeysPagedResponse> createAsync(PageContext<ListSSHKeysRequest, ListSSHKeysResponse, SSHKey> context, ApiFuture<ListSSHKeysResponse> futureResponse) {
            ApiFuture<ListSSHKeysPage> futurePage = ListSSHKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSSHKeysPagedResponse((ListSSHKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSSHKeysPagedResponse(ListSSHKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSSHKeysFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

