/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.assuredworkloads.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.assuredworkloads.v1.AcknowledgeViolationRequest;
import com.google.cloud.assuredworkloads.v1.AcknowledgeViolationResponse;
import com.google.cloud.assuredworkloads.v1.AssuredWorkloadsServiceClient;
import com.google.cloud.assuredworkloads.v1.CreateWorkloadOperationMetadata;
import com.google.cloud.assuredworkloads.v1.CreateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.DeleteWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.GetViolationRequest;
import com.google.cloud.assuredworkloads.v1.GetWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.ListViolationsRequest;
import com.google.cloud.assuredworkloads.v1.ListViolationsResponse;
import com.google.cloud.assuredworkloads.v1.ListWorkloadsRequest;
import com.google.cloud.assuredworkloads.v1.ListWorkloadsResponse;
import com.google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest;
import com.google.cloud.assuredworkloads.v1.RestrictAllowedResourcesResponse;
import com.google.cloud.assuredworkloads.v1.UpdateWorkloadRequest;
import com.google.cloud.assuredworkloads.v1.Violation;
import com.google.cloud.assuredworkloads.v1.Workload;
import com.google.cloud.assuredworkloads.v1.stub.AssuredWorkloadsServiceStub;
import com.google.cloud.assuredworkloads.v1.stub.AssuredWorkloadsServiceStubSettings;
import com.google.cloud.assuredworkloads.v1.stub.GrpcAssuredWorkloadsServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAssuredWorkloadsServiceStub
extends AssuredWorkloadsServiceStub {
    private static final MethodDescriptor<CreateWorkloadRequest, Operation> createWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/CreateWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateWorkloadRequest, Workload> updateWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/UpdateWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Workload.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/RestrictAllowedResources").setRequestMarshaller(ProtoUtils.marshaller((Message)RestrictAllowedResourcesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RestrictAllowedResourcesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteWorkloadRequest, Empty> deleteWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/DeleteWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetWorkloadRequest, Workload> getWorkloadMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetWorkload").setRequestMarshaller(ProtoUtils.marshaller((Message)GetWorkloadRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Workload.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListWorkloads").setRequestMarshaller(ProtoUtils.marshaller((Message)ListWorkloadsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListWorkloadsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListViolationsRequest, ListViolationsResponse> listViolationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListViolations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListViolationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListViolationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetViolationRequest, Violation> getViolationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetViolation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetViolationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Violation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AcknowledgeViolationRequest, AcknowledgeViolationResponse> acknowledgeViolationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.assuredworkloads.v1.AssuredWorkloadsService/AcknowledgeViolation").setRequestMarshaller(ProtoUtils.marshaller((Message)AcknowledgeViolationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AcknowledgeViolationResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateWorkloadRequest, Operation> createWorkloadCallable;
    private final OperationCallable<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationCallable;
    private final UnaryCallable<UpdateWorkloadRequest, Workload> updateWorkloadCallable;
    private final UnaryCallable<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesCallable;
    private final UnaryCallable<DeleteWorkloadRequest, Empty> deleteWorkloadCallable;
    private final UnaryCallable<GetWorkloadRequest, Workload> getWorkloadCallable;
    private final UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable;
    private final UnaryCallable<ListWorkloadsRequest, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsPagedCallable;
    private final UnaryCallable<ListViolationsRequest, ListViolationsResponse> listViolationsCallable;
    private final UnaryCallable<ListViolationsRequest, AssuredWorkloadsServiceClient.ListViolationsPagedResponse> listViolationsPagedCallable;
    private final UnaryCallable<GetViolationRequest, Violation> getViolationCallable;
    private final UnaryCallable<AcknowledgeViolationRequest, AcknowledgeViolationResponse> acknowledgeViolationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssuredWorkloadsServiceStub create(AssuredWorkloadsServiceStubSettings settings) throws IOException {
        return new GrpcAssuredWorkloadsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssuredWorkloadsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssuredWorkloadsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAssuredWorkloadsServiceCallableFactory());
    }

    protected GrpcAssuredWorkloadsServiceStub(AssuredWorkloadsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWorkloadMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateWorkloadMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("workload.name", String.valueOf(request.getWorkload().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings restrictAllowedResourcesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restrictAllowedResourcesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteWorkloadMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getWorkloadTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWorkloadMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listWorkloadsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listWorkloadsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listViolationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listViolationsMethodDescriptor).build();
        GrpcCallSettings getViolationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getViolationMethodDescriptor).build();
        GrpcCallSettings acknowledgeViolationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(acknowledgeViolationMethodDescriptor).build();
        this.createWorkloadCallable = callableFactory.createUnaryCallable(createWorkloadTransportSettings, settings.createWorkloadSettings(), clientContext);
        this.createWorkloadOperationCallable = callableFactory.createOperationCallable(createWorkloadTransportSettings, settings.createWorkloadOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateWorkloadCallable = callableFactory.createUnaryCallable(updateWorkloadTransportSettings, settings.updateWorkloadSettings(), clientContext);
        this.restrictAllowedResourcesCallable = callableFactory.createUnaryCallable(restrictAllowedResourcesTransportSettings, settings.restrictAllowedResourcesSettings(), clientContext);
        this.deleteWorkloadCallable = callableFactory.createUnaryCallable(deleteWorkloadTransportSettings, settings.deleteWorkloadSettings(), clientContext);
        this.getWorkloadCallable = callableFactory.createUnaryCallable(getWorkloadTransportSettings, settings.getWorkloadSettings(), clientContext);
        this.listWorkloadsCallable = callableFactory.createUnaryCallable(listWorkloadsTransportSettings, settings.listWorkloadsSettings(), clientContext);
        this.listWorkloadsPagedCallable = callableFactory.createPagedCallable(listWorkloadsTransportSettings, settings.listWorkloadsSettings(), clientContext);
        this.listViolationsCallable = callableFactory.createUnaryCallable(listViolationsTransportSettings, settings.listViolationsSettings(), clientContext);
        this.listViolationsPagedCallable = callableFactory.createPagedCallable(listViolationsTransportSettings, settings.listViolationsSettings(), clientContext);
        this.getViolationCallable = callableFactory.createUnaryCallable(getViolationTransportSettings, settings.getViolationSettings(), clientContext);
        this.acknowledgeViolationCallable = callableFactory.createUnaryCallable(acknowledgeViolationTransportSettings, settings.acknowledgeViolationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateWorkloadRequest, Operation> createWorkloadCallable() {
        return this.createWorkloadCallable;
    }

    @Override
    public OperationCallable<CreateWorkloadRequest, Workload, CreateWorkloadOperationMetadata> createWorkloadOperationCallable() {
        return this.createWorkloadOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkloadRequest, Workload> updateWorkloadCallable() {
        return this.updateWorkloadCallable;
    }

    @Override
    public UnaryCallable<RestrictAllowedResourcesRequest, RestrictAllowedResourcesResponse> restrictAllowedResourcesCallable() {
        return this.restrictAllowedResourcesCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkloadRequest, Empty> deleteWorkloadCallable() {
        return this.deleteWorkloadCallable;
    }

    @Override
    public UnaryCallable<GetWorkloadRequest, Workload> getWorkloadCallable() {
        return this.getWorkloadCallable;
    }

    @Override
    public UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable() {
        return this.listWorkloadsCallable;
    }

    @Override
    public UnaryCallable<ListWorkloadsRequest, AssuredWorkloadsServiceClient.ListWorkloadsPagedResponse> listWorkloadsPagedCallable() {
        return this.listWorkloadsPagedCallable;
    }

    @Override
    public UnaryCallable<ListViolationsRequest, ListViolationsResponse> listViolationsCallable() {
        return this.listViolationsCallable;
    }

    @Override
    public UnaryCallable<ListViolationsRequest, AssuredWorkloadsServiceClient.ListViolationsPagedResponse> listViolationsPagedCallable() {
        return this.listViolationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetViolationRequest, Violation> getViolationCallable() {
        return this.getViolationCallable;
    }

    @Override
    public UnaryCallable<AcknowledgeViolationRequest, AcknowledgeViolationResponse> acknowledgeViolationCallable() {
        return this.acknowledgeViolationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

