/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningMetadata;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest;
import com.google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse;
import com.google.cloud.asset.v1.AnalyzeIamPolicyRequest;
import com.google.cloud.asset.v1.AnalyzeIamPolicyResponse;
import com.google.cloud.asset.v1.AnalyzeMoveRequest;
import com.google.cloud.asset.v1.AnalyzeMoveResponse;
import com.google.cloud.asset.v1.AnalyzeOrgPoliciesRequest;
import com.google.cloud.asset.v1.AnalyzeOrgPoliciesResponse;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest;
import com.google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse;
import com.google.cloud.asset.v1.Asset;
import com.google.cloud.asset.v1.AssetServiceSettings;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryRequest;
import com.google.cloud.asset.v1.BatchGetAssetsHistoryResponse;
import com.google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest;
import com.google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse;
import com.google.cloud.asset.v1.CreateFeedRequest;
import com.google.cloud.asset.v1.CreateSavedQueryRequest;
import com.google.cloud.asset.v1.DeleteFeedRequest;
import com.google.cloud.asset.v1.DeleteSavedQueryRequest;
import com.google.cloud.asset.v1.ExportAssetsRequest;
import com.google.cloud.asset.v1.ExportAssetsResponse;
import com.google.cloud.asset.v1.Feed;
import com.google.cloud.asset.v1.FeedName;
import com.google.cloud.asset.v1.FolderName;
import com.google.cloud.asset.v1.GetFeedRequest;
import com.google.cloud.asset.v1.GetSavedQueryRequest;
import com.google.cloud.asset.v1.IamPolicySearchResult;
import com.google.cloud.asset.v1.ListAssetsRequest;
import com.google.cloud.asset.v1.ListAssetsResponse;
import com.google.cloud.asset.v1.ListFeedsRequest;
import com.google.cloud.asset.v1.ListFeedsResponse;
import com.google.cloud.asset.v1.ListSavedQueriesRequest;
import com.google.cloud.asset.v1.ListSavedQueriesResponse;
import com.google.cloud.asset.v1.OrganizationName;
import com.google.cloud.asset.v1.ProjectName;
import com.google.cloud.asset.v1.QueryAssetsRequest;
import com.google.cloud.asset.v1.QueryAssetsResponse;
import com.google.cloud.asset.v1.ResourceSearchResult;
import com.google.cloud.asset.v1.SavedQuery;
import com.google.cloud.asset.v1.SavedQueryName;
import com.google.cloud.asset.v1.SearchAllIamPoliciesRequest;
import com.google.cloud.asset.v1.SearchAllIamPoliciesResponse;
import com.google.cloud.asset.v1.SearchAllResourcesRequest;
import com.google.cloud.asset.v1.SearchAllResourcesResponse;
import com.google.cloud.asset.v1.UpdateFeedRequest;
import com.google.cloud.asset.v1.UpdateSavedQueryRequest;
import com.google.cloud.asset.v1.stub.AssetServiceStub;
import com.google.cloud.asset.v1.stub.AssetServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AssetServiceClient
implements BackgroundResource {
    private final AssetServiceSettings settings;
    private final AssetServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AssetServiceClient create() throws IOException {
        return AssetServiceClient.create(AssetServiceSettings.newBuilder().build());
    }

    public static final AssetServiceClient create(AssetServiceSettings settings) throws IOException {
        return new AssetServiceClient(settings);
    }

    public static final AssetServiceClient create(AssetServiceStub stub) {
        return new AssetServiceClient(stub);
    }

    protected AssetServiceClient(AssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AssetServiceClient(AssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AssetServiceSettings getSettings() {
        return this.settings;
    }

    public AssetServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<ExportAssetsResponse, ExportAssetsRequest> exportAssetsAsync(ExportAssetsRequest request) {
        return this.exportAssetsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationCallable() {
        return this.stub.exportAssetsOperationCallable();
    }

    public final UnaryCallable<ExportAssetsRequest, Operation> exportAssetsCallable() {
        return this.stub.exportAssetsCallable();
    }

    public final ListAssetsPagedResponse listAssets(ResourceName parent) {
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAssets(request);
    }

    public final ListAssetsPagedResponse listAssets(String parent) {
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(parent).build();
        return this.listAssets(request);
    }

    public final ListAssetsPagedResponse listAssets(ListAssetsRequest request) {
        return (ListAssetsPagedResponse)((Object)this.listAssetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsPagedResponse> listAssetsPagedCallable() {
        return this.stub.listAssetsPagedCallable();
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsResponse> listAssetsCallable() {
        return this.stub.listAssetsCallable();
    }

    public final BatchGetAssetsHistoryResponse batchGetAssetsHistory(BatchGetAssetsHistoryRequest request) {
        return (BatchGetAssetsHistoryResponse)this.batchGetAssetsHistoryCallable().call((Object)request);
    }

    public final UnaryCallable<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistoryCallable() {
        return this.stub.batchGetAssetsHistoryCallable();
    }

    public final Feed createFeed(String parent) {
        CreateFeedRequest request = CreateFeedRequest.newBuilder().setParent(parent).build();
        return this.createFeed(request);
    }

    public final Feed createFeed(CreateFeedRequest request) {
        return (Feed)this.createFeedCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFeedRequest, Feed> createFeedCallable() {
        return this.stub.createFeedCallable();
    }

    public final Feed getFeed(FeedName name) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(String name) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setName(name).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(GetFeedRequest request) {
        return (Feed)this.getFeedCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.stub.getFeedCallable();
    }

    public final ListFeedsResponse listFeeds(String parent) {
        ListFeedsRequest request = ListFeedsRequest.newBuilder().setParent(parent).build();
        return this.listFeeds(request);
    }

    public final ListFeedsResponse listFeeds(ListFeedsRequest request) {
        return (ListFeedsResponse)this.listFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable() {
        return this.stub.listFeedsCallable();
    }

    public final Feed updateFeed(Feed feed) {
        UpdateFeedRequest request = UpdateFeedRequest.newBuilder().setFeed(feed).build();
        return this.updateFeed(request);
    }

    public final Feed updateFeed(UpdateFeedRequest request) {
        return (Feed)this.updateFeedCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable() {
        return this.stub.updateFeedCallable();
    }

    public final void deleteFeed(FeedName name) {
        DeleteFeedRequest request = DeleteFeedRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFeed(request);
    }

    public final void deleteFeed(String name) {
        DeleteFeedRequest request = DeleteFeedRequest.newBuilder().setName(name).build();
        this.deleteFeed(request);
    }

    public final void deleteFeed(DeleteFeedRequest request) {
        this.deleteFeedCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable() {
        return this.stub.deleteFeedCallable();
    }

    public final SearchAllResourcesPagedResponse searchAllResources(String scope, String query, List<String> assetTypes) {
        SearchAllResourcesRequest request = SearchAllResourcesRequest.newBuilder().setScope(scope).setQuery(query).addAllAssetTypes(assetTypes).build();
        return this.searchAllResources(request);
    }

    public final SearchAllResourcesPagedResponse searchAllResources(SearchAllResourcesRequest request) {
        return (SearchAllResourcesPagedResponse)((Object)this.searchAllResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesPagedResponse> searchAllResourcesPagedCallable() {
        return this.stub.searchAllResourcesPagedCallable();
    }

    public final UnaryCallable<SearchAllResourcesRequest, SearchAllResourcesResponse> searchAllResourcesCallable() {
        return this.stub.searchAllResourcesCallable();
    }

    public final SearchAllIamPoliciesPagedResponse searchAllIamPolicies(String scope, String query) {
        SearchAllIamPoliciesRequest request = SearchAllIamPoliciesRequest.newBuilder().setScope(scope).setQuery(query).build();
        return this.searchAllIamPolicies(request);
    }

    public final SearchAllIamPoliciesPagedResponse searchAllIamPolicies(SearchAllIamPoliciesRequest request) {
        return (SearchAllIamPoliciesPagedResponse)((Object)this.searchAllIamPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesPagedResponse> searchAllIamPoliciesPagedCallable() {
        return this.stub.searchAllIamPoliciesPagedCallable();
    }

    public final UnaryCallable<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse> searchAllIamPoliciesCallable() {
        return this.stub.searchAllIamPoliciesCallable();
    }

    public final AnalyzeIamPolicyResponse analyzeIamPolicy(AnalyzeIamPolicyRequest request) {
        return (AnalyzeIamPolicyResponse)this.analyzeIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeIamPolicyRequest, AnalyzeIamPolicyResponse> analyzeIamPolicyCallable() {
        return this.stub.analyzeIamPolicyCallable();
    }

    public final OperationFuture<AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningMetadata> analyzeIamPolicyLongrunningAsync(AnalyzeIamPolicyLongrunningRequest request) {
        return this.analyzeIamPolicyLongrunningOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AnalyzeIamPolicyLongrunningRequest, AnalyzeIamPolicyLongrunningResponse, AnalyzeIamPolicyLongrunningMetadata> analyzeIamPolicyLongrunningOperationCallable() {
        return this.stub.analyzeIamPolicyLongrunningOperationCallable();
    }

    public final UnaryCallable<AnalyzeIamPolicyLongrunningRequest, Operation> analyzeIamPolicyLongrunningCallable() {
        return this.stub.analyzeIamPolicyLongrunningCallable();
    }

    public final AnalyzeMoveResponse analyzeMove(AnalyzeMoveRequest request) {
        return (AnalyzeMoveResponse)this.analyzeMoveCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeMoveRequest, AnalyzeMoveResponse> analyzeMoveCallable() {
        return this.stub.analyzeMoveCallable();
    }

    public final QueryAssetsResponse queryAssets(QueryAssetsRequest request) {
        return (QueryAssetsResponse)this.queryAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<QueryAssetsRequest, QueryAssetsResponse> queryAssetsCallable() {
        return this.stub.queryAssetsCallable();
    }

    public final SavedQuery createSavedQuery(FolderName parent, SavedQuery savedQuery, String savedQueryId) {
        CreateSavedQueryRequest request = CreateSavedQueryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSavedQuery(savedQuery).setSavedQueryId(savedQueryId).build();
        return this.createSavedQuery(request);
    }

    public final SavedQuery createSavedQuery(OrganizationName parent, SavedQuery savedQuery, String savedQueryId) {
        CreateSavedQueryRequest request = CreateSavedQueryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSavedQuery(savedQuery).setSavedQueryId(savedQueryId).build();
        return this.createSavedQuery(request);
    }

    public final SavedQuery createSavedQuery(ProjectName parent, SavedQuery savedQuery, String savedQueryId) {
        CreateSavedQueryRequest request = CreateSavedQueryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSavedQuery(savedQuery).setSavedQueryId(savedQueryId).build();
        return this.createSavedQuery(request);
    }

    public final SavedQuery createSavedQuery(String parent, SavedQuery savedQuery, String savedQueryId) {
        CreateSavedQueryRequest request = CreateSavedQueryRequest.newBuilder().setParent(parent).setSavedQuery(savedQuery).setSavedQueryId(savedQueryId).build();
        return this.createSavedQuery(request);
    }

    public final SavedQuery createSavedQuery(CreateSavedQueryRequest request) {
        return (SavedQuery)this.createSavedQueryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSavedQueryRequest, SavedQuery> createSavedQueryCallable() {
        return this.stub.createSavedQueryCallable();
    }

    public final SavedQuery getSavedQuery(SavedQueryName name) {
        GetSavedQueryRequest request = GetSavedQueryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSavedQuery(request);
    }

    public final SavedQuery getSavedQuery(String name) {
        GetSavedQueryRequest request = GetSavedQueryRequest.newBuilder().setName(name).build();
        return this.getSavedQuery(request);
    }

    public final SavedQuery getSavedQuery(GetSavedQueryRequest request) {
        return (SavedQuery)this.getSavedQueryCallable().call((Object)request);
    }

    public final UnaryCallable<GetSavedQueryRequest, SavedQuery> getSavedQueryCallable() {
        return this.stub.getSavedQueryCallable();
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(FolderName parent) {
        ListSavedQueriesRequest request = ListSavedQueriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSavedQueries(request);
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(OrganizationName parent) {
        ListSavedQueriesRequest request = ListSavedQueriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSavedQueries(request);
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(ProjectName parent) {
        ListSavedQueriesRequest request = ListSavedQueriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSavedQueries(request);
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(String parent) {
        ListSavedQueriesRequest request = ListSavedQueriesRequest.newBuilder().setParent(parent).build();
        return this.listSavedQueries(request);
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(ListSavedQueriesRequest request) {
        return (ListSavedQueriesPagedResponse)((Object)this.listSavedQueriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesPagedResponse> listSavedQueriesPagedCallable() {
        return this.stub.listSavedQueriesPagedCallable();
    }

    public final UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesResponse> listSavedQueriesCallable() {
        return this.stub.listSavedQueriesCallable();
    }

    public final SavedQuery updateSavedQuery(SavedQuery savedQuery, FieldMask updateMask) {
        UpdateSavedQueryRequest request = UpdateSavedQueryRequest.newBuilder().setSavedQuery(savedQuery).setUpdateMask(updateMask).build();
        return this.updateSavedQuery(request);
    }

    public final SavedQuery updateSavedQuery(UpdateSavedQueryRequest request) {
        return (SavedQuery)this.updateSavedQueryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSavedQueryRequest, SavedQuery> updateSavedQueryCallable() {
        return this.stub.updateSavedQueryCallable();
    }

    public final void deleteSavedQuery(SavedQueryName name) {
        DeleteSavedQueryRequest request = DeleteSavedQueryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSavedQuery(request);
    }

    public final void deleteSavedQuery(String name) {
        DeleteSavedQueryRequest request = DeleteSavedQueryRequest.newBuilder().setName(name).build();
        this.deleteSavedQuery(request);
    }

    public final void deleteSavedQuery(DeleteSavedQueryRequest request) {
        this.deleteSavedQueryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSavedQueryRequest, Empty> deleteSavedQueryCallable() {
        return this.stub.deleteSavedQueryCallable();
    }

    public final BatchGetEffectiveIamPoliciesResponse batchGetEffectiveIamPolicies(BatchGetEffectiveIamPoliciesRequest request) {
        return (BatchGetEffectiveIamPoliciesResponse)this.batchGetEffectiveIamPoliciesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchGetEffectiveIamPoliciesRequest, BatchGetEffectiveIamPoliciesResponse> batchGetEffectiveIamPoliciesCallable() {
        return this.stub.batchGetEffectiveIamPoliciesCallable();
    }

    public final AnalyzeOrgPoliciesPagedResponse analyzeOrgPolicies(String scope, String constraint, String filter) {
        AnalyzeOrgPoliciesRequest request = AnalyzeOrgPoliciesRequest.newBuilder().setScope(scope).setConstraint(constraint).setFilter(filter).build();
        return this.analyzeOrgPolicies(request);
    }

    public final AnalyzeOrgPoliciesPagedResponse analyzeOrgPolicies(AnalyzeOrgPoliciesRequest request) {
        return (AnalyzeOrgPoliciesPagedResponse)((Object)this.analyzeOrgPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesPagedResponse> analyzeOrgPoliciesPagedCallable() {
        return this.stub.analyzeOrgPoliciesPagedCallable();
    }

    public final UnaryCallable<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse> analyzeOrgPoliciesCallable() {
        return this.stub.analyzeOrgPoliciesCallable();
    }

    public final AnalyzeOrgPolicyGovernedContainersPagedResponse analyzeOrgPolicyGovernedContainers(String scope, String constraint, String filter) {
        AnalyzeOrgPolicyGovernedContainersRequest request = AnalyzeOrgPolicyGovernedContainersRequest.newBuilder().setScope(scope).setConstraint(constraint).setFilter(filter).build();
        return this.analyzeOrgPolicyGovernedContainers(request);
    }

    public final AnalyzeOrgPolicyGovernedContainersPagedResponse analyzeOrgPolicyGovernedContainers(AnalyzeOrgPolicyGovernedContainersRequest request) {
        return (AnalyzeOrgPolicyGovernedContainersPagedResponse)((Object)this.analyzeOrgPolicyGovernedContainersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersPagedResponse> analyzeOrgPolicyGovernedContainersPagedCallable() {
        return this.stub.analyzeOrgPolicyGovernedContainersPagedCallable();
    }

    public final UnaryCallable<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse> analyzeOrgPolicyGovernedContainersCallable() {
        return this.stub.analyzeOrgPolicyGovernedContainersCallable();
    }

    public final AnalyzeOrgPolicyGovernedAssetsPagedResponse analyzeOrgPolicyGovernedAssets(String scope, String constraint, String filter) {
        AnalyzeOrgPolicyGovernedAssetsRequest request = AnalyzeOrgPolicyGovernedAssetsRequest.newBuilder().setScope(scope).setConstraint(constraint).setFilter(filter).build();
        return this.analyzeOrgPolicyGovernedAssets(request);
    }

    public final AnalyzeOrgPolicyGovernedAssetsPagedResponse analyzeOrgPolicyGovernedAssets(AnalyzeOrgPolicyGovernedAssetsRequest request) {
        return (AnalyzeOrgPolicyGovernedAssetsPagedResponse)((Object)this.analyzeOrgPolicyGovernedAssetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsPagedResponse> analyzeOrgPolicyGovernedAssetsPagedCallable() {
        return this.stub.analyzeOrgPolicyGovernedAssetsPagedCallable();
    }

    public final UnaryCallable<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse> analyzeOrgPolicyGovernedAssetsCallable() {
        return this.stub.analyzeOrgPolicyGovernedAssetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection
    extends AbstractFixedSizeCollection<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset, AnalyzeOrgPolicyGovernedAssetsPage, AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection> {
        private AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection(List<AnalyzeOrgPolicyGovernedAssetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection createEmptyCollection() {
            return new AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection(null, 0);
        }

        protected AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection createCollection(List<AnalyzeOrgPolicyGovernedAssetsPage> pages, int collectionSize) {
            return new AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AnalyzeOrgPolicyGovernedAssetsPage
    extends AbstractPage<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset, AnalyzeOrgPolicyGovernedAssetsPage> {
        private AnalyzeOrgPolicyGovernedAssetsPage(PageContext<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset> context, AnalyzeOrgPolicyGovernedAssetsResponse response) {
            super(context, (Object)response);
        }

        private static AnalyzeOrgPolicyGovernedAssetsPage createEmptyPage() {
            return new AnalyzeOrgPolicyGovernedAssetsPage(null, null);
        }

        protected AnalyzeOrgPolicyGovernedAssetsPage createPage(PageContext<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset> context, AnalyzeOrgPolicyGovernedAssetsResponse response) {
            return new AnalyzeOrgPolicyGovernedAssetsPage(context, response);
        }

        public ApiFuture<AnalyzeOrgPolicyGovernedAssetsPage> createPageAsync(PageContext<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset> context, ApiFuture<AnalyzeOrgPolicyGovernedAssetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AnalyzeOrgPolicyGovernedAssetsPagedResponse
    extends AbstractPagedListResponse<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset, AnalyzeOrgPolicyGovernedAssetsPage, AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection> {
        public static ApiFuture<AnalyzeOrgPolicyGovernedAssetsPagedResponse> createAsync(PageContext<AnalyzeOrgPolicyGovernedAssetsRequest, AnalyzeOrgPolicyGovernedAssetsResponse, AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset> context, ApiFuture<AnalyzeOrgPolicyGovernedAssetsResponse> futureResponse) {
            ApiFuture<AnalyzeOrgPolicyGovernedAssetsPage> futurePage = AnalyzeOrgPolicyGovernedAssetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AnalyzeOrgPolicyGovernedAssetsPagedResponse((AnalyzeOrgPolicyGovernedAssetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AnalyzeOrgPolicyGovernedAssetsPagedResponse(AnalyzeOrgPolicyGovernedAssetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AnalyzeOrgPolicyGovernedAssetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AnalyzeOrgPolicyGovernedContainersFixedSizeCollection
    extends AbstractFixedSizeCollection<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer, AnalyzeOrgPolicyGovernedContainersPage, AnalyzeOrgPolicyGovernedContainersFixedSizeCollection> {
        private AnalyzeOrgPolicyGovernedContainersFixedSizeCollection(List<AnalyzeOrgPolicyGovernedContainersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AnalyzeOrgPolicyGovernedContainersFixedSizeCollection createEmptyCollection() {
            return new AnalyzeOrgPolicyGovernedContainersFixedSizeCollection(null, 0);
        }

        protected AnalyzeOrgPolicyGovernedContainersFixedSizeCollection createCollection(List<AnalyzeOrgPolicyGovernedContainersPage> pages, int collectionSize) {
            return new AnalyzeOrgPolicyGovernedContainersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AnalyzeOrgPolicyGovernedContainersPage
    extends AbstractPage<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer, AnalyzeOrgPolicyGovernedContainersPage> {
        private AnalyzeOrgPolicyGovernedContainersPage(PageContext<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer> context, AnalyzeOrgPolicyGovernedContainersResponse response) {
            super(context, (Object)response);
        }

        private static AnalyzeOrgPolicyGovernedContainersPage createEmptyPage() {
            return new AnalyzeOrgPolicyGovernedContainersPage(null, null);
        }

        protected AnalyzeOrgPolicyGovernedContainersPage createPage(PageContext<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer> context, AnalyzeOrgPolicyGovernedContainersResponse response) {
            return new AnalyzeOrgPolicyGovernedContainersPage(context, response);
        }

        public ApiFuture<AnalyzeOrgPolicyGovernedContainersPage> createPageAsync(PageContext<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer> context, ApiFuture<AnalyzeOrgPolicyGovernedContainersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AnalyzeOrgPolicyGovernedContainersPagedResponse
    extends AbstractPagedListResponse<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer, AnalyzeOrgPolicyGovernedContainersPage, AnalyzeOrgPolicyGovernedContainersFixedSizeCollection> {
        public static ApiFuture<AnalyzeOrgPolicyGovernedContainersPagedResponse> createAsync(PageContext<AnalyzeOrgPolicyGovernedContainersRequest, AnalyzeOrgPolicyGovernedContainersResponse, AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer> context, ApiFuture<AnalyzeOrgPolicyGovernedContainersResponse> futureResponse) {
            ApiFuture<AnalyzeOrgPolicyGovernedContainersPage> futurePage = AnalyzeOrgPolicyGovernedContainersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AnalyzeOrgPolicyGovernedContainersPagedResponse((AnalyzeOrgPolicyGovernedContainersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AnalyzeOrgPolicyGovernedContainersPagedResponse(AnalyzeOrgPolicyGovernedContainersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AnalyzeOrgPolicyGovernedContainersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AnalyzeOrgPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult, AnalyzeOrgPoliciesPage, AnalyzeOrgPoliciesFixedSizeCollection> {
        private AnalyzeOrgPoliciesFixedSizeCollection(List<AnalyzeOrgPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AnalyzeOrgPoliciesFixedSizeCollection createEmptyCollection() {
            return new AnalyzeOrgPoliciesFixedSizeCollection(null, 0);
        }

        protected AnalyzeOrgPoliciesFixedSizeCollection createCollection(List<AnalyzeOrgPoliciesPage> pages, int collectionSize) {
            return new AnalyzeOrgPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AnalyzeOrgPoliciesPage
    extends AbstractPage<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult, AnalyzeOrgPoliciesPage> {
        private AnalyzeOrgPoliciesPage(PageContext<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult> context, AnalyzeOrgPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static AnalyzeOrgPoliciesPage createEmptyPage() {
            return new AnalyzeOrgPoliciesPage(null, null);
        }

        protected AnalyzeOrgPoliciesPage createPage(PageContext<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult> context, AnalyzeOrgPoliciesResponse response) {
            return new AnalyzeOrgPoliciesPage(context, response);
        }

        public ApiFuture<AnalyzeOrgPoliciesPage> createPageAsync(PageContext<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult> context, ApiFuture<AnalyzeOrgPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AnalyzeOrgPoliciesPagedResponse
    extends AbstractPagedListResponse<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult, AnalyzeOrgPoliciesPage, AnalyzeOrgPoliciesFixedSizeCollection> {
        public static ApiFuture<AnalyzeOrgPoliciesPagedResponse> createAsync(PageContext<AnalyzeOrgPoliciesRequest, AnalyzeOrgPoliciesResponse, AnalyzeOrgPoliciesResponse.OrgPolicyResult> context, ApiFuture<AnalyzeOrgPoliciesResponse> futureResponse) {
            ApiFuture<AnalyzeOrgPoliciesPage> futurePage = AnalyzeOrgPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AnalyzeOrgPoliciesPagedResponse((AnalyzeOrgPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AnalyzeOrgPoliciesPagedResponse(AnalyzeOrgPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AnalyzeOrgPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSavedQueriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery, ListSavedQueriesPage, ListSavedQueriesFixedSizeCollection> {
        private ListSavedQueriesFixedSizeCollection(List<ListSavedQueriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSavedQueriesFixedSizeCollection createEmptyCollection() {
            return new ListSavedQueriesFixedSizeCollection(null, 0);
        }

        protected ListSavedQueriesFixedSizeCollection createCollection(List<ListSavedQueriesPage> pages, int collectionSize) {
            return new ListSavedQueriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSavedQueriesPage
    extends AbstractPage<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery, ListSavedQueriesPage> {
        private ListSavedQueriesPage(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ListSavedQueriesResponse response) {
            super(context, (Object)response);
        }

        private static ListSavedQueriesPage createEmptyPage() {
            return new ListSavedQueriesPage(null, null);
        }

        protected ListSavedQueriesPage createPage(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ListSavedQueriesResponse response) {
            return new ListSavedQueriesPage(context, response);
        }

        public ApiFuture<ListSavedQueriesPage> createPageAsync(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ApiFuture<ListSavedQueriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSavedQueriesPagedResponse
    extends AbstractPagedListResponse<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery, ListSavedQueriesPage, ListSavedQueriesFixedSizeCollection> {
        public static ApiFuture<ListSavedQueriesPagedResponse> createAsync(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ApiFuture<ListSavedQueriesResponse> futureResponse) {
            ApiFuture<ListSavedQueriesPage> futurePage = ListSavedQueriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSavedQueriesPagedResponse((ListSavedQueriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSavedQueriesPagedResponse(ListSavedQueriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSavedQueriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchAllIamPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage, SearchAllIamPoliciesFixedSizeCollection> {
        private SearchAllIamPoliciesFixedSizeCollection(List<SearchAllIamPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAllIamPoliciesFixedSizeCollection createEmptyCollection() {
            return new SearchAllIamPoliciesFixedSizeCollection(null, 0);
        }

        protected SearchAllIamPoliciesFixedSizeCollection createCollection(List<SearchAllIamPoliciesPage> pages, int collectionSize) {
            return new SearchAllIamPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAllIamPoliciesPage
    extends AbstractPage<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage> {
        private SearchAllIamPoliciesPage(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, SearchAllIamPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static SearchAllIamPoliciesPage createEmptyPage() {
            return new SearchAllIamPoliciesPage(null, null);
        }

        protected SearchAllIamPoliciesPage createPage(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, SearchAllIamPoliciesResponse response) {
            return new SearchAllIamPoliciesPage(context, response);
        }

        public ApiFuture<SearchAllIamPoliciesPage> createPageAsync(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAllIamPoliciesPagedResponse
    extends AbstractPagedListResponse<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult, SearchAllIamPoliciesPage, SearchAllIamPoliciesFixedSizeCollection> {
        public static ApiFuture<SearchAllIamPoliciesPagedResponse> createAsync(PageContext<SearchAllIamPoliciesRequest, SearchAllIamPoliciesResponse, IamPolicySearchResult> context, ApiFuture<SearchAllIamPoliciesResponse> futureResponse) {
            ApiFuture<SearchAllIamPoliciesPage> futurePage = SearchAllIamPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchAllIamPoliciesPagedResponse((SearchAllIamPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchAllIamPoliciesPagedResponse(SearchAllIamPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAllIamPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchAllResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult, SearchAllResourcesPage, SearchAllResourcesFixedSizeCollection> {
        private SearchAllResourcesFixedSizeCollection(List<SearchAllResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAllResourcesFixedSizeCollection createEmptyCollection() {
            return new SearchAllResourcesFixedSizeCollection(null, 0);
        }

        protected SearchAllResourcesFixedSizeCollection createCollection(List<SearchAllResourcesPage> pages, int collectionSize) {
            return new SearchAllResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAllResourcesPage
    extends AbstractPage<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult, SearchAllResourcesPage> {
        private SearchAllResourcesPage(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, SearchAllResourcesResponse response) {
            super(context, (Object)response);
        }

        private static SearchAllResourcesPage createEmptyPage() {
            return new SearchAllResourcesPage(null, null);
        }

        protected SearchAllResourcesPage createPage(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, SearchAllResourcesResponse response) {
            return new SearchAllResourcesPage(context, response);
        }

        public ApiFuture<SearchAllResourcesPage> createPageAsync(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAllResourcesPagedResponse
    extends AbstractPagedListResponse<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult, SearchAllResourcesPage, SearchAllResourcesFixedSizeCollection> {
        public static ApiFuture<SearchAllResourcesPagedResponse> createAsync(PageContext<SearchAllResourcesRequest, SearchAllResourcesResponse, ResourceSearchResult> context, ApiFuture<SearchAllResourcesResponse> futureResponse) {
            ApiFuture<SearchAllResourcesPage> futurePage = SearchAllResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchAllResourcesPagedResponse((SearchAllResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchAllResourcesPagedResponse(SearchAllResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAllResourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAssetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage, ListAssetsFixedSizeCollection> {
        private ListAssetsFixedSizeCollection(List<ListAssetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAssetsFixedSizeCollection createEmptyCollection() {
            return new ListAssetsFixedSizeCollection(null, 0);
        }

        protected ListAssetsFixedSizeCollection createCollection(List<ListAssetsPage> pages, int collectionSize) {
            return new ListAssetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAssetsPage
    extends AbstractPage<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage> {
        private ListAssetsPage(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ListAssetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAssetsPage createEmptyPage() {
            return new ListAssetsPage(null, null);
        }

        protected ListAssetsPage createPage(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ListAssetsResponse response) {
            return new ListAssetsPage(context, response);
        }

        public ApiFuture<ListAssetsPage> createPageAsync(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ApiFuture<ListAssetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAssetsPagedResponse
    extends AbstractPagedListResponse<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage, ListAssetsFixedSizeCollection> {
        public static ApiFuture<ListAssetsPagedResponse> createAsync(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ApiFuture<ListAssetsResponse> futureResponse) {
            ApiFuture<ListAssetsPage> futurePage = ListAssetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAssetsPagedResponse((ListAssetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAssetsPagedResponse(ListAssetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAssetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

