/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p5beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1p5beta1.Asset;
import com.google.cloud.asset.v1p5beta1.AssetServiceClient;
import com.google.cloud.asset.v1p5beta1.ListAssetsRequest;
import com.google.cloud.asset.v1p5beta1.ListAssetsResponse;
import com.google.cloud.asset.v1p5beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p5beta1.stub.GrpcAssetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AssetServiceStubSettings
extends StubSettings<AssetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings;
    private static final PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset> LIST_ASSETS_PAGE_STR_DESC = new PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset>(){

        public String emptyToken() {
            return "";
        }

        public ListAssetsRequest injectToken(ListAssetsRequest payload, String token) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageToken(token).build();
        }

        public ListAssetsRequest injectPageSize(ListAssetsRequest payload, int pageSize) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAssetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAssetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Asset> extractResources(ListAssetsResponse payload) {
            return payload.getAssetsList() == null ? ImmutableList.of() : payload.getAssetsList();
        }
    };
    private static final PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> LIST_ASSETS_PAGE_STR_FACT = new PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse>(){

        public ApiFuture<AssetServiceClient.ListAssetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAssetsRequest, ListAssetsResponse> callable, ListAssetsRequest request, ApiCallContext context, ApiFuture<ListAssetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASSETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AssetServiceClient.ListAssetsPagedResponse.createAsync((PageContext<ListAssetsRequest, ListAssetsResponse, Asset>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
        return this.listAssetsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AssetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAssetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudasset.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudasset.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AssetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AssetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAssetsSettings = settingsBuilder.listAssetsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AssetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAssetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASSETS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAssetsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AssetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAssetsSettings = settings.listAssetsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAssetsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AssetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AssetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AssetServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AssetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, AssetServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
            return this.listAssetsSettings;
        }

        public AssetServiceStubSettings build() throws IOException {
            return new AssetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

