/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.CreateVersionMetadataV1;
import com.google.appengine.v1.CreateVersionRequest;
import com.google.appengine.v1.DeleteVersionRequest;
import com.google.appengine.v1.GetVersionRequest;
import com.google.appengine.v1.ListVersionsRequest;
import com.google.appengine.v1.ListVersionsResponse;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.UpdateVersionRequest;
import com.google.appengine.v1.Version;
import com.google.appengine.v1.VersionsClient;
import com.google.appengine.v1.stub.HttpJsonVersionsCallableFactory;
import com.google.appengine.v1.stub.VersionsStub;
import com.google.appengine.v1.stub.VersionsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonVersionsStub
extends VersionsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(CreateVersionMetadataV1.getDescriptor()).add(Version.getDescriptor()).add(OperationMetadataV1.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListVersionsRequest, ListVersionsResponse> listVersionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Versions/ListVersions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=apps/*/services/*}/versions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListVersionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetVersionRequest, Version> getVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Versions/GetVersion").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=apps/*/services/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Version.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateVersionRequest, Operation> createVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Versions/CreateVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=apps/*/services/*}/versions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("version", (Message)request.getVersion(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateVersionRequest, Operation> updateVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Versions/UpdateVersion").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=apps/*/services/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("version", (Message)request.getVersion(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteVersionRequest, Operation> deleteVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Versions/DeleteVersion").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=apps/*/services/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable;
    private final UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable;
    private final UnaryCallable<GetVersionRequest, Version> getVersionCallable;
    private final UnaryCallable<CreateVersionRequest, Operation> createVersionCallable;
    private final OperationCallable<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationCallable;
    private final UnaryCallable<UpdateVersionRequest, Operation> updateVersionCallable;
    private final OperationCallable<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationCallable;
    private final UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable;
    private final OperationCallable<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonVersionsStub create(VersionsStubSettings settings) throws IOException {
        return new HttpJsonVersionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonVersionsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonVersionsStub(VersionsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonVersionsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonVersionsStub(VersionsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonVersionsStub(VersionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonVersionsCallableFactory());
    }

    protected HttpJsonVersionsStub(VersionsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=apps/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=apps/*}/operations").build()).build());
        HttpJsonCallSettings listVersionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listVersionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listVersionsCallable = callableFactory.createUnaryCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.listVersionsPagedCallable = callableFactory.createPagedCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.getVersionCallable = callableFactory.createUnaryCallable(getVersionTransportSettings, settings.getVersionSettings(), clientContext);
        this.createVersionCallable = callableFactory.createUnaryCallable(createVersionTransportSettings, settings.createVersionSettings(), clientContext);
        this.createVersionOperationCallable = callableFactory.createOperationCallable(createVersionTransportSettings, settings.createVersionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateVersionCallable = callableFactory.createUnaryCallable(updateVersionTransportSettings, settings.updateVersionSettings(), clientContext);
        this.updateVersionOperationCallable = callableFactory.createOperationCallable(updateVersionTransportSettings, settings.updateVersionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteVersionCallable = callableFactory.createUnaryCallable(deleteVersionTransportSettings, settings.deleteVersionSettings(), clientContext);
        this.deleteVersionOperationCallable = callableFactory.createOperationCallable(deleteVersionTransportSettings, settings.deleteVersionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listVersionsMethodDescriptor);
        methodDescriptors.add(getVersionMethodDescriptor);
        methodDescriptors.add(createVersionMethodDescriptor);
        methodDescriptors.add(updateVersionMethodDescriptor);
        methodDescriptors.add(deleteVersionMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.listVersionsCallable;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.listVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.getVersionCallable;
    }

    @Override
    public UnaryCallable<CreateVersionRequest, Operation> createVersionCallable() {
        return this.createVersionCallable;
    }

    @Override
    public OperationCallable<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationCallable() {
        return this.createVersionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateVersionRequest, Operation> updateVersionCallable() {
        return this.updateVersionCallable;
    }

    @Override
    public OperationCallable<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationCallable() {
        return this.updateVersionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable() {
        return this.deleteVersionCallable;
    }

    @Override
    public OperationCallable<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationCallable() {
        return this.deleteVersionOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

