/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubDiscoveryClient;
import com.google.cloud.apihub.v1.DiscoveredApiObservation;
import com.google.cloud.apihub.v1.DiscoveredApiOperation;
import com.google.cloud.apihub.v1.GetDiscoveredApiObservationRequest;
import com.google.cloud.apihub.v1.GetDiscoveredApiOperationRequest;
import com.google.cloud.apihub.v1.ListDiscoveredApiObservationsRequest;
import com.google.cloud.apihub.v1.ListDiscoveredApiObservationsResponse;
import com.google.cloud.apihub.v1.ListDiscoveredApiOperationsRequest;
import com.google.cloud.apihub.v1.ListDiscoveredApiOperationsResponse;
import com.google.cloud.apihub.v1.stub.ApiHubDiscoveryStub;
import com.google.cloud.apihub.v1.stub.HttpJsonApiHubDiscoveryStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ApiHubDiscoveryStubSettings
extends StubSettings<ApiHubDiscoveryStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse> listDiscoveredApiObservationsSettings;
    private final UnaryCallSettings<GetDiscoveredApiObservationRequest, DiscoveredApiObservation> getDiscoveredApiObservationSettings;
    private final PagedCallSettings<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse> listDiscoveredApiOperationsSettings;
    private final UnaryCallSettings<GetDiscoveredApiOperationRequest, DiscoveredApiOperation> getDiscoveredApiOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubDiscoveryClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation> LIST_DISCOVERED_API_OBSERVATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation>(){

        public String emptyToken() {
            return "";
        }

        public ListDiscoveredApiObservationsRequest injectToken(ListDiscoveredApiObservationsRequest payload, String token) {
            return ListDiscoveredApiObservationsRequest.newBuilder((ListDiscoveredApiObservationsRequest)payload).setPageToken(token).build();
        }

        public ListDiscoveredApiObservationsRequest injectPageSize(ListDiscoveredApiObservationsRequest payload, int pageSize) {
            return ListDiscoveredApiObservationsRequest.newBuilder((ListDiscoveredApiObservationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDiscoveredApiObservationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDiscoveredApiObservationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DiscoveredApiObservation> extractResources(ListDiscoveredApiObservationsResponse payload) {
            return payload.getDiscoveredApiObservationsList();
        }
    };
    private static final PagedListDescriptor<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation> LIST_DISCOVERED_API_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation>(){

        public String emptyToken() {
            return "";
        }

        public ListDiscoveredApiOperationsRequest injectToken(ListDiscoveredApiOperationsRequest payload, String token) {
            return ListDiscoveredApiOperationsRequest.newBuilder((ListDiscoveredApiOperationsRequest)payload).setPageToken(token).build();
        }

        public ListDiscoveredApiOperationsRequest injectPageSize(ListDiscoveredApiOperationsRequest payload, int pageSize) {
            return ListDiscoveredApiOperationsRequest.newBuilder((ListDiscoveredApiOperationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDiscoveredApiOperationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDiscoveredApiOperationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DiscoveredApiOperation> extractResources(ListDiscoveredApiOperationsResponse payload) {
            return payload.getDiscoveredApiOperationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse> LIST_DISCOVERED_API_OBSERVATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse>(){

        public ApiFuture<ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse> callable, ListDiscoveredApiObservationsRequest request, ApiCallContext context, ApiFuture<ListDiscoveredApiObservationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DISCOVERED_API_OBSERVATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse.createAsync((PageContext<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse> LIST_DISCOVERED_API_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse>(){

        public ApiFuture<ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse> callable, ListDiscoveredApiOperationsRequest request, ApiCallContext context, ApiFuture<ListDiscoveredApiOperationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DISCOVERED_API_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse.createAsync((PageContext<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubDiscoveryClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubDiscoveryClient.ListLocationsPagedResponse>(){

        public ApiFuture<ApiHubDiscoveryClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubDiscoveryClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse> listDiscoveredApiObservationsSettings() {
        return this.listDiscoveredApiObservationsSettings;
    }

    public UnaryCallSettings<GetDiscoveredApiObservationRequest, DiscoveredApiObservation> getDiscoveredApiObservationSettings() {
        return this.getDiscoveredApiObservationSettings;
    }

    public PagedCallSettings<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse> listDiscoveredApiOperationsSettings() {
        return this.listDiscoveredApiOperationsSettings;
    }

    public UnaryCallSettings<GetDiscoveredApiOperationRequest, DiscoveredApiOperation> getDiscoveredApiOperationSettings() {
        return this.getDiscoveredApiOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubDiscoveryClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ApiHubDiscoveryStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonApiHubDiscoveryStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apihub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apihub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apihub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApiHubDiscoveryStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApiHubDiscoveryStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApiHubDiscoveryStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDiscoveredApiObservationsSettings = settingsBuilder.listDiscoveredApiObservationsSettings().build();
        this.getDiscoveredApiObservationSettings = settingsBuilder.getDiscoveredApiObservationSettings().build();
        this.listDiscoveredApiOperationsSettings = settingsBuilder.listDiscoveredApiOperationsSettings().build();
        this.getDiscoveredApiOperationSettings = settingsBuilder.getDiscoveredApiOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApiHubDiscoveryStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse> listDiscoveredApiObservationsSettings;
        private final UnaryCallSettings.Builder<GetDiscoveredApiObservationRequest, DiscoveredApiObservation> getDiscoveredApiObservationSettings;
        private final PagedCallSettings.Builder<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse> listDiscoveredApiOperationsSettings;
        private final UnaryCallSettings.Builder<GetDiscoveredApiOperationRequest, DiscoveredApiOperation> getDiscoveredApiOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubDiscoveryClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDiscoveredApiObservationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DISCOVERED_API_OBSERVATIONS_PAGE_STR_FACT);
            this.getDiscoveredApiObservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDiscoveredApiOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DISCOVERED_API_OPERATIONS_PAGE_STR_FACT);
            this.getDiscoveredApiOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDiscoveredApiObservationsSettings, this.getDiscoveredApiObservationSettings, this.listDiscoveredApiOperationsSettings, this.getDiscoveredApiOperationSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ApiHubDiscoveryStubSettings settings) {
            super((StubSettings)settings);
            this.listDiscoveredApiObservationsSettings = settings.listDiscoveredApiObservationsSettings.toBuilder();
            this.getDiscoveredApiObservationSettings = settings.getDiscoveredApiObservationSettings.toBuilder();
            this.listDiscoveredApiOperationsSettings = settings.listDiscoveredApiOperationsSettings.toBuilder();
            this.getDiscoveredApiOperationSettings = settings.getDiscoveredApiOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDiscoveredApiObservationsSettings, this.getDiscoveredApiObservationSettings, this.listDiscoveredApiOperationsSettings, this.getDiscoveredApiOperationSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApiHubDiscoveryStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApiHubDiscoveryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApiHubDiscoveryStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ApiHubDiscoveryStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDiscoveredApiObservationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDiscoveredApiObservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDiscoveredApiOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDiscoveredApiOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiObservationsPagedResponse> listDiscoveredApiObservationsSettings() {
            return this.listDiscoveredApiObservationsSettings;
        }

        public UnaryCallSettings.Builder<GetDiscoveredApiObservationRequest, DiscoveredApiObservation> getDiscoveredApiObservationSettings() {
            return this.getDiscoveredApiObservationSettings;
        }

        public PagedCallSettings.Builder<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, ApiHubDiscoveryClient.ListDiscoveredApiOperationsPagedResponse> listDiscoveredApiOperationsSettings() {
            return this.listDiscoveredApiOperationsSettings;
        }

        public UnaryCallSettings.Builder<GetDiscoveredApiOperationRequest, DiscoveredApiOperation> getDiscoveredApiOperationSettings() {
            return this.getDiscoveredApiOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubDiscoveryClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ApiHubDiscoveryStubSettings build() throws IOException {
            return new ApiHubDiscoveryStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

