/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubDiscoverySettings;
import com.google.cloud.apihub.v1.DiscoveredApiObservation;
import com.google.cloud.apihub.v1.DiscoveredApiObservationName;
import com.google.cloud.apihub.v1.DiscoveredApiOperation;
import com.google.cloud.apihub.v1.DiscoveredApiOperationName;
import com.google.cloud.apihub.v1.GetDiscoveredApiObservationRequest;
import com.google.cloud.apihub.v1.GetDiscoveredApiOperationRequest;
import com.google.cloud.apihub.v1.ListDiscoveredApiObservationsRequest;
import com.google.cloud.apihub.v1.ListDiscoveredApiObservationsResponse;
import com.google.cloud.apihub.v1.ListDiscoveredApiOperationsRequest;
import com.google.cloud.apihub.v1.ListDiscoveredApiOperationsResponse;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.stub.ApiHubDiscoveryStub;
import com.google.cloud.apihub.v1.stub.ApiHubDiscoveryStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiHubDiscoveryClient
implements BackgroundResource {
    private final ApiHubDiscoverySettings settings;
    private final ApiHubDiscoveryStub stub;

    public static final ApiHubDiscoveryClient create() throws IOException {
        return ApiHubDiscoveryClient.create(ApiHubDiscoverySettings.newBuilder().build());
    }

    public static final ApiHubDiscoveryClient create(ApiHubDiscoverySettings settings) throws IOException {
        return new ApiHubDiscoveryClient(settings);
    }

    public static final ApiHubDiscoveryClient create(ApiHubDiscoveryStub stub) {
        return new ApiHubDiscoveryClient(stub);
    }

    protected ApiHubDiscoveryClient(ApiHubDiscoverySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiHubDiscoveryStubSettings)settings.getStubSettings()).createStub();
    }

    protected ApiHubDiscoveryClient(ApiHubDiscoveryStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ApiHubDiscoverySettings getSettings() {
        return this.settings;
    }

    public ApiHubDiscoveryStub getStub() {
        return this.stub;
    }

    public final ListDiscoveredApiObservationsPagedResponse listDiscoveredApiObservations(LocationName parent) {
        ListDiscoveredApiObservationsRequest request = ListDiscoveredApiObservationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDiscoveredApiObservations(request);
    }

    public final ListDiscoveredApiObservationsPagedResponse listDiscoveredApiObservations(String parent) {
        ListDiscoveredApiObservationsRequest request = ListDiscoveredApiObservationsRequest.newBuilder().setParent(parent).build();
        return this.listDiscoveredApiObservations(request);
    }

    public final ListDiscoveredApiObservationsPagedResponse listDiscoveredApiObservations(ListDiscoveredApiObservationsRequest request) {
        return (ListDiscoveredApiObservationsPagedResponse)((Object)this.listDiscoveredApiObservationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsPagedResponse> listDiscoveredApiObservationsPagedCallable() {
        return this.stub.listDiscoveredApiObservationsPagedCallable();
    }

    public final UnaryCallable<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse> listDiscoveredApiObservationsCallable() {
        return this.stub.listDiscoveredApiObservationsCallable();
    }

    public final DiscoveredApiObservation getDiscoveredApiObservation(DiscoveredApiObservationName name) {
        GetDiscoveredApiObservationRequest request = GetDiscoveredApiObservationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDiscoveredApiObservation(request);
    }

    public final DiscoveredApiObservation getDiscoveredApiObservation(String name) {
        GetDiscoveredApiObservationRequest request = GetDiscoveredApiObservationRequest.newBuilder().setName(name).build();
        return this.getDiscoveredApiObservation(request);
    }

    public final DiscoveredApiObservation getDiscoveredApiObservation(GetDiscoveredApiObservationRequest request) {
        return (DiscoveredApiObservation)this.getDiscoveredApiObservationCallable().call((Object)request);
    }

    public final UnaryCallable<GetDiscoveredApiObservationRequest, DiscoveredApiObservation> getDiscoveredApiObservationCallable() {
        return this.stub.getDiscoveredApiObservationCallable();
    }

    public final ListDiscoveredApiOperationsPagedResponse listDiscoveredApiOperations(DiscoveredApiObservationName parent) {
        ListDiscoveredApiOperationsRequest request = ListDiscoveredApiOperationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDiscoveredApiOperations(request);
    }

    public final ListDiscoveredApiOperationsPagedResponse listDiscoveredApiOperations(String parent) {
        ListDiscoveredApiOperationsRequest request = ListDiscoveredApiOperationsRequest.newBuilder().setParent(parent).build();
        return this.listDiscoveredApiOperations(request);
    }

    public final ListDiscoveredApiOperationsPagedResponse listDiscoveredApiOperations(ListDiscoveredApiOperationsRequest request) {
        return (ListDiscoveredApiOperationsPagedResponse)((Object)this.listDiscoveredApiOperationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsPagedResponse> listDiscoveredApiOperationsPagedCallable() {
        return this.stub.listDiscoveredApiOperationsPagedCallable();
    }

    public final UnaryCallable<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse> listDiscoveredApiOperationsCallable() {
        return this.stub.listDiscoveredApiOperationsCallable();
    }

    public final DiscoveredApiOperation getDiscoveredApiOperation(DiscoveredApiOperationName name) {
        GetDiscoveredApiOperationRequest request = GetDiscoveredApiOperationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDiscoveredApiOperation(request);
    }

    public final DiscoveredApiOperation getDiscoveredApiOperation(String name) {
        GetDiscoveredApiOperationRequest request = GetDiscoveredApiOperationRequest.newBuilder().setName(name).build();
        return this.getDiscoveredApiOperation(request);
    }

    public final DiscoveredApiOperation getDiscoveredApiOperation(GetDiscoveredApiOperationRequest request) {
        return (DiscoveredApiOperation)this.getDiscoveredApiOperationCallable().call((Object)request);
    }

    public final UnaryCallable<GetDiscoveredApiOperationRequest, DiscoveredApiOperation> getDiscoveredApiOperationCallable() {
        return this.stub.getDiscoveredApiOperationCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDiscoveredApiOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation, ListDiscoveredApiOperationsPage, ListDiscoveredApiOperationsFixedSizeCollection> {
        private ListDiscoveredApiOperationsFixedSizeCollection(List<ListDiscoveredApiOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDiscoveredApiOperationsFixedSizeCollection createEmptyCollection() {
            return new ListDiscoveredApiOperationsFixedSizeCollection(null, 0);
        }

        protected ListDiscoveredApiOperationsFixedSizeCollection createCollection(List<ListDiscoveredApiOperationsPage> pages, int collectionSize) {
            return new ListDiscoveredApiOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDiscoveredApiOperationsPage
    extends AbstractPage<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation, ListDiscoveredApiOperationsPage> {
        private ListDiscoveredApiOperationsPage(PageContext<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation> context, ListDiscoveredApiOperationsResponse response) {
            super(context, (Object)response);
        }

        private static ListDiscoveredApiOperationsPage createEmptyPage() {
            return new ListDiscoveredApiOperationsPage(null, null);
        }

        protected ListDiscoveredApiOperationsPage createPage(PageContext<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation> context, ListDiscoveredApiOperationsResponse response) {
            return new ListDiscoveredApiOperationsPage(context, response);
        }

        public ApiFuture<ListDiscoveredApiOperationsPage> createPageAsync(PageContext<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation> context, ApiFuture<ListDiscoveredApiOperationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDiscoveredApiOperationsPagedResponse
    extends AbstractPagedListResponse<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation, ListDiscoveredApiOperationsPage, ListDiscoveredApiOperationsFixedSizeCollection> {
        public static ApiFuture<ListDiscoveredApiOperationsPagedResponse> createAsync(PageContext<ListDiscoveredApiOperationsRequest, ListDiscoveredApiOperationsResponse, DiscoveredApiOperation> context, ApiFuture<ListDiscoveredApiOperationsResponse> futureResponse) {
            ApiFuture<ListDiscoveredApiOperationsPage> futurePage = ListDiscoveredApiOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDiscoveredApiOperationsPagedResponse((ListDiscoveredApiOperationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDiscoveredApiOperationsPagedResponse(ListDiscoveredApiOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDiscoveredApiOperationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDiscoveredApiObservationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation, ListDiscoveredApiObservationsPage, ListDiscoveredApiObservationsFixedSizeCollection> {
        private ListDiscoveredApiObservationsFixedSizeCollection(List<ListDiscoveredApiObservationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDiscoveredApiObservationsFixedSizeCollection createEmptyCollection() {
            return new ListDiscoveredApiObservationsFixedSizeCollection(null, 0);
        }

        protected ListDiscoveredApiObservationsFixedSizeCollection createCollection(List<ListDiscoveredApiObservationsPage> pages, int collectionSize) {
            return new ListDiscoveredApiObservationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDiscoveredApiObservationsPage
    extends AbstractPage<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation, ListDiscoveredApiObservationsPage> {
        private ListDiscoveredApiObservationsPage(PageContext<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation> context, ListDiscoveredApiObservationsResponse response) {
            super(context, (Object)response);
        }

        private static ListDiscoveredApiObservationsPage createEmptyPage() {
            return new ListDiscoveredApiObservationsPage(null, null);
        }

        protected ListDiscoveredApiObservationsPage createPage(PageContext<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation> context, ListDiscoveredApiObservationsResponse response) {
            return new ListDiscoveredApiObservationsPage(context, response);
        }

        public ApiFuture<ListDiscoveredApiObservationsPage> createPageAsync(PageContext<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation> context, ApiFuture<ListDiscoveredApiObservationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDiscoveredApiObservationsPagedResponse
    extends AbstractPagedListResponse<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation, ListDiscoveredApiObservationsPage, ListDiscoveredApiObservationsFixedSizeCollection> {
        public static ApiFuture<ListDiscoveredApiObservationsPagedResponse> createAsync(PageContext<ListDiscoveredApiObservationsRequest, ListDiscoveredApiObservationsResponse, DiscoveredApiObservation> context, ApiFuture<ListDiscoveredApiObservationsResponse> futureResponse) {
            ApiFuture<ListDiscoveredApiObservationsPage> futurePage = ListDiscoveredApiObservationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDiscoveredApiObservationsPagedResponse((ListDiscoveredApiObservationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDiscoveredApiObservationsPagedResponse(ListDiscoveredApiObservationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDiscoveredApiObservationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

