/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubCurateClient;
import com.google.cloud.apihub.v1.CreateCurationRequest;
import com.google.cloud.apihub.v1.Curation;
import com.google.cloud.apihub.v1.DeleteCurationRequest;
import com.google.cloud.apihub.v1.GetCurationRequest;
import com.google.cloud.apihub.v1.ListCurationsRequest;
import com.google.cloud.apihub.v1.ListCurationsResponse;
import com.google.cloud.apihub.v1.UpdateCurationRequest;
import com.google.cloud.apihub.v1.stub.ApiHubCurateStub;
import com.google.cloud.apihub.v1.stub.HttpJsonApiHubCurateStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ApiHubCurateStubSettings
extends StubSettings<ApiHubCurateStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateCurationRequest, Curation> createCurationSettings;
    private final UnaryCallSettings<GetCurationRequest, Curation> getCurationSettings;
    private final PagedCallSettings<ListCurationsRequest, ListCurationsResponse, ApiHubCurateClient.ListCurationsPagedResponse> listCurationsSettings;
    private final UnaryCallSettings<UpdateCurationRequest, Curation> updateCurationSettings;
    private final UnaryCallSettings<DeleteCurationRequest, Empty> deleteCurationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubCurateClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListCurationsRequest, ListCurationsResponse, Curation> LIST_CURATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListCurationsRequest, ListCurationsResponse, Curation>(){

        public String emptyToken() {
            return "";
        }

        public ListCurationsRequest injectToken(ListCurationsRequest payload, String token) {
            return ListCurationsRequest.newBuilder((ListCurationsRequest)payload).setPageToken(token).build();
        }

        public ListCurationsRequest injectPageSize(ListCurationsRequest payload, int pageSize) {
            return ListCurationsRequest.newBuilder((ListCurationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCurationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCurationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Curation> extractResources(ListCurationsResponse payload) {
            return payload.getCurationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListCurationsRequest, ListCurationsResponse, ApiHubCurateClient.ListCurationsPagedResponse> LIST_CURATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListCurationsRequest, ListCurationsResponse, ApiHubCurateClient.ListCurationsPagedResponse>(){

        public ApiFuture<ApiHubCurateClient.ListCurationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCurationsRequest, ListCurationsResponse> callable, ListCurationsRequest request, ApiCallContext context, ApiFuture<ListCurationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CURATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubCurateClient.ListCurationsPagedResponse.createAsync((PageContext<ListCurationsRequest, ListCurationsResponse, Curation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubCurateClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubCurateClient.ListLocationsPagedResponse>(){

        public ApiFuture<ApiHubCurateClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubCurateClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateCurationRequest, Curation> createCurationSettings() {
        return this.createCurationSettings;
    }

    public UnaryCallSettings<GetCurationRequest, Curation> getCurationSettings() {
        return this.getCurationSettings;
    }

    public PagedCallSettings<ListCurationsRequest, ListCurationsResponse, ApiHubCurateClient.ListCurationsPagedResponse> listCurationsSettings() {
        return this.listCurationsSettings;
    }

    public UnaryCallSettings<UpdateCurationRequest, Curation> updateCurationSettings() {
        return this.updateCurationSettings;
    }

    public UnaryCallSettings<DeleteCurationRequest, Empty> deleteCurationSettings() {
        return this.deleteCurationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubCurateClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ApiHubCurateStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonApiHubCurateStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apihub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apihub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apihub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApiHubCurateStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApiHubCurateStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApiHubCurateStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createCurationSettings = settingsBuilder.createCurationSettings().build();
        this.getCurationSettings = settingsBuilder.getCurationSettings().build();
        this.listCurationsSettings = settingsBuilder.listCurationsSettings().build();
        this.updateCurationSettings = settingsBuilder.updateCurationSettings().build();
        this.deleteCurationSettings = settingsBuilder.deleteCurationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApiHubCurateStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateCurationRequest, Curation> createCurationSettings;
        private final UnaryCallSettings.Builder<GetCurationRequest, Curation> getCurationSettings;
        private final PagedCallSettings.Builder<ListCurationsRequest, ListCurationsResponse, ApiHubCurateClient.ListCurationsPagedResponse> listCurationsSettings;
        private final UnaryCallSettings.Builder<UpdateCurationRequest, Curation> updateCurationSettings;
        private final UnaryCallSettings.Builder<DeleteCurationRequest, Empty> deleteCurationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubCurateClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createCurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCurationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CURATIONS_PAGE_STR_FACT);
            this.updateCurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCurationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCurationSettings, this.getCurationSettings, this.listCurationsSettings, this.updateCurationSettings, this.deleteCurationSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ApiHubCurateStubSettings settings) {
            super((StubSettings)settings);
            this.createCurationSettings = settings.createCurationSettings.toBuilder();
            this.getCurationSettings = settings.getCurationSettings.toBuilder();
            this.listCurationsSettings = settings.listCurationsSettings.toBuilder();
            this.updateCurationSettings = settings.updateCurationSettings.toBuilder();
            this.deleteCurationSettings = settings.deleteCurationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCurationSettings, this.getCurationSettings, this.listCurationsSettings, this.updateCurationSettings, this.deleteCurationSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApiHubCurateStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApiHubCurateStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApiHubCurateStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ApiHubCurateStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createCurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getCurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCurationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateCurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteCurationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateCurationRequest, Curation> createCurationSettings() {
            return this.createCurationSettings;
        }

        public UnaryCallSettings.Builder<GetCurationRequest, Curation> getCurationSettings() {
            return this.getCurationSettings;
        }

        public PagedCallSettings.Builder<ListCurationsRequest, ListCurationsResponse, ApiHubCurateClient.ListCurationsPagedResponse> listCurationsSettings() {
            return this.listCurationsSettings;
        }

        public UnaryCallSettings.Builder<UpdateCurationRequest, Curation> updateCurationSettings() {
            return this.updateCurationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCurationRequest, Empty> deleteCurationSettings() {
            return this.deleteCurationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubCurateClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ApiHubCurateStubSettings build() throws IOException {
            return new ApiHubCurateStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

