/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeconnect.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigeeconnect.v1.ConnectionServiceClient;
import com.google.cloud.apigeeconnect.v1.ListConnectionsRequest;
import com.google.cloud.apigeeconnect.v1.ListConnectionsResponse;
import com.google.cloud.apigeeconnect.v1.stub.ConnectionServiceStub;
import com.google.cloud.apigeeconnect.v1.stub.ConnectionServiceStubSettings;
import com.google.cloud.apigeeconnect.v1.stub.HttpJsonConnectionServiceCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonConnectionServiceStub
extends ConnectionServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListConnectionsRequest, ListConnectionsResponse> listConnectionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigeeconnect.v1.ConnectionService/ListConnections").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/endpoints/*}/connections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConnectionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable;
    private final UnaryCallable<ListConnectionsRequest, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonConnectionServiceStub create(ConnectionServiceStubSettings settings) throws IOException {
        return new HttpJsonConnectionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonConnectionServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonConnectionServiceStub(ConnectionServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonConnectionServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonConnectionServiceStub(ConnectionServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonConnectionServiceStub(ConnectionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonConnectionServiceCallableFactory());
    }

    protected HttpJsonConnectionServiceStub(ConnectionServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listConnectionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConnectionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listConnectionsCallable = callableFactory.createUnaryCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.listConnectionsPagedCallable = callableFactory.createPagedCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listConnectionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.listConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.listConnectionsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

