/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.alloydb.v1beta.AlloyDBAdminClient;
import com.google.cloud.alloydb.v1beta.Backup;
import com.google.cloud.alloydb.v1beta.BatchCreateInstancesRequest;
import com.google.cloud.alloydb.v1beta.BatchCreateInstancesResponse;
import com.google.cloud.alloydb.v1beta.Cluster;
import com.google.cloud.alloydb.v1beta.ConnectionInfo;
import com.google.cloud.alloydb.v1beta.CreateBackupRequest;
import com.google.cloud.alloydb.v1beta.CreateClusterRequest;
import com.google.cloud.alloydb.v1beta.CreateInstanceRequest;
import com.google.cloud.alloydb.v1beta.CreateSecondaryClusterRequest;
import com.google.cloud.alloydb.v1beta.CreateSecondaryInstanceRequest;
import com.google.cloud.alloydb.v1beta.CreateUserRequest;
import com.google.cloud.alloydb.v1beta.DeleteBackupRequest;
import com.google.cloud.alloydb.v1beta.DeleteClusterRequest;
import com.google.cloud.alloydb.v1beta.DeleteInstanceRequest;
import com.google.cloud.alloydb.v1beta.DeleteUserRequest;
import com.google.cloud.alloydb.v1beta.FailoverInstanceRequest;
import com.google.cloud.alloydb.v1beta.GenerateClientCertificateRequest;
import com.google.cloud.alloydb.v1beta.GenerateClientCertificateResponse;
import com.google.cloud.alloydb.v1beta.GetBackupRequest;
import com.google.cloud.alloydb.v1beta.GetClusterRequest;
import com.google.cloud.alloydb.v1beta.GetConnectionInfoRequest;
import com.google.cloud.alloydb.v1beta.GetInstanceRequest;
import com.google.cloud.alloydb.v1beta.GetUserRequest;
import com.google.cloud.alloydb.v1beta.InjectFaultRequest;
import com.google.cloud.alloydb.v1beta.Instance;
import com.google.cloud.alloydb.v1beta.ListBackupsRequest;
import com.google.cloud.alloydb.v1beta.ListBackupsResponse;
import com.google.cloud.alloydb.v1beta.ListClustersRequest;
import com.google.cloud.alloydb.v1beta.ListClustersResponse;
import com.google.cloud.alloydb.v1beta.ListInstancesRequest;
import com.google.cloud.alloydb.v1beta.ListInstancesResponse;
import com.google.cloud.alloydb.v1beta.ListSupportedDatabaseFlagsRequest;
import com.google.cloud.alloydb.v1beta.ListSupportedDatabaseFlagsResponse;
import com.google.cloud.alloydb.v1beta.ListUsersRequest;
import com.google.cloud.alloydb.v1beta.ListUsersResponse;
import com.google.cloud.alloydb.v1beta.OperationMetadata;
import com.google.cloud.alloydb.v1beta.PromoteClusterRequest;
import com.google.cloud.alloydb.v1beta.RestartInstanceRequest;
import com.google.cloud.alloydb.v1beta.RestoreClusterRequest;
import com.google.cloud.alloydb.v1beta.SupportedDatabaseFlag;
import com.google.cloud.alloydb.v1beta.UpdateBackupRequest;
import com.google.cloud.alloydb.v1beta.UpdateClusterRequest;
import com.google.cloud.alloydb.v1beta.UpdateInstanceRequest;
import com.google.cloud.alloydb.v1beta.UpdateUserRequest;
import com.google.cloud.alloydb.v1beta.User;
import com.google.cloud.alloydb.v1beta.stub.AlloyDBAdminStub;
import com.google.cloud.alloydb.v1beta.stub.GrpcAlloyDBAdminStub;
import com.google.cloud.alloydb.v1beta.stub.HttpJsonAlloyDBAdminStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AlloyDBAdminStubSettings
extends StubSettings<AlloyDBAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListClustersRequest, ListClustersResponse, AlloyDBAdminClient.ListClustersPagedResponse> listClustersSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
    private final UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings;
    private final OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings;
    private final OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
    private final UnaryCallSettings<PromoteClusterRequest, Operation> promoteClusterSettings;
    private final OperationCallSettings<PromoteClusterRequest, Cluster, OperationMetadata> promoteClusterOperationSettings;
    private final UnaryCallSettings<RestoreClusterRequest, Operation> restoreClusterSettings;
    private final OperationCallSettings<RestoreClusterRequest, Cluster, OperationMetadata> restoreClusterOperationSettings;
    private final UnaryCallSettings<CreateSecondaryClusterRequest, Operation> createSecondaryClusterSettings;
    private final OperationCallSettings<CreateSecondaryClusterRequest, Cluster, OperationMetadata> createSecondaryClusterOperationSettings;
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, AlloyDBAdminClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<CreateSecondaryInstanceRequest, Operation> createSecondaryInstanceSettings;
    private final OperationCallSettings<CreateSecondaryInstanceRequest, Instance, OperationMetadata> createSecondaryInstanceOperationSettings;
    private final UnaryCallSettings<BatchCreateInstancesRequest, Operation> batchCreateInstancesSettings;
    private final OperationCallSettings<BatchCreateInstancesRequest, BatchCreateInstancesResponse, OperationMetadata> batchCreateInstancesOperationSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
    private final UnaryCallSettings<FailoverInstanceRequest, Operation> failoverInstanceSettings;
    private final OperationCallSettings<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings;
    private final UnaryCallSettings<InjectFaultRequest, Operation> injectFaultSettings;
    private final OperationCallSettings<InjectFaultRequest, Instance, OperationMetadata> injectFaultOperationSettings;
    private final UnaryCallSettings<RestartInstanceRequest, Operation> restartInstanceSettings;
    private final OperationCallSettings<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings;
    private final PagedCallSettings<ListBackupsRequest, ListBackupsResponse, AlloyDBAdminClient.ListBackupsPagedResponse> listBackupsSettings;
    private final UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings;
    private final UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings;
    private final OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
    private final UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings;
    private final OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
    private final UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings;
    private final OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
    private final PagedCallSettings<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse> listSupportedDatabaseFlagsSettings;
    private final UnaryCallSettings<GenerateClientCertificateRequest, GenerateClientCertificateResponse> generateClientCertificateSettings;
    private final UnaryCallSettings<GetConnectionInfoRequest, ConnectionInfo> getConnectionInfoSettings;
    private final PagedCallSettings<ListUsersRequest, ListUsersResponse, AlloyDBAdminClient.ListUsersPagedResponse> listUsersSettings;
    private final UnaryCallSettings<GetUserRequest, User> getUserSettings;
    private final UnaryCallSettings<CreateUserRequest, User> createUserSettings;
    private final UnaryCallSettings<UpdateUserRequest, User> updateUserSettings;
    private final UnaryCallSettings<DeleteUserRequest, Empty> deleteUserSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AlloyDBAdminClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster> LIST_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster>(){

        public String emptyToken() {
            return "";
        }

        public ListClustersRequest injectToken(ListClustersRequest payload, String token) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageToken(token).build();
        }

        public ListClustersRequest injectPageSize(ListClustersRequest payload, int pageSize) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Cluster> extractResources(ListClustersResponse payload) {
            return payload.getClustersList() == null ? ImmutableList.of() : payload.getClustersList();
        }
    };
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup> LIST_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupsRequest injectToken(ListBackupsRequest payload, String token) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageToken(token).build();
        }

        public ListBackupsRequest injectPageSize(ListBackupsRequest payload, int pageSize) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Backup> extractResources(ListBackupsResponse payload) {
            return payload.getBackupsList() == null ? ImmutableList.of() : payload.getBackupsList();
        }
    };
    private static final PagedListDescriptor<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag> LIST_SUPPORTED_DATABASE_FLAGS_PAGE_STR_DESC = new PagedListDescriptor<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag>(){

        public String emptyToken() {
            return "";
        }

        public ListSupportedDatabaseFlagsRequest injectToken(ListSupportedDatabaseFlagsRequest payload, String token) {
            return ListSupportedDatabaseFlagsRequest.newBuilder((ListSupportedDatabaseFlagsRequest)payload).setPageToken(token).build();
        }

        public ListSupportedDatabaseFlagsRequest injectPageSize(ListSupportedDatabaseFlagsRequest payload, int pageSize) {
            return ListSupportedDatabaseFlagsRequest.newBuilder((ListSupportedDatabaseFlagsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSupportedDatabaseFlagsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSupportedDatabaseFlagsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SupportedDatabaseFlag> extractResources(ListSupportedDatabaseFlagsResponse payload) {
            return payload.getSupportedDatabaseFlagsList() == null ? ImmutableList.of() : payload.getSupportedDatabaseFlagsList();
        }
    };
    private static final PagedListDescriptor<ListUsersRequest, ListUsersResponse, User> LIST_USERS_PAGE_STR_DESC = new PagedListDescriptor<ListUsersRequest, ListUsersResponse, User>(){

        public String emptyToken() {
            return "";
        }

        public ListUsersRequest injectToken(ListUsersRequest payload, String token) {
            return ListUsersRequest.newBuilder((ListUsersRequest)payload).setPageToken(token).build();
        }

        public ListUsersRequest injectPageSize(ListUsersRequest payload, int pageSize) {
            return ListUsersRequest.newBuilder((ListUsersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUsersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUsersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<User> extractResources(ListUsersResponse payload) {
            return payload.getUsersList() == null ? ImmutableList.of() : payload.getUsersList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListClustersRequest, ListClustersResponse, AlloyDBAdminClient.ListClustersPagedResponse> LIST_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListClustersRequest, ListClustersResponse, AlloyDBAdminClient.ListClustersPagedResponse>(){

        public ApiFuture<AlloyDBAdminClient.ListClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListClustersRequest, ListClustersResponse> callable, ListClustersRequest request, ApiCallContext context, ApiFuture<ListClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlloyDBAdminClient.ListClustersPagedResponse.createAsync((PageContext<ListClustersRequest, ListClustersResponse, Cluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, AlloyDBAdminClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, AlloyDBAdminClient.ListInstancesPagedResponse>(){

        public ApiFuture<AlloyDBAdminClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlloyDBAdminClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, AlloyDBAdminClient.ListBackupsPagedResponse> LIST_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, AlloyDBAdminClient.ListBackupsPagedResponse>(){

        public ApiFuture<AlloyDBAdminClient.ListBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupsRequest, ListBackupsResponse> callable, ListBackupsRequest request, ApiCallContext context, ApiFuture<ListBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlloyDBAdminClient.ListBackupsPagedResponse.createAsync((PageContext<ListBackupsRequest, ListBackupsResponse, Backup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse> LIST_SUPPORTED_DATABASE_FLAGS_PAGE_STR_FACT = new PagedListResponseFactory<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse>(){

        public ApiFuture<AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse> callable, ListSupportedDatabaseFlagsRequest request, ApiCallContext context, ApiFuture<ListSupportedDatabaseFlagsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUPPORTED_DATABASE_FLAGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse.createAsync((PageContext<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, SupportedDatabaseFlag>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUsersRequest, ListUsersResponse, AlloyDBAdminClient.ListUsersPagedResponse> LIST_USERS_PAGE_STR_FACT = new PagedListResponseFactory<ListUsersRequest, ListUsersResponse, AlloyDBAdminClient.ListUsersPagedResponse>(){

        public ApiFuture<AlloyDBAdminClient.ListUsersPagedResponse> getFuturePagedResponse(UnaryCallable<ListUsersRequest, ListUsersResponse> callable, ListUsersRequest request, ApiCallContext context, ApiFuture<ListUsersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlloyDBAdminClient.ListUsersPagedResponse.createAsync((PageContext<ListUsersRequest, ListUsersResponse, User>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AlloyDBAdminClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AlloyDBAdminClient.ListLocationsPagedResponse>(){

        public ApiFuture<AlloyDBAdminClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlloyDBAdminClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListClustersRequest, ListClustersResponse, AlloyDBAdminClient.ListClustersPagedResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    public OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
        return this.createClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    public OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
        return this.updateClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    public OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
        return this.deleteClusterOperationSettings;
    }

    public UnaryCallSettings<PromoteClusterRequest, Operation> promoteClusterSettings() {
        return this.promoteClusterSettings;
    }

    public OperationCallSettings<PromoteClusterRequest, Cluster, OperationMetadata> promoteClusterOperationSettings() {
        return this.promoteClusterOperationSettings;
    }

    public UnaryCallSettings<RestoreClusterRequest, Operation> restoreClusterSettings() {
        return this.restoreClusterSettings;
    }

    public OperationCallSettings<RestoreClusterRequest, Cluster, OperationMetadata> restoreClusterOperationSettings() {
        return this.restoreClusterOperationSettings;
    }

    public UnaryCallSettings<CreateSecondaryClusterRequest, Operation> createSecondaryClusterSettings() {
        return this.createSecondaryClusterSettings;
    }

    public OperationCallSettings<CreateSecondaryClusterRequest, Cluster, OperationMetadata> createSecondaryClusterOperationSettings() {
        return this.createSecondaryClusterOperationSettings;
    }

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, AlloyDBAdminClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<CreateSecondaryInstanceRequest, Operation> createSecondaryInstanceSettings() {
        return this.createSecondaryInstanceSettings;
    }

    public OperationCallSettings<CreateSecondaryInstanceRequest, Instance, OperationMetadata> createSecondaryInstanceOperationSettings() {
        return this.createSecondaryInstanceOperationSettings;
    }

    public UnaryCallSettings<BatchCreateInstancesRequest, Operation> batchCreateInstancesSettings() {
        return this.batchCreateInstancesSettings;
    }

    public OperationCallSettings<BatchCreateInstancesRequest, BatchCreateInstancesResponse, OperationMetadata> batchCreateInstancesOperationSettings() {
        return this.batchCreateInstancesOperationSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
        return this.updateInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
        return this.deleteInstanceOperationSettings;
    }

    public UnaryCallSettings<FailoverInstanceRequest, Operation> failoverInstanceSettings() {
        return this.failoverInstanceSettings;
    }

    public OperationCallSettings<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings() {
        return this.failoverInstanceOperationSettings;
    }

    public UnaryCallSettings<InjectFaultRequest, Operation> injectFaultSettings() {
        return this.injectFaultSettings;
    }

    public OperationCallSettings<InjectFaultRequest, Instance, OperationMetadata> injectFaultOperationSettings() {
        return this.injectFaultOperationSettings;
    }

    public UnaryCallSettings<RestartInstanceRequest, Operation> restartInstanceSettings() {
        return this.restartInstanceSettings;
    }

    public OperationCallSettings<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings() {
        return this.restartInstanceOperationSettings;
    }

    public PagedCallSettings<ListBackupsRequest, ListBackupsResponse, AlloyDBAdminClient.ListBackupsPagedResponse> listBackupsSettings() {
        return this.listBackupsSettings;
    }

    public UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings() {
        return this.getBackupSettings;
    }

    public UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings() {
        return this.createBackupSettings;
    }

    public OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
        return this.createBackupOperationSettings;
    }

    public UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings() {
        return this.updateBackupSettings;
    }

    public OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
        return this.updateBackupOperationSettings;
    }

    public UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings() {
        return this.deleteBackupSettings;
    }

    public OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
        return this.deleteBackupOperationSettings;
    }

    public PagedCallSettings<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse> listSupportedDatabaseFlagsSettings() {
        return this.listSupportedDatabaseFlagsSettings;
    }

    public UnaryCallSettings<GenerateClientCertificateRequest, GenerateClientCertificateResponse> generateClientCertificateSettings() {
        return this.generateClientCertificateSettings;
    }

    public UnaryCallSettings<GetConnectionInfoRequest, ConnectionInfo> getConnectionInfoSettings() {
        return this.getConnectionInfoSettings;
    }

    public PagedCallSettings<ListUsersRequest, ListUsersResponse, AlloyDBAdminClient.ListUsersPagedResponse> listUsersSettings() {
        return this.listUsersSettings;
    }

    public UnaryCallSettings<GetUserRequest, User> getUserSettings() {
        return this.getUserSettings;
    }

    public UnaryCallSettings<CreateUserRequest, User> createUserSettings() {
        return this.createUserSettings;
    }

    public UnaryCallSettings<UpdateUserRequest, User> updateUserSettings() {
        return this.updateUserSettings;
    }

    public UnaryCallSettings<DeleteUserRequest, Empty> deleteUserSettings() {
        return this.deleteUserSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AlloyDBAdminClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public AlloyDBAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAlloyDBAdminStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAlloyDBAdminStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "alloydb";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "alloydb.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "alloydb.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AlloyDBAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AlloyDBAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AlloyDBAdminStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AlloyDBAdminStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AlloyDBAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.createClusterOperationSettings = settingsBuilder.createClusterOperationSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateClusterOperationSettings = settingsBuilder.updateClusterOperationSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.deleteClusterOperationSettings = settingsBuilder.deleteClusterOperationSettings().build();
        this.promoteClusterSettings = settingsBuilder.promoteClusterSettings().build();
        this.promoteClusterOperationSettings = settingsBuilder.promoteClusterOperationSettings().build();
        this.restoreClusterSettings = settingsBuilder.restoreClusterSettings().build();
        this.restoreClusterOperationSettings = settingsBuilder.restoreClusterOperationSettings().build();
        this.createSecondaryClusterSettings = settingsBuilder.createSecondaryClusterSettings().build();
        this.createSecondaryClusterOperationSettings = settingsBuilder.createSecondaryClusterOperationSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.createSecondaryInstanceSettings = settingsBuilder.createSecondaryInstanceSettings().build();
        this.createSecondaryInstanceOperationSettings = settingsBuilder.createSecondaryInstanceOperationSettings().build();
        this.batchCreateInstancesSettings = settingsBuilder.batchCreateInstancesSettings().build();
        this.batchCreateInstancesOperationSettings = settingsBuilder.batchCreateInstancesOperationSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.updateInstanceOperationSettings = settingsBuilder.updateInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteInstanceOperationSettings = settingsBuilder.deleteInstanceOperationSettings().build();
        this.failoverInstanceSettings = settingsBuilder.failoverInstanceSettings().build();
        this.failoverInstanceOperationSettings = settingsBuilder.failoverInstanceOperationSettings().build();
        this.injectFaultSettings = settingsBuilder.injectFaultSettings().build();
        this.injectFaultOperationSettings = settingsBuilder.injectFaultOperationSettings().build();
        this.restartInstanceSettings = settingsBuilder.restartInstanceSettings().build();
        this.restartInstanceOperationSettings = settingsBuilder.restartInstanceOperationSettings().build();
        this.listBackupsSettings = settingsBuilder.listBackupsSettings().build();
        this.getBackupSettings = settingsBuilder.getBackupSettings().build();
        this.createBackupSettings = settingsBuilder.createBackupSettings().build();
        this.createBackupOperationSettings = settingsBuilder.createBackupOperationSettings().build();
        this.updateBackupSettings = settingsBuilder.updateBackupSettings().build();
        this.updateBackupOperationSettings = settingsBuilder.updateBackupOperationSettings().build();
        this.deleteBackupSettings = settingsBuilder.deleteBackupSettings().build();
        this.deleteBackupOperationSettings = settingsBuilder.deleteBackupOperationSettings().build();
        this.listSupportedDatabaseFlagsSettings = settingsBuilder.listSupportedDatabaseFlagsSettings().build();
        this.generateClientCertificateSettings = settingsBuilder.generateClientCertificateSettings().build();
        this.getConnectionInfoSettings = settingsBuilder.getConnectionInfoSettings().build();
        this.listUsersSettings = settingsBuilder.listUsersSettings().build();
        this.getUserSettings = settingsBuilder.getUserSettings().build();
        this.createUserSettings = settingsBuilder.createUserSettings().build();
        this.updateUserSettings = settingsBuilder.updateUserSettings().build();
        this.deleteUserSettings = settingsBuilder.deleteUserSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AlloyDBAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, AlloyDBAdminClient.ListClustersPagedResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings;
        private final OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings;
        private final OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
        private final UnaryCallSettings.Builder<PromoteClusterRequest, Operation> promoteClusterSettings;
        private final OperationCallSettings.Builder<PromoteClusterRequest, Cluster, OperationMetadata> promoteClusterOperationSettings;
        private final UnaryCallSettings.Builder<RestoreClusterRequest, Operation> restoreClusterSettings;
        private final OperationCallSettings.Builder<RestoreClusterRequest, Cluster, OperationMetadata> restoreClusterOperationSettings;
        private final UnaryCallSettings.Builder<CreateSecondaryClusterRequest, Operation> createSecondaryClusterSettings;
        private final OperationCallSettings.Builder<CreateSecondaryClusterRequest, Cluster, OperationMetadata> createSecondaryClusterOperationSettings;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, AlloyDBAdminClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<CreateSecondaryInstanceRequest, Operation> createSecondaryInstanceSettings;
        private final OperationCallSettings.Builder<CreateSecondaryInstanceRequest, Instance, OperationMetadata> createSecondaryInstanceOperationSettings;
        private final UnaryCallSettings.Builder<BatchCreateInstancesRequest, Operation> batchCreateInstancesSettings;
        private final OperationCallSettings.Builder<BatchCreateInstancesRequest, BatchCreateInstancesResponse, OperationMetadata> batchCreateInstancesOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
        private final UnaryCallSettings.Builder<FailoverInstanceRequest, Operation> failoverInstanceSettings;
        private final OperationCallSettings.Builder<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings;
        private final UnaryCallSettings.Builder<InjectFaultRequest, Operation> injectFaultSettings;
        private final OperationCallSettings.Builder<InjectFaultRequest, Instance, OperationMetadata> injectFaultOperationSettings;
        private final UnaryCallSettings.Builder<RestartInstanceRequest, Operation> restartInstanceSettings;
        private final OperationCallSettings.Builder<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings;
        private final PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, AlloyDBAdminClient.ListBackupsPagedResponse> listBackupsSettings;
        private final UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings;
        private final UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings;
        private final OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
        private final UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings;
        private final OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings;
        private final OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
        private final PagedCallSettings.Builder<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse> listSupportedDatabaseFlagsSettings;
        private final UnaryCallSettings.Builder<GenerateClientCertificateRequest, GenerateClientCertificateResponse> generateClientCertificateSettings;
        private final UnaryCallSettings.Builder<GetConnectionInfoRequest, ConnectionInfo> getConnectionInfoSettings;
        private final PagedCallSettings.Builder<ListUsersRequest, ListUsersResponse, AlloyDBAdminClient.ListUsersPagedResponse> listUsersSettings;
        private final UnaryCallSettings.Builder<GetUserRequest, User> getUserSettings;
        private final UnaryCallSettings.Builder<CreateUserRequest, User> createUserSettings;
        private final UnaryCallSettings.Builder<UpdateUserRequest, User> updateUserSettings;
        private final UnaryCallSettings.Builder<DeleteUserRequest, Empty> deleteUserSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AlloyDBAdminClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLUSTERS_PAGE_STR_FACT);
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClusterOperationSettings = OperationCallSettings.newBuilder();
            this.promoteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.promoteClusterOperationSettings = OperationCallSettings.newBuilder();
            this.restoreClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreClusterOperationSettings = OperationCallSettings.newBuilder();
            this.createSecondaryClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSecondaryClusterOperationSettings = OperationCallSettings.newBuilder();
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.createSecondaryInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSecondaryInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.batchCreateInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.failoverInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.failoverInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.injectFaultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.injectFaultOperationSettings = OperationCallSettings.newBuilder();
            this.restartInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restartInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.listBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUPS_PAGE_STR_FACT);
            this.getBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupOperationSettings = OperationCallSettings.newBuilder();
            this.updateBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupOperationSettings = OperationCallSettings.newBuilder();
            this.listSupportedDatabaseFlagsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUPPORTED_DATABASE_FLAGS_PAGE_STR_FACT);
            this.generateClientCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getConnectionInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUsersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USERS_PAGE_STR_FACT);
            this.getUserSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createUserSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateUserSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteUserSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.promoteClusterSettings, this.restoreClusterSettings, this.createSecondaryClusterSettings, this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.createSecondaryInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.batchCreateInstancesSettings, this.updateInstanceSettings, this.deleteInstanceSettings, this.failoverInstanceSettings, this.injectFaultSettings, this.restartInstanceSettings, this.listBackupsSettings, this.getBackupSettings, this.createBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.listSupportedDatabaseFlagsSettings, this.generateClientCertificateSettings, this.getConnectionInfoSettings, this.listUsersSettings, this.getUserSettings, this.createUserSettings, this.updateUserSettings, this.deleteUserSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AlloyDBAdminStubSettings settings) {
            super((StubSettings)settings);
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.createClusterOperationSettings = settings.createClusterOperationSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateClusterOperationSettings = settings.updateClusterOperationSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.deleteClusterOperationSettings = settings.deleteClusterOperationSettings.toBuilder();
            this.promoteClusterSettings = settings.promoteClusterSettings.toBuilder();
            this.promoteClusterOperationSettings = settings.promoteClusterOperationSettings.toBuilder();
            this.restoreClusterSettings = settings.restoreClusterSettings.toBuilder();
            this.restoreClusterOperationSettings = settings.restoreClusterOperationSettings.toBuilder();
            this.createSecondaryClusterSettings = settings.createSecondaryClusterSettings.toBuilder();
            this.createSecondaryClusterOperationSettings = settings.createSecondaryClusterOperationSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.createSecondaryInstanceSettings = settings.createSecondaryInstanceSettings.toBuilder();
            this.createSecondaryInstanceOperationSettings = settings.createSecondaryInstanceOperationSettings.toBuilder();
            this.batchCreateInstancesSettings = settings.batchCreateInstancesSettings.toBuilder();
            this.batchCreateInstancesOperationSettings = settings.batchCreateInstancesOperationSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.updateInstanceOperationSettings = settings.updateInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteInstanceOperationSettings = settings.deleteInstanceOperationSettings.toBuilder();
            this.failoverInstanceSettings = settings.failoverInstanceSettings.toBuilder();
            this.failoverInstanceOperationSettings = settings.failoverInstanceOperationSettings.toBuilder();
            this.injectFaultSettings = settings.injectFaultSettings.toBuilder();
            this.injectFaultOperationSettings = settings.injectFaultOperationSettings.toBuilder();
            this.restartInstanceSettings = settings.restartInstanceSettings.toBuilder();
            this.restartInstanceOperationSettings = settings.restartInstanceOperationSettings.toBuilder();
            this.listBackupsSettings = settings.listBackupsSettings.toBuilder();
            this.getBackupSettings = settings.getBackupSettings.toBuilder();
            this.createBackupSettings = settings.createBackupSettings.toBuilder();
            this.createBackupOperationSettings = settings.createBackupOperationSettings.toBuilder();
            this.updateBackupSettings = settings.updateBackupSettings.toBuilder();
            this.updateBackupOperationSettings = settings.updateBackupOperationSettings.toBuilder();
            this.deleteBackupSettings = settings.deleteBackupSettings.toBuilder();
            this.deleteBackupOperationSettings = settings.deleteBackupOperationSettings.toBuilder();
            this.listSupportedDatabaseFlagsSettings = settings.listSupportedDatabaseFlagsSettings.toBuilder();
            this.generateClientCertificateSettings = settings.generateClientCertificateSettings.toBuilder();
            this.getConnectionInfoSettings = settings.getConnectionInfoSettings.toBuilder();
            this.listUsersSettings = settings.listUsersSettings.toBuilder();
            this.getUserSettings = settings.getUserSettings.toBuilder();
            this.createUserSettings = settings.createUserSettings.toBuilder();
            this.updateUserSettings = settings.updateUserSettings.toBuilder();
            this.deleteUserSettings = settings.deleteUserSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.promoteClusterSettings, this.restoreClusterSettings, this.createSecondaryClusterSettings, this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.createSecondaryInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.batchCreateInstancesSettings, this.updateInstanceSettings, this.deleteInstanceSettings, this.failoverInstanceSettings, this.injectFaultSettings, this.restartInstanceSettings, this.listBackupsSettings, this.getBackupSettings, this.createBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.listSupportedDatabaseFlagsSettings, this.generateClientCertificateSettings, this.getConnectionInfoSettings, this.listUsersSettings, this.getUserSettings, this.createUserSettings, this.updateUserSettings, this.deleteUserSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AlloyDBAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AlloyDBAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AlloyDBAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AlloyDBAdminStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AlloyDBAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AlloyDBAdminStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AlloyDBAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AlloyDBAdminStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AlloyDBAdminStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AlloyDBAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.promoteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.restoreClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createSecondaryClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createSecondaryInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchCreateInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.failoverInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.injectFaultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.restartInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSupportedDatabaseFlagsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateClientCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConnectionInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listUsersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getUserSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createUserSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateUserSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteUserSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.promoteClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restoreClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createSecondaryClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createSecondaryInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchCreateInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchCreateInstancesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.failoverInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.injectFaultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restartInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, AlloyDBAdminClient.ListClustersPagedResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
            return this.createClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
            return this.updateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
            return this.deleteClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<PromoteClusterRequest, Operation> promoteClusterSettings() {
            return this.promoteClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PromoteClusterRequest, Cluster, OperationMetadata> promoteClusterOperationSettings() {
            return this.promoteClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<RestoreClusterRequest, Operation> restoreClusterSettings() {
            return this.restoreClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreClusterRequest, Cluster, OperationMetadata> restoreClusterOperationSettings() {
            return this.restoreClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateSecondaryClusterRequest, Operation> createSecondaryClusterSettings() {
            return this.createSecondaryClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSecondaryClusterRequest, Cluster, OperationMetadata> createSecondaryClusterOperationSettings() {
            return this.createSecondaryClusterOperationSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, AlloyDBAdminClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateSecondaryInstanceRequest, Operation> createSecondaryInstanceSettings() {
            return this.createSecondaryInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSecondaryInstanceRequest, Instance, OperationMetadata> createSecondaryInstanceOperationSettings() {
            return this.createSecondaryInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateInstancesRequest, Operation> batchCreateInstancesSettings() {
            return this.batchCreateInstancesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchCreateInstancesRequest, BatchCreateInstancesResponse, OperationMetadata> batchCreateInstancesOperationSettings() {
            return this.batchCreateInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
            return this.updateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
            return this.deleteInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<FailoverInstanceRequest, Operation> failoverInstanceSettings() {
            return this.failoverInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings() {
            return this.failoverInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<InjectFaultRequest, Operation> injectFaultSettings() {
            return this.injectFaultSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InjectFaultRequest, Instance, OperationMetadata> injectFaultOperationSettings() {
            return this.injectFaultOperationSettings;
        }

        public UnaryCallSettings.Builder<RestartInstanceRequest, Operation> restartInstanceSettings() {
            return this.restartInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings() {
            return this.restartInstanceOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, AlloyDBAdminClient.ListBackupsPagedResponse> listBackupsSettings() {
            return this.listBackupsSettings;
        }

        public UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings() {
            return this.getBackupSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings() {
            return this.createBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
            return this.createBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings() {
            return this.updateBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
            return this.updateBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings() {
            return this.deleteBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
            return this.deleteBackupOperationSettings;
        }

        public PagedCallSettings.Builder<ListSupportedDatabaseFlagsRequest, ListSupportedDatabaseFlagsResponse, AlloyDBAdminClient.ListSupportedDatabaseFlagsPagedResponse> listSupportedDatabaseFlagsSettings() {
            return this.listSupportedDatabaseFlagsSettings;
        }

        public UnaryCallSettings.Builder<GenerateClientCertificateRequest, GenerateClientCertificateResponse> generateClientCertificateSettings() {
            return this.generateClientCertificateSettings;
        }

        public UnaryCallSettings.Builder<GetConnectionInfoRequest, ConnectionInfo> getConnectionInfoSettings() {
            return this.getConnectionInfoSettings;
        }

        public PagedCallSettings.Builder<ListUsersRequest, ListUsersResponse, AlloyDBAdminClient.ListUsersPagedResponse> listUsersSettings() {
            return this.listUsersSettings;
        }

        public UnaryCallSettings.Builder<GetUserRequest, User> getUserSettings() {
            return this.getUserSettings;
        }

        public UnaryCallSettings.Builder<CreateUserRequest, User> createUserSettings() {
            return this.createUserSettings;
        }

        public UnaryCallSettings.Builder<UpdateUserRequest, User> updateUserSettings() {
            return this.updateUserSettings;
        }

        public UnaryCallSettings.Builder<DeleteUserRequest, Empty> deleteUserSettings() {
            return this.deleteUserSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AlloyDBAdminClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public AlloyDBAdminStubSettings build() throws IOException {
            return new AlloyDBAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

