/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateRagCorpusOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateRagCorpusRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteRagCorpusRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteRagFileRequest;
import com.google.cloud.aiplatform.v1beta1.GetRagCorpusRequest;
import com.google.cloud.aiplatform.v1beta1.GetRagEngineConfigRequest;
import com.google.cloud.aiplatform.v1beta1.GetRagFileRequest;
import com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig;
import com.google.cloud.aiplatform.v1beta1.ImportRagFilesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ImportRagFilesRequest;
import com.google.cloud.aiplatform.v1beta1.ImportRagFilesResponse;
import com.google.cloud.aiplatform.v1beta1.ListRagCorporaRequest;
import com.google.cloud.aiplatform.v1beta1.ListRagCorporaResponse;
import com.google.cloud.aiplatform.v1beta1.ListRagFilesRequest;
import com.google.cloud.aiplatform.v1beta1.ListRagFilesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.RagCorpus;
import com.google.cloud.aiplatform.v1beta1.RagCorpusName;
import com.google.cloud.aiplatform.v1beta1.RagEngineConfig;
import com.google.cloud.aiplatform.v1beta1.RagEngineConfigName;
import com.google.cloud.aiplatform.v1beta1.RagFile;
import com.google.cloud.aiplatform.v1beta1.RagFileName;
import com.google.cloud.aiplatform.v1beta1.UpdateRagCorpusOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateRagCorpusRequest;
import com.google.cloud.aiplatform.v1beta1.UpdateRagEngineConfigOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateRagEngineConfigRequest;
import com.google.cloud.aiplatform.v1beta1.UploadRagFileConfig;
import com.google.cloud.aiplatform.v1beta1.UploadRagFileRequest;
import com.google.cloud.aiplatform.v1beta1.UploadRagFileResponse;
import com.google.cloud.aiplatform.v1beta1.VertexRagDataServiceSettings;
import com.google.cloud.aiplatform.v1beta1.stub.VertexRagDataServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.VertexRagDataServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class VertexRagDataServiceClient
implements BackgroundResource {
    private final VertexRagDataServiceSettings settings;
    private final VertexRagDataServiceStub stub;
    private final OperationsClient operationsClient;

    public static final VertexRagDataServiceClient create() throws IOException {
        return VertexRagDataServiceClient.create(VertexRagDataServiceSettings.newBuilder().build());
    }

    public static final VertexRagDataServiceClient create(VertexRagDataServiceSettings settings) throws IOException {
        return new VertexRagDataServiceClient(settings);
    }

    public static final VertexRagDataServiceClient create(VertexRagDataServiceStub stub) {
        return new VertexRagDataServiceClient(stub);
    }

    protected VertexRagDataServiceClient(VertexRagDataServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VertexRagDataServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected VertexRagDataServiceClient(VertexRagDataServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final VertexRagDataServiceSettings getSettings() {
        return this.settings;
    }

    public VertexRagDataServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<RagCorpus, CreateRagCorpusOperationMetadata> createRagCorpusAsync(LocationName parent, RagCorpus ragCorpus) {
        CreateRagCorpusRequest request = CreateRagCorpusRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRagCorpus(ragCorpus).build();
        return this.createRagCorpusAsync(request);
    }

    public final OperationFuture<RagCorpus, CreateRagCorpusOperationMetadata> createRagCorpusAsync(String parent, RagCorpus ragCorpus) {
        CreateRagCorpusRequest request = CreateRagCorpusRequest.newBuilder().setParent(parent).setRagCorpus(ragCorpus).build();
        return this.createRagCorpusAsync(request);
    }

    public final OperationFuture<RagCorpus, CreateRagCorpusOperationMetadata> createRagCorpusAsync(CreateRagCorpusRequest request) {
        return this.createRagCorpusOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRagCorpusRequest, RagCorpus, CreateRagCorpusOperationMetadata> createRagCorpusOperationCallable() {
        return this.stub.createRagCorpusOperationCallable();
    }

    public final UnaryCallable<CreateRagCorpusRequest, Operation> createRagCorpusCallable() {
        return this.stub.createRagCorpusCallable();
    }

    public final OperationFuture<RagCorpus, UpdateRagCorpusOperationMetadata> updateRagCorpusAsync(RagCorpus ragCorpus) {
        UpdateRagCorpusRequest request = UpdateRagCorpusRequest.newBuilder().setRagCorpus(ragCorpus).build();
        return this.updateRagCorpusAsync(request);
    }

    public final OperationFuture<RagCorpus, UpdateRagCorpusOperationMetadata> updateRagCorpusAsync(UpdateRagCorpusRequest request) {
        return this.updateRagCorpusOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRagCorpusRequest, RagCorpus, UpdateRagCorpusOperationMetadata> updateRagCorpusOperationCallable() {
        return this.stub.updateRagCorpusOperationCallable();
    }

    public final UnaryCallable<UpdateRagCorpusRequest, Operation> updateRagCorpusCallable() {
        return this.stub.updateRagCorpusCallable();
    }

    public final RagCorpus getRagCorpus(RagCorpusName name) {
        GetRagCorpusRequest request = GetRagCorpusRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRagCorpus(request);
    }

    public final RagCorpus getRagCorpus(String name) {
        GetRagCorpusRequest request = GetRagCorpusRequest.newBuilder().setName(name).build();
        return this.getRagCorpus(request);
    }

    public final RagCorpus getRagCorpus(GetRagCorpusRequest request) {
        return (RagCorpus)this.getRagCorpusCallable().call((Object)request);
    }

    public final UnaryCallable<GetRagCorpusRequest, RagCorpus> getRagCorpusCallable() {
        return this.stub.getRagCorpusCallable();
    }

    public final ListRagCorporaPagedResponse listRagCorpora(LocationName parent) {
        ListRagCorporaRequest request = ListRagCorporaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRagCorpora(request);
    }

    public final ListRagCorporaPagedResponse listRagCorpora(String parent) {
        ListRagCorporaRequest request = ListRagCorporaRequest.newBuilder().setParent(parent).build();
        return this.listRagCorpora(request);
    }

    public final ListRagCorporaPagedResponse listRagCorpora(ListRagCorporaRequest request) {
        return (ListRagCorporaPagedResponse)((Object)this.listRagCorporaPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRagCorporaRequest, ListRagCorporaPagedResponse> listRagCorporaPagedCallable() {
        return this.stub.listRagCorporaPagedCallable();
    }

    public final UnaryCallable<ListRagCorporaRequest, ListRagCorporaResponse> listRagCorporaCallable() {
        return this.stub.listRagCorporaCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteRagCorpusAsync(RagCorpusName name) {
        DeleteRagCorpusRequest request = DeleteRagCorpusRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRagCorpusAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteRagCorpusAsync(String name) {
        DeleteRagCorpusRequest request = DeleteRagCorpusRequest.newBuilder().setName(name).build();
        return this.deleteRagCorpusAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteRagCorpusAsync(DeleteRagCorpusRequest request) {
        return this.deleteRagCorpusOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRagCorpusRequest, Empty, DeleteOperationMetadata> deleteRagCorpusOperationCallable() {
        return this.stub.deleteRagCorpusOperationCallable();
    }

    public final UnaryCallable<DeleteRagCorpusRequest, Operation> deleteRagCorpusCallable() {
        return this.stub.deleteRagCorpusCallable();
    }

    public final UploadRagFileResponse uploadRagFile(RagCorpusName parent, RagFile ragFile, UploadRagFileConfig uploadRagFileConfig) {
        UploadRagFileRequest request = UploadRagFileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRagFile(ragFile).setUploadRagFileConfig(uploadRagFileConfig).build();
        return this.uploadRagFile(request);
    }

    public final UploadRagFileResponse uploadRagFile(String parent, RagFile ragFile, UploadRagFileConfig uploadRagFileConfig) {
        UploadRagFileRequest request = UploadRagFileRequest.newBuilder().setParent(parent).setRagFile(ragFile).setUploadRagFileConfig(uploadRagFileConfig).build();
        return this.uploadRagFile(request);
    }

    public final UploadRagFileResponse uploadRagFile(UploadRagFileRequest request) {
        return (UploadRagFileResponse)this.uploadRagFileCallable().call((Object)request);
    }

    public final UnaryCallable<UploadRagFileRequest, UploadRagFileResponse> uploadRagFileCallable() {
        return this.stub.uploadRagFileCallable();
    }

    public final OperationFuture<ImportRagFilesResponse, ImportRagFilesOperationMetadata> importRagFilesAsync(RagCorpusName parent, ImportRagFilesConfig importRagFilesConfig) {
        ImportRagFilesRequest request = ImportRagFilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setImportRagFilesConfig(importRagFilesConfig).build();
        return this.importRagFilesAsync(request);
    }

    public final OperationFuture<ImportRagFilesResponse, ImportRagFilesOperationMetadata> importRagFilesAsync(String parent, ImportRagFilesConfig importRagFilesConfig) {
        ImportRagFilesRequest request = ImportRagFilesRequest.newBuilder().setParent(parent).setImportRagFilesConfig(importRagFilesConfig).build();
        return this.importRagFilesAsync(request);
    }

    public final OperationFuture<ImportRagFilesResponse, ImportRagFilesOperationMetadata> importRagFilesAsync(ImportRagFilesRequest request) {
        return this.importRagFilesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportRagFilesRequest, ImportRagFilesResponse, ImportRagFilesOperationMetadata> importRagFilesOperationCallable() {
        return this.stub.importRagFilesOperationCallable();
    }

    public final UnaryCallable<ImportRagFilesRequest, Operation> importRagFilesCallable() {
        return this.stub.importRagFilesCallable();
    }

    public final RagFile getRagFile(RagFileName name) {
        GetRagFileRequest request = GetRagFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRagFile(request);
    }

    public final RagFile getRagFile(String name) {
        GetRagFileRequest request = GetRagFileRequest.newBuilder().setName(name).build();
        return this.getRagFile(request);
    }

    public final RagFile getRagFile(GetRagFileRequest request) {
        return (RagFile)this.getRagFileCallable().call((Object)request);
    }

    public final UnaryCallable<GetRagFileRequest, RagFile> getRagFileCallable() {
        return this.stub.getRagFileCallable();
    }

    public final ListRagFilesPagedResponse listRagFiles(RagCorpusName parent) {
        ListRagFilesRequest request = ListRagFilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRagFiles(request);
    }

    public final ListRagFilesPagedResponse listRagFiles(String parent) {
        ListRagFilesRequest request = ListRagFilesRequest.newBuilder().setParent(parent).build();
        return this.listRagFiles(request);
    }

    public final ListRagFilesPagedResponse listRagFiles(ListRagFilesRequest request) {
        return (ListRagFilesPagedResponse)((Object)this.listRagFilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRagFilesRequest, ListRagFilesPagedResponse> listRagFilesPagedCallable() {
        return this.stub.listRagFilesPagedCallable();
    }

    public final UnaryCallable<ListRagFilesRequest, ListRagFilesResponse> listRagFilesCallable() {
        return this.stub.listRagFilesCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteRagFileAsync(RagFileName name) {
        DeleteRagFileRequest request = DeleteRagFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRagFileAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteRagFileAsync(String name) {
        DeleteRagFileRequest request = DeleteRagFileRequest.newBuilder().setName(name).build();
        return this.deleteRagFileAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteRagFileAsync(DeleteRagFileRequest request) {
        return this.deleteRagFileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRagFileRequest, Empty, DeleteOperationMetadata> deleteRagFileOperationCallable() {
        return this.stub.deleteRagFileOperationCallable();
    }

    public final UnaryCallable<DeleteRagFileRequest, Operation> deleteRagFileCallable() {
        return this.stub.deleteRagFileCallable();
    }

    public final OperationFuture<RagEngineConfig, UpdateRagEngineConfigOperationMetadata> updateRagEngineConfigAsync(RagEngineConfig ragEngineConfig) {
        UpdateRagEngineConfigRequest request = UpdateRagEngineConfigRequest.newBuilder().setRagEngineConfig(ragEngineConfig).build();
        return this.updateRagEngineConfigAsync(request);
    }

    public final OperationFuture<RagEngineConfig, UpdateRagEngineConfigOperationMetadata> updateRagEngineConfigAsync(UpdateRagEngineConfigRequest request) {
        return this.updateRagEngineConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRagEngineConfigRequest, RagEngineConfig, UpdateRagEngineConfigOperationMetadata> updateRagEngineConfigOperationCallable() {
        return this.stub.updateRagEngineConfigOperationCallable();
    }

    public final UnaryCallable<UpdateRagEngineConfigRequest, Operation> updateRagEngineConfigCallable() {
        return this.stub.updateRagEngineConfigCallable();
    }

    public final RagEngineConfig getRagEngineConfig(RagEngineConfigName name) {
        GetRagEngineConfigRequest request = GetRagEngineConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRagEngineConfig(request);
    }

    public final RagEngineConfig getRagEngineConfig(String name) {
        GetRagEngineConfigRequest request = GetRagEngineConfigRequest.newBuilder().setName(name).build();
        return this.getRagEngineConfig(request);
    }

    public final RagEngineConfig getRagEngineConfig(GetRagEngineConfigRequest request) {
        return (RagEngineConfig)this.getRagEngineConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetRagEngineConfigRequest, RagEngineConfig> getRagEngineConfigCallable() {
        return this.stub.getRagEngineConfigCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRagFilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRagFilesRequest, ListRagFilesResponse, RagFile, ListRagFilesPage, ListRagFilesFixedSizeCollection> {
        private ListRagFilesFixedSizeCollection(List<ListRagFilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRagFilesFixedSizeCollection createEmptyCollection() {
            return new ListRagFilesFixedSizeCollection(null, 0);
        }

        protected ListRagFilesFixedSizeCollection createCollection(List<ListRagFilesPage> pages, int collectionSize) {
            return new ListRagFilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRagFilesPage
    extends AbstractPage<ListRagFilesRequest, ListRagFilesResponse, RagFile, ListRagFilesPage> {
        private ListRagFilesPage(PageContext<ListRagFilesRequest, ListRagFilesResponse, RagFile> context, ListRagFilesResponse response) {
            super(context, (Object)response);
        }

        private static ListRagFilesPage createEmptyPage() {
            return new ListRagFilesPage(null, null);
        }

        protected ListRagFilesPage createPage(PageContext<ListRagFilesRequest, ListRagFilesResponse, RagFile> context, ListRagFilesResponse response) {
            return new ListRagFilesPage(context, response);
        }

        public ApiFuture<ListRagFilesPage> createPageAsync(PageContext<ListRagFilesRequest, ListRagFilesResponse, RagFile> context, ApiFuture<ListRagFilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRagFilesPagedResponse
    extends AbstractPagedListResponse<ListRagFilesRequest, ListRagFilesResponse, RagFile, ListRagFilesPage, ListRagFilesFixedSizeCollection> {
        public static ApiFuture<ListRagFilesPagedResponse> createAsync(PageContext<ListRagFilesRequest, ListRagFilesResponse, RagFile> context, ApiFuture<ListRagFilesResponse> futureResponse) {
            ApiFuture<ListRagFilesPage> futurePage = ListRagFilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRagFilesPagedResponse((ListRagFilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRagFilesPagedResponse(ListRagFilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRagFilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRagCorporaFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRagCorporaRequest, ListRagCorporaResponse, RagCorpus, ListRagCorporaPage, ListRagCorporaFixedSizeCollection> {
        private ListRagCorporaFixedSizeCollection(List<ListRagCorporaPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRagCorporaFixedSizeCollection createEmptyCollection() {
            return new ListRagCorporaFixedSizeCollection(null, 0);
        }

        protected ListRagCorporaFixedSizeCollection createCollection(List<ListRagCorporaPage> pages, int collectionSize) {
            return new ListRagCorporaFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRagCorporaPage
    extends AbstractPage<ListRagCorporaRequest, ListRagCorporaResponse, RagCorpus, ListRagCorporaPage> {
        private ListRagCorporaPage(PageContext<ListRagCorporaRequest, ListRagCorporaResponse, RagCorpus> context, ListRagCorporaResponse response) {
            super(context, (Object)response);
        }

        private static ListRagCorporaPage createEmptyPage() {
            return new ListRagCorporaPage(null, null);
        }

        protected ListRagCorporaPage createPage(PageContext<ListRagCorporaRequest, ListRagCorporaResponse, RagCorpus> context, ListRagCorporaResponse response) {
            return new ListRagCorporaPage(context, response);
        }

        public ApiFuture<ListRagCorporaPage> createPageAsync(PageContext<ListRagCorporaRequest, ListRagCorporaResponse, RagCorpus> context, ApiFuture<ListRagCorporaResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRagCorporaPagedResponse
    extends AbstractPagedListResponse<ListRagCorporaRequest, ListRagCorporaResponse, RagCorpus, ListRagCorporaPage, ListRagCorporaFixedSizeCollection> {
        public static ApiFuture<ListRagCorporaPagedResponse> createAsync(PageContext<ListRagCorporaRequest, ListRagCorporaResponse, RagCorpus> context, ApiFuture<ListRagCorporaResponse> futureResponse) {
            ApiFuture<ListRagCorporaPage> futurePage = ListRagCorporaPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRagCorporaPagedResponse((ListRagCorporaPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRagCorporaPagedResponse(ListRagCorporaPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRagCorporaFixedSizeCollection.createEmptyCollection());
        }
    }
}

