/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateFeatureGroupOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.CreateFeatureOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateFeatureRequest;
import com.google.cloud.aiplatform.v1.DeleteFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.DeleteFeatureRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.Feature;
import com.google.cloud.aiplatform.v1.FeatureGroup;
import com.google.cloud.aiplatform.v1.FeatureRegistryServiceClient;
import com.google.cloud.aiplatform.v1.GetFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.GetFeatureRequest;
import com.google.cloud.aiplatform.v1.ListFeatureGroupsRequest;
import com.google.cloud.aiplatform.v1.ListFeatureGroupsResponse;
import com.google.cloud.aiplatform.v1.ListFeaturesRequest;
import com.google.cloud.aiplatform.v1.ListFeaturesResponse;
import com.google.cloud.aiplatform.v1.UpdateFeatureGroupOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateFeatureGroupRequest;
import com.google.cloud.aiplatform.v1.UpdateFeatureOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateFeatureRequest;
import com.google.cloud.aiplatform.v1.stub.FeatureRegistryServiceStub;
import com.google.cloud.aiplatform.v1.stub.GrpcFeatureRegistryServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class FeatureRegistryServiceStubSettings
extends StubSettings<FeatureRegistryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateFeatureGroupRequest, Operation> createFeatureGroupSettings;
    private final OperationCallSettings<CreateFeatureGroupRequest, FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupOperationSettings;
    private final UnaryCallSettings<GetFeatureGroupRequest, FeatureGroup> getFeatureGroupSettings;
    private final PagedCallSettings<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse> listFeatureGroupsSettings;
    private final UnaryCallSettings<UpdateFeatureGroupRequest, Operation> updateFeatureGroupSettings;
    private final OperationCallSettings<UpdateFeatureGroupRequest, FeatureGroup, UpdateFeatureGroupOperationMetadata> updateFeatureGroupOperationSettings;
    private final UnaryCallSettings<DeleteFeatureGroupRequest, Operation> deleteFeatureGroupSettings;
    private final OperationCallSettings<DeleteFeatureGroupRequest, Empty, DeleteOperationMetadata> deleteFeatureGroupOperationSettings;
    private final UnaryCallSettings<CreateFeatureRequest, Operation> createFeatureSettings;
    private final OperationCallSettings<CreateFeatureRequest, Feature, CreateFeatureOperationMetadata> createFeatureOperationSettings;
    private final UnaryCallSettings<GetFeatureRequest, Feature> getFeatureSettings;
    private final PagedCallSettings<ListFeaturesRequest, ListFeaturesResponse, FeatureRegistryServiceClient.ListFeaturesPagedResponse> listFeaturesSettings;
    private final UnaryCallSettings<UpdateFeatureRequest, Operation> updateFeatureSettings;
    private final OperationCallSettings<UpdateFeatureRequest, Feature, UpdateFeatureOperationMetadata> updateFeatureOperationSettings;
    private final UnaryCallSettings<DeleteFeatureRequest, Operation> deleteFeatureSettings;
    private final OperationCallSettings<DeleteFeatureRequest, Empty, DeleteOperationMetadata> deleteFeatureOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FeatureRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup> LIST_FEATURE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListFeatureGroupsRequest injectToken(ListFeatureGroupsRequest payload, String token) {
            return ListFeatureGroupsRequest.newBuilder((ListFeatureGroupsRequest)payload).setPageToken(token).build();
        }

        public ListFeatureGroupsRequest injectPageSize(ListFeatureGroupsRequest payload, int pageSize) {
            return ListFeatureGroupsRequest.newBuilder((ListFeatureGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFeatureGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFeatureGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FeatureGroup> extractResources(ListFeatureGroupsResponse payload) {
            return payload.getFeatureGroupsList();
        }
    };
    private static final PagedListDescriptor<ListFeaturesRequest, ListFeaturesResponse, Feature> LIST_FEATURES_PAGE_STR_DESC = new PagedListDescriptor<ListFeaturesRequest, ListFeaturesResponse, Feature>(){

        public String emptyToken() {
            return "";
        }

        public ListFeaturesRequest injectToken(ListFeaturesRequest payload, String token) {
            return ListFeaturesRequest.newBuilder((ListFeaturesRequest)payload).setPageToken(token).build();
        }

        public ListFeaturesRequest injectPageSize(ListFeaturesRequest payload, int pageSize) {
            return ListFeaturesRequest.newBuilder((ListFeaturesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFeaturesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFeaturesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Feature> extractResources(ListFeaturesResponse payload) {
            return payload.getFeaturesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse> LIST_FEATURE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse>(){

        public ApiFuture<FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFeatureGroupsRequest, ListFeatureGroupsResponse> callable, ListFeatureGroupsRequest request, ApiCallContext context, ApiFuture<ListFeatureGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FEATURE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse.createAsync((PageContext<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFeaturesRequest, ListFeaturesResponse, FeatureRegistryServiceClient.ListFeaturesPagedResponse> LIST_FEATURES_PAGE_STR_FACT = new PagedListResponseFactory<ListFeaturesRequest, ListFeaturesResponse, FeatureRegistryServiceClient.ListFeaturesPagedResponse>(){

        public ApiFuture<FeatureRegistryServiceClient.ListFeaturesPagedResponse> getFuturePagedResponse(UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> callable, ListFeaturesRequest request, ApiCallContext context, ApiFuture<ListFeaturesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FEATURES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FeatureRegistryServiceClient.ListFeaturesPagedResponse.createAsync((PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FeatureRegistryServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FeatureRegistryServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<FeatureRegistryServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FeatureRegistryServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateFeatureGroupRequest, Operation> createFeatureGroupSettings() {
        return this.createFeatureGroupSettings;
    }

    public OperationCallSettings<CreateFeatureGroupRequest, FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupOperationSettings() {
        return this.createFeatureGroupOperationSettings;
    }

    public UnaryCallSettings<GetFeatureGroupRequest, FeatureGroup> getFeatureGroupSettings() {
        return this.getFeatureGroupSettings;
    }

    public PagedCallSettings<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse> listFeatureGroupsSettings() {
        return this.listFeatureGroupsSettings;
    }

    public UnaryCallSettings<UpdateFeatureGroupRequest, Operation> updateFeatureGroupSettings() {
        return this.updateFeatureGroupSettings;
    }

    public OperationCallSettings<UpdateFeatureGroupRequest, FeatureGroup, UpdateFeatureGroupOperationMetadata> updateFeatureGroupOperationSettings() {
        return this.updateFeatureGroupOperationSettings;
    }

    public UnaryCallSettings<DeleteFeatureGroupRequest, Operation> deleteFeatureGroupSettings() {
        return this.deleteFeatureGroupSettings;
    }

    public OperationCallSettings<DeleteFeatureGroupRequest, Empty, DeleteOperationMetadata> deleteFeatureGroupOperationSettings() {
        return this.deleteFeatureGroupOperationSettings;
    }

    public UnaryCallSettings<CreateFeatureRequest, Operation> createFeatureSettings() {
        return this.createFeatureSettings;
    }

    public OperationCallSettings<CreateFeatureRequest, Feature, CreateFeatureOperationMetadata> createFeatureOperationSettings() {
        return this.createFeatureOperationSettings;
    }

    public UnaryCallSettings<GetFeatureRequest, Feature> getFeatureSettings() {
        return this.getFeatureSettings;
    }

    public PagedCallSettings<ListFeaturesRequest, ListFeaturesResponse, FeatureRegistryServiceClient.ListFeaturesPagedResponse> listFeaturesSettings() {
        return this.listFeaturesSettings;
    }

    public UnaryCallSettings<UpdateFeatureRequest, Operation> updateFeatureSettings() {
        return this.updateFeatureSettings;
    }

    public OperationCallSettings<UpdateFeatureRequest, Feature, UpdateFeatureOperationMetadata> updateFeatureOperationSettings() {
        return this.updateFeatureOperationSettings;
    }

    public UnaryCallSettings<DeleteFeatureRequest, Operation> deleteFeatureSettings() {
        return this.deleteFeatureSettings;
    }

    public OperationCallSettings<DeleteFeatureRequest, Empty, DeleteOperationMetadata> deleteFeatureOperationSettings() {
        return this.deleteFeatureOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FeatureRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public FeatureRegistryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFeatureRegistryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FeatureRegistryServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FeatureRegistryServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FeatureRegistryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createFeatureGroupSettings = settingsBuilder.createFeatureGroupSettings().build();
        this.createFeatureGroupOperationSettings = settingsBuilder.createFeatureGroupOperationSettings().build();
        this.getFeatureGroupSettings = settingsBuilder.getFeatureGroupSettings().build();
        this.listFeatureGroupsSettings = settingsBuilder.listFeatureGroupsSettings().build();
        this.updateFeatureGroupSettings = settingsBuilder.updateFeatureGroupSettings().build();
        this.updateFeatureGroupOperationSettings = settingsBuilder.updateFeatureGroupOperationSettings().build();
        this.deleteFeatureGroupSettings = settingsBuilder.deleteFeatureGroupSettings().build();
        this.deleteFeatureGroupOperationSettings = settingsBuilder.deleteFeatureGroupOperationSettings().build();
        this.createFeatureSettings = settingsBuilder.createFeatureSettings().build();
        this.createFeatureOperationSettings = settingsBuilder.createFeatureOperationSettings().build();
        this.getFeatureSettings = settingsBuilder.getFeatureSettings().build();
        this.listFeaturesSettings = settingsBuilder.listFeaturesSettings().build();
        this.updateFeatureSettings = settingsBuilder.updateFeatureSettings().build();
        this.updateFeatureOperationSettings = settingsBuilder.updateFeatureOperationSettings().build();
        this.deleteFeatureSettings = settingsBuilder.deleteFeatureSettings().build();
        this.deleteFeatureOperationSettings = settingsBuilder.deleteFeatureOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FeatureRegistryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateFeatureGroupRequest, Operation> createFeatureGroupSettings;
        private final OperationCallSettings.Builder<CreateFeatureGroupRequest, FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupOperationSettings;
        private final UnaryCallSettings.Builder<GetFeatureGroupRequest, FeatureGroup> getFeatureGroupSettings;
        private final PagedCallSettings.Builder<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse> listFeatureGroupsSettings;
        private final UnaryCallSettings.Builder<UpdateFeatureGroupRequest, Operation> updateFeatureGroupSettings;
        private final OperationCallSettings.Builder<UpdateFeatureGroupRequest, FeatureGroup, UpdateFeatureGroupOperationMetadata> updateFeatureGroupOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFeatureGroupRequest, Operation> deleteFeatureGroupSettings;
        private final OperationCallSettings.Builder<DeleteFeatureGroupRequest, Empty, DeleteOperationMetadata> deleteFeatureGroupOperationSettings;
        private final UnaryCallSettings.Builder<CreateFeatureRequest, Operation> createFeatureSettings;
        private final OperationCallSettings.Builder<CreateFeatureRequest, Feature, CreateFeatureOperationMetadata> createFeatureOperationSettings;
        private final UnaryCallSettings.Builder<GetFeatureRequest, Feature> getFeatureSettings;
        private final PagedCallSettings.Builder<ListFeaturesRequest, ListFeaturesResponse, FeatureRegistryServiceClient.ListFeaturesPagedResponse> listFeaturesSettings;
        private final UnaryCallSettings.Builder<UpdateFeatureRequest, Operation> updateFeatureSettings;
        private final OperationCallSettings.Builder<UpdateFeatureRequest, Feature, UpdateFeatureOperationMetadata> updateFeatureOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFeatureRequest, Operation> deleteFeatureSettings;
        private final OperationCallSettings.Builder<DeleteFeatureRequest, Empty, DeleteOperationMetadata> deleteFeatureOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FeatureRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createFeatureGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFeatureGroupOperationSettings = OperationCallSettings.newBuilder();
            this.getFeatureGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFeatureGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FEATURE_GROUPS_PAGE_STR_FACT);
            this.updateFeatureGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFeatureGroupOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFeatureGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFeatureGroupOperationSettings = OperationCallSettings.newBuilder();
            this.createFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFeatureOperationSettings = OperationCallSettings.newBuilder();
            this.getFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFeaturesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FEATURES_PAGE_STR_FACT);
            this.updateFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFeatureOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFeatureOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFeatureGroupSettings, this.getFeatureGroupSettings, this.listFeatureGroupsSettings, this.updateFeatureGroupSettings, this.deleteFeatureGroupSettings, this.createFeatureSettings, this.getFeatureSettings, this.listFeaturesSettings, this.updateFeatureSettings, this.deleteFeatureSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(FeatureRegistryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createFeatureGroupSettings = settings.createFeatureGroupSettings.toBuilder();
            this.createFeatureGroupOperationSettings = settings.createFeatureGroupOperationSettings.toBuilder();
            this.getFeatureGroupSettings = settings.getFeatureGroupSettings.toBuilder();
            this.listFeatureGroupsSettings = settings.listFeatureGroupsSettings.toBuilder();
            this.updateFeatureGroupSettings = settings.updateFeatureGroupSettings.toBuilder();
            this.updateFeatureGroupOperationSettings = settings.updateFeatureGroupOperationSettings.toBuilder();
            this.deleteFeatureGroupSettings = settings.deleteFeatureGroupSettings.toBuilder();
            this.deleteFeatureGroupOperationSettings = settings.deleteFeatureGroupOperationSettings.toBuilder();
            this.createFeatureSettings = settings.createFeatureSettings.toBuilder();
            this.createFeatureOperationSettings = settings.createFeatureOperationSettings.toBuilder();
            this.getFeatureSettings = settings.getFeatureSettings.toBuilder();
            this.listFeaturesSettings = settings.listFeaturesSettings.toBuilder();
            this.updateFeatureSettings = settings.updateFeatureSettings.toBuilder();
            this.updateFeatureOperationSettings = settings.updateFeatureOperationSettings.toBuilder();
            this.deleteFeatureSettings = settings.deleteFeatureSettings.toBuilder();
            this.deleteFeatureOperationSettings = settings.deleteFeatureOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFeatureGroupSettings, this.getFeatureGroupSettings, this.listFeatureGroupsSettings, this.updateFeatureGroupSettings, this.deleteFeatureGroupSettings, this.createFeatureSettings, this.getFeatureSettings, this.listFeaturesSettings, this.updateFeatureSettings, this.deleteFeatureSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FeatureRegistryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FeatureRegistryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FeatureRegistryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FeatureRegistryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createFeatureGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getFeatureGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listFeatureGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateFeatureGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteFeatureGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listFeaturesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFeatureGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(FeatureGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateFeatureGroupOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateFeatureGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(FeatureGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateFeatureGroupOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteFeatureGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createFeatureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Feature.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateFeatureOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateFeatureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Feature.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateFeatureOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteFeatureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateFeatureGroupRequest, Operation> createFeatureGroupSettings() {
            return this.createFeatureGroupSettings;
        }

        public OperationCallSettings.Builder<CreateFeatureGroupRequest, FeatureGroup, CreateFeatureGroupOperationMetadata> createFeatureGroupOperationSettings() {
            return this.createFeatureGroupOperationSettings;
        }

        public UnaryCallSettings.Builder<GetFeatureGroupRequest, FeatureGroup> getFeatureGroupSettings() {
            return this.getFeatureGroupSettings;
        }

        public PagedCallSettings.Builder<ListFeatureGroupsRequest, ListFeatureGroupsResponse, FeatureRegistryServiceClient.ListFeatureGroupsPagedResponse> listFeatureGroupsSettings() {
            return this.listFeatureGroupsSettings;
        }

        public UnaryCallSettings.Builder<UpdateFeatureGroupRequest, Operation> updateFeatureGroupSettings() {
            return this.updateFeatureGroupSettings;
        }

        public OperationCallSettings.Builder<UpdateFeatureGroupRequest, FeatureGroup, UpdateFeatureGroupOperationMetadata> updateFeatureGroupOperationSettings() {
            return this.updateFeatureGroupOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFeatureGroupRequest, Operation> deleteFeatureGroupSettings() {
            return this.deleteFeatureGroupSettings;
        }

        public OperationCallSettings.Builder<DeleteFeatureGroupRequest, Empty, DeleteOperationMetadata> deleteFeatureGroupOperationSettings() {
            return this.deleteFeatureGroupOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateFeatureRequest, Operation> createFeatureSettings() {
            return this.createFeatureSettings;
        }

        public OperationCallSettings.Builder<CreateFeatureRequest, Feature, CreateFeatureOperationMetadata> createFeatureOperationSettings() {
            return this.createFeatureOperationSettings;
        }

        public UnaryCallSettings.Builder<GetFeatureRequest, Feature> getFeatureSettings() {
            return this.getFeatureSettings;
        }

        public PagedCallSettings.Builder<ListFeaturesRequest, ListFeaturesResponse, FeatureRegistryServiceClient.ListFeaturesPagedResponse> listFeaturesSettings() {
            return this.listFeaturesSettings;
        }

        public UnaryCallSettings.Builder<UpdateFeatureRequest, Operation> updateFeatureSettings() {
            return this.updateFeatureSettings;
        }

        public OperationCallSettings.Builder<UpdateFeatureRequest, Feature, UpdateFeatureOperationMetadata> updateFeatureOperationSettings() {
            return this.updateFeatureOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFeatureRequest, Operation> deleteFeatureSettings() {
            return this.deleteFeatureSettings;
        }

        public OperationCallSettings.Builder<DeleteFeatureRequest, Empty, DeleteOperationMetadata> deleteFeatureOperationSettings() {
            return this.deleteFeatureOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FeatureRegistryServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public FeatureRegistryServiceStubSettings build() throws IOException {
            return new FeatureRegistryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

