/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.BatchImportEvaluatedAnnotationsRequest;
import com.google.cloud.aiplatform.v1.BatchImportEvaluatedAnnotationsResponse;
import com.google.cloud.aiplatform.v1.BatchImportModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1.BatchImportModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1.CopyModelOperationMetadata;
import com.google.cloud.aiplatform.v1.CopyModelRequest;
import com.google.cloud.aiplatform.v1.CopyModelResponse;
import com.google.cloud.aiplatform.v1.DeleteModelRequest;
import com.google.cloud.aiplatform.v1.DeleteModelVersionRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportModelOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportModelRequest;
import com.google.cloud.aiplatform.v1.ExportModelResponse;
import com.google.cloud.aiplatform.v1.GetModelEvaluationRequest;
import com.google.cloud.aiplatform.v1.GetModelEvaluationSliceRequest;
import com.google.cloud.aiplatform.v1.GetModelRequest;
import com.google.cloud.aiplatform.v1.ImportModelEvaluationRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1.ListModelEvaluationsRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationsResponse;
import com.google.cloud.aiplatform.v1.ListModelVersionsRequest;
import com.google.cloud.aiplatform.v1.ListModelVersionsResponse;
import com.google.cloud.aiplatform.v1.ListModelsRequest;
import com.google.cloud.aiplatform.v1.ListModelsResponse;
import com.google.cloud.aiplatform.v1.MergeVersionAliasesRequest;
import com.google.cloud.aiplatform.v1.Model;
import com.google.cloud.aiplatform.v1.ModelEvaluation;
import com.google.cloud.aiplatform.v1.ModelEvaluationSlice;
import com.google.cloud.aiplatform.v1.ModelServiceClient;
import com.google.cloud.aiplatform.v1.UpdateExplanationDatasetOperationMetadata;
import com.google.cloud.aiplatform.v1.UpdateExplanationDatasetRequest;
import com.google.cloud.aiplatform.v1.UpdateExplanationDatasetResponse;
import com.google.cloud.aiplatform.v1.UpdateModelRequest;
import com.google.cloud.aiplatform.v1.UploadModelOperationMetadata;
import com.google.cloud.aiplatform.v1.UploadModelRequest;
import com.google.cloud.aiplatform.v1.UploadModelResponse;
import com.google.cloud.aiplatform.v1.stub.GrpcModelServiceStub;
import com.google.cloud.aiplatform.v1.stub.ModelServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ModelServiceStubSettings
extends StubSettings<ModelServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<UploadModelRequest, Operation> uploadModelSettings;
    private final OperationCallSettings<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationSettings;
    private final UnaryCallSettings<GetModelRequest, Model> getModelSettings;
    private final PagedCallSettings<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings;
    private final PagedCallSettings<ListModelVersionsRequest, ListModelVersionsResponse, ModelServiceClient.ListModelVersionsPagedResponse> listModelVersionsSettings;
    private final UnaryCallSettings<UpdateModelRequest, Model> updateModelSettings;
    private final UnaryCallSettings<UpdateExplanationDatasetRequest, Operation> updateExplanationDatasetSettings;
    private final OperationCallSettings<UpdateExplanationDatasetRequest, UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetOperationSettings;
    private final UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings;
    private final OperationCallSettings<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationSettings;
    private final UnaryCallSettings<DeleteModelVersionRequest, Operation> deleteModelVersionSettings;
    private final OperationCallSettings<DeleteModelVersionRequest, Empty, DeleteOperationMetadata> deleteModelVersionOperationSettings;
    private final UnaryCallSettings<MergeVersionAliasesRequest, Model> mergeVersionAliasesSettings;
    private final UnaryCallSettings<ExportModelRequest, Operation> exportModelSettings;
    private final OperationCallSettings<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationSettings;
    private final UnaryCallSettings<CopyModelRequest, Operation> copyModelSettings;
    private final OperationCallSettings<CopyModelRequest, CopyModelResponse, CopyModelOperationMetadata> copyModelOperationSettings;
    private final UnaryCallSettings<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationSettings;
    private final UnaryCallSettings<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesSettings;
    private final UnaryCallSettings<BatchImportEvaluatedAnnotationsRequest, BatchImportEvaluatedAnnotationsResponse> batchImportEvaluatedAnnotationsSettings;
    private final UnaryCallSettings<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings;
    private final PagedCallSettings<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings;
    private final UnaryCallSettings<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceSettings;
    private final PagedCallSettings<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ModelServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model> LIST_MODELS_PAGE_STR_DESC = new PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model>(){

        public String emptyToken() {
            return "";
        }

        public ListModelsRequest injectToken(ListModelsRequest payload, String token) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageToken(token).build();
        }

        public ListModelsRequest injectPageSize(ListModelsRequest payload, int pageSize) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Model> extractResources(ListModelsResponse payload) {
            return payload.getModelsList() == null ? ImmutableList.of() : payload.getModelsList();
        }
    };
    private static final PagedListDescriptor<ListModelVersionsRequest, ListModelVersionsResponse, Model> LIST_MODEL_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListModelVersionsRequest, ListModelVersionsResponse, Model>(){

        public String emptyToken() {
            return "";
        }

        public ListModelVersionsRequest injectToken(ListModelVersionsRequest payload, String token) {
            return ListModelVersionsRequest.newBuilder((ListModelVersionsRequest)payload).setPageToken(token).build();
        }

        public ListModelVersionsRequest injectPageSize(ListModelVersionsRequest payload, int pageSize) {
            return ListModelVersionsRequest.newBuilder((ListModelVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Model> extractResources(ListModelVersionsResponse payload) {
            return payload.getModelsList() == null ? ImmutableList.of() : payload.getModelsList();
        }
    };
    private static final PagedListDescriptor<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> LIST_MODEL_EVALUATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation>(){

        public String emptyToken() {
            return "";
        }

        public ListModelEvaluationsRequest injectToken(ListModelEvaluationsRequest payload, String token) {
            return ListModelEvaluationsRequest.newBuilder((ListModelEvaluationsRequest)payload).setPageToken(token).build();
        }

        public ListModelEvaluationsRequest injectPageSize(ListModelEvaluationsRequest payload, int pageSize) {
            return ListModelEvaluationsRequest.newBuilder((ListModelEvaluationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelEvaluationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelEvaluationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ModelEvaluation> extractResources(ListModelEvaluationsResponse payload) {
            return payload.getModelEvaluationsList() == null ? ImmutableList.of() : payload.getModelEvaluationsList();
        }
    };
    private static final PagedListDescriptor<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> LIST_MODEL_EVALUATION_SLICES_PAGE_STR_DESC = new PagedListDescriptor<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice>(){

        public String emptyToken() {
            return "";
        }

        public ListModelEvaluationSlicesRequest injectToken(ListModelEvaluationSlicesRequest payload, String token) {
            return ListModelEvaluationSlicesRequest.newBuilder((ListModelEvaluationSlicesRequest)payload).setPageToken(token).build();
        }

        public ListModelEvaluationSlicesRequest injectPageSize(ListModelEvaluationSlicesRequest payload, int pageSize) {
            return ListModelEvaluationSlicesRequest.newBuilder((ListModelEvaluationSlicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelEvaluationSlicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelEvaluationSlicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ModelEvaluationSlice> extractResources(ListModelEvaluationSlicesResponse payload) {
            return payload.getModelEvaluationSlicesList() == null ? ImmutableList.of() : payload.getModelEvaluationSlicesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> LIST_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse>(){

        public ApiFuture<ModelServiceClient.ListModelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelsRequest, ListModelsResponse> callable, ListModelsRequest request, ApiCallContext context, ApiFuture<ListModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelServiceClient.ListModelsPagedResponse.createAsync((PageContext<ListModelsRequest, ListModelsResponse, Model>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListModelVersionsRequest, ListModelVersionsResponse, ModelServiceClient.ListModelVersionsPagedResponse> LIST_MODEL_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelVersionsRequest, ListModelVersionsResponse, ModelServiceClient.ListModelVersionsPagedResponse>(){

        public ApiFuture<ModelServiceClient.ListModelVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelVersionsRequest, ListModelVersionsResponse> callable, ListModelVersionsRequest request, ApiCallContext context, ApiFuture<ListModelVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODEL_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelServiceClient.ListModelVersionsPagedResponse.createAsync((PageContext<ListModelVersionsRequest, ListModelVersionsResponse, Model>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelServiceClient.ListModelEvaluationsPagedResponse> LIST_MODEL_EVALUATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelServiceClient.ListModelEvaluationsPagedResponse>(){

        public ApiFuture<ModelServiceClient.ListModelEvaluationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> callable, ListModelEvaluationsRequest request, ApiCallContext context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODEL_EVALUATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelServiceClient.ListModelEvaluationsPagedResponse.createAsync((PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> LIST_MODEL_EVALUATION_SLICES_PAGE_STR_FACT = new PagedListResponseFactory<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelServiceClient.ListModelEvaluationSlicesPagedResponse>(){

        public ApiFuture<ModelServiceClient.ListModelEvaluationSlicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> callable, ListModelEvaluationSlicesRequest request, ApiCallContext context, ApiFuture<ListModelEvaluationSlicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODEL_EVALUATION_SLICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelServiceClient.ListModelEvaluationSlicesPagedResponse.createAsync((PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ModelServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ModelServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<ModelServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<UploadModelRequest, Operation> uploadModelSettings() {
        return this.uploadModelSettings;
    }

    public OperationCallSettings<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationSettings() {
        return this.uploadModelOperationSettings;
    }

    public UnaryCallSettings<GetModelRequest, Model> getModelSettings() {
        return this.getModelSettings;
    }

    public PagedCallSettings<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings() {
        return this.listModelsSettings;
    }

    public PagedCallSettings<ListModelVersionsRequest, ListModelVersionsResponse, ModelServiceClient.ListModelVersionsPagedResponse> listModelVersionsSettings() {
        return this.listModelVersionsSettings;
    }

    public UnaryCallSettings<UpdateModelRequest, Model> updateModelSettings() {
        return this.updateModelSettings;
    }

    public UnaryCallSettings<UpdateExplanationDatasetRequest, Operation> updateExplanationDatasetSettings() {
        return this.updateExplanationDatasetSettings;
    }

    public OperationCallSettings<UpdateExplanationDatasetRequest, UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetOperationSettings() {
        return this.updateExplanationDatasetOperationSettings;
    }

    public UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings() {
        return this.deleteModelSettings;
    }

    public OperationCallSettings<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationSettings() {
        return this.deleteModelOperationSettings;
    }

    public UnaryCallSettings<DeleteModelVersionRequest, Operation> deleteModelVersionSettings() {
        return this.deleteModelVersionSettings;
    }

    public OperationCallSettings<DeleteModelVersionRequest, Empty, DeleteOperationMetadata> deleteModelVersionOperationSettings() {
        return this.deleteModelVersionOperationSettings;
    }

    public UnaryCallSettings<MergeVersionAliasesRequest, Model> mergeVersionAliasesSettings() {
        return this.mergeVersionAliasesSettings;
    }

    public UnaryCallSettings<ExportModelRequest, Operation> exportModelSettings() {
        return this.exportModelSettings;
    }

    public OperationCallSettings<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationSettings() {
        return this.exportModelOperationSettings;
    }

    public UnaryCallSettings<CopyModelRequest, Operation> copyModelSettings() {
        return this.copyModelSettings;
    }

    public OperationCallSettings<CopyModelRequest, CopyModelResponse, CopyModelOperationMetadata> copyModelOperationSettings() {
        return this.copyModelOperationSettings;
    }

    public UnaryCallSettings<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationSettings() {
        return this.importModelEvaluationSettings;
    }

    public UnaryCallSettings<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesSettings() {
        return this.batchImportModelEvaluationSlicesSettings;
    }

    public UnaryCallSettings<BatchImportEvaluatedAnnotationsRequest, BatchImportEvaluatedAnnotationsResponse> batchImportEvaluatedAnnotationsSettings() {
        return this.batchImportEvaluatedAnnotationsSettings;
    }

    public UnaryCallSettings<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings() {
        return this.getModelEvaluationSettings;
    }

    public PagedCallSettings<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings() {
        return this.listModelEvaluationsSettings;
    }

    public UnaryCallSettings<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceSettings() {
        return this.getModelEvaluationSliceSettings;
    }

    public PagedCallSettings<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesSettings() {
        return this.listModelEvaluationSlicesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ModelServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ModelServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcModelServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ModelServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ModelServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ModelServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.uploadModelSettings = settingsBuilder.uploadModelSettings().build();
        this.uploadModelOperationSettings = settingsBuilder.uploadModelOperationSettings().build();
        this.getModelSettings = settingsBuilder.getModelSettings().build();
        this.listModelsSettings = settingsBuilder.listModelsSettings().build();
        this.listModelVersionsSettings = settingsBuilder.listModelVersionsSettings().build();
        this.updateModelSettings = settingsBuilder.updateModelSettings().build();
        this.updateExplanationDatasetSettings = settingsBuilder.updateExplanationDatasetSettings().build();
        this.updateExplanationDatasetOperationSettings = settingsBuilder.updateExplanationDatasetOperationSettings().build();
        this.deleteModelSettings = settingsBuilder.deleteModelSettings().build();
        this.deleteModelOperationSettings = settingsBuilder.deleteModelOperationSettings().build();
        this.deleteModelVersionSettings = settingsBuilder.deleteModelVersionSettings().build();
        this.deleteModelVersionOperationSettings = settingsBuilder.deleteModelVersionOperationSettings().build();
        this.mergeVersionAliasesSettings = settingsBuilder.mergeVersionAliasesSettings().build();
        this.exportModelSettings = settingsBuilder.exportModelSettings().build();
        this.exportModelOperationSettings = settingsBuilder.exportModelOperationSettings().build();
        this.copyModelSettings = settingsBuilder.copyModelSettings().build();
        this.copyModelOperationSettings = settingsBuilder.copyModelOperationSettings().build();
        this.importModelEvaluationSettings = settingsBuilder.importModelEvaluationSettings().build();
        this.batchImportModelEvaluationSlicesSettings = settingsBuilder.batchImportModelEvaluationSlicesSettings().build();
        this.batchImportEvaluatedAnnotationsSettings = settingsBuilder.batchImportEvaluatedAnnotationsSettings().build();
        this.getModelEvaluationSettings = settingsBuilder.getModelEvaluationSettings().build();
        this.listModelEvaluationsSettings = settingsBuilder.listModelEvaluationsSettings().build();
        this.getModelEvaluationSliceSettings = settingsBuilder.getModelEvaluationSliceSettings().build();
        this.listModelEvaluationSlicesSettings = settingsBuilder.listModelEvaluationSlicesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ModelServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<UploadModelRequest, Operation> uploadModelSettings;
        private final OperationCallSettings.Builder<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationSettings;
        private final UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings;
        private final PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings;
        private final PagedCallSettings.Builder<ListModelVersionsRequest, ListModelVersionsResponse, ModelServiceClient.ListModelVersionsPagedResponse> listModelVersionsSettings;
        private final UnaryCallSettings.Builder<UpdateModelRequest, Model> updateModelSettings;
        private final UnaryCallSettings.Builder<UpdateExplanationDatasetRequest, Operation> updateExplanationDatasetSettings;
        private final OperationCallSettings.Builder<UpdateExplanationDatasetRequest, UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetOperationSettings;
        private final UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings;
        private final OperationCallSettings.Builder<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationSettings;
        private final UnaryCallSettings.Builder<DeleteModelVersionRequest, Operation> deleteModelVersionSettings;
        private final OperationCallSettings.Builder<DeleteModelVersionRequest, Empty, DeleteOperationMetadata> deleteModelVersionOperationSettings;
        private final UnaryCallSettings.Builder<MergeVersionAliasesRequest, Model> mergeVersionAliasesSettings;
        private final UnaryCallSettings.Builder<ExportModelRequest, Operation> exportModelSettings;
        private final OperationCallSettings.Builder<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationSettings;
        private final UnaryCallSettings.Builder<CopyModelRequest, Operation> copyModelSettings;
        private final OperationCallSettings.Builder<CopyModelRequest, CopyModelResponse, CopyModelOperationMetadata> copyModelOperationSettings;
        private final UnaryCallSettings.Builder<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationSettings;
        private final UnaryCallSettings.Builder<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesSettings;
        private final UnaryCallSettings.Builder<BatchImportEvaluatedAnnotationsRequest, BatchImportEvaluatedAnnotationsResponse> batchImportEvaluatedAnnotationsSettings;
        private final UnaryCallSettings.Builder<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings;
        private final PagedCallSettings.Builder<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings;
        private final UnaryCallSettings.Builder<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceSettings;
        private final PagedCallSettings.Builder<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ModelServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.uploadModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.uploadModelOperationSettings = OperationCallSettings.newBuilder();
            this.getModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODELS_PAGE_STR_FACT);
            this.listModelVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODEL_VERSIONS_PAGE_STR_FACT);
            this.updateModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateExplanationDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateExplanationDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.deleteModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteModelOperationSettings = OperationCallSettings.newBuilder();
            this.deleteModelVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteModelVersionOperationSettings = OperationCallSettings.newBuilder();
            this.mergeVersionAliasesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportModelOperationSettings = OperationCallSettings.newBuilder();
            this.copyModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.copyModelOperationSettings = OperationCallSettings.newBuilder();
            this.importModelEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchImportModelEvaluationSlicesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchImportEvaluatedAnnotationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getModelEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listModelEvaluationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODEL_EVALUATIONS_PAGE_STR_FACT);
            this.getModelEvaluationSliceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listModelEvaluationSlicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODEL_EVALUATION_SLICES_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.uploadModelSettings, this.getModelSettings, this.listModelsSettings, this.listModelVersionsSettings, this.updateModelSettings, this.updateExplanationDatasetSettings, this.deleteModelSettings, this.deleteModelVersionSettings, this.mergeVersionAliasesSettings, this.exportModelSettings, this.copyModelSettings, this.importModelEvaluationSettings, (Object[])new UnaryCallSettings.Builder[]{this.batchImportModelEvaluationSlicesSettings, this.batchImportEvaluatedAnnotationsSettings, this.getModelEvaluationSettings, this.listModelEvaluationsSettings, this.getModelEvaluationSliceSettings, this.listModelEvaluationSlicesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ModelServiceStubSettings settings) {
            super((StubSettings)settings);
            this.uploadModelSettings = settings.uploadModelSettings.toBuilder();
            this.uploadModelOperationSettings = settings.uploadModelOperationSettings.toBuilder();
            this.getModelSettings = settings.getModelSettings.toBuilder();
            this.listModelsSettings = settings.listModelsSettings.toBuilder();
            this.listModelVersionsSettings = settings.listModelVersionsSettings.toBuilder();
            this.updateModelSettings = settings.updateModelSettings.toBuilder();
            this.updateExplanationDatasetSettings = settings.updateExplanationDatasetSettings.toBuilder();
            this.updateExplanationDatasetOperationSettings = settings.updateExplanationDatasetOperationSettings.toBuilder();
            this.deleteModelSettings = settings.deleteModelSettings.toBuilder();
            this.deleteModelOperationSettings = settings.deleteModelOperationSettings.toBuilder();
            this.deleteModelVersionSettings = settings.deleteModelVersionSettings.toBuilder();
            this.deleteModelVersionOperationSettings = settings.deleteModelVersionOperationSettings.toBuilder();
            this.mergeVersionAliasesSettings = settings.mergeVersionAliasesSettings.toBuilder();
            this.exportModelSettings = settings.exportModelSettings.toBuilder();
            this.exportModelOperationSettings = settings.exportModelOperationSettings.toBuilder();
            this.copyModelSettings = settings.copyModelSettings.toBuilder();
            this.copyModelOperationSettings = settings.copyModelOperationSettings.toBuilder();
            this.importModelEvaluationSettings = settings.importModelEvaluationSettings.toBuilder();
            this.batchImportModelEvaluationSlicesSettings = settings.batchImportModelEvaluationSlicesSettings.toBuilder();
            this.batchImportEvaluatedAnnotationsSettings = settings.batchImportEvaluatedAnnotationsSettings.toBuilder();
            this.getModelEvaluationSettings = settings.getModelEvaluationSettings.toBuilder();
            this.listModelEvaluationsSettings = settings.listModelEvaluationsSettings.toBuilder();
            this.getModelEvaluationSliceSettings = settings.getModelEvaluationSliceSettings.toBuilder();
            this.listModelEvaluationSlicesSettings = settings.listModelEvaluationSlicesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.uploadModelSettings, this.getModelSettings, this.listModelsSettings, this.listModelVersionsSettings, this.updateModelSettings, this.updateExplanationDatasetSettings, this.deleteModelSettings, this.deleteModelVersionSettings, this.mergeVersionAliasesSettings, this.exportModelSettings, this.copyModelSettings, this.importModelEvaluationSettings, (Object[])new UnaryCallSettings.Builder[]{this.batchImportModelEvaluationSlicesSettings, this.batchImportEvaluatedAnnotationsSettings, this.getModelEvaluationSettings, this.listModelEvaluationsSettings, this.getModelEvaluationSliceSettings, this.listModelEvaluationSlicesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ModelServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ModelServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ModelServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ModelServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.uploadModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listModelVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateExplanationDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteModelVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.mergeVersionAliasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.copyModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importModelEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchImportModelEvaluationSlicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchImportEvaluatedAnnotationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getModelEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listModelEvaluationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getModelEvaluationSliceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listModelEvaluationSlicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.uploadModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UploadModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UploadModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateExplanationDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UpdateExplanationDatasetResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateExplanationDatasetOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteModelVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.copyModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CopyModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CopyModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<UploadModelRequest, Operation> uploadModelSettings() {
            return this.uploadModelSettings;
        }

        public OperationCallSettings.Builder<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationSettings() {
            return this.uploadModelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings() {
            return this.getModelSettings;
        }

        public PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings() {
            return this.listModelsSettings;
        }

        public PagedCallSettings.Builder<ListModelVersionsRequest, ListModelVersionsResponse, ModelServiceClient.ListModelVersionsPagedResponse> listModelVersionsSettings() {
            return this.listModelVersionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateModelRequest, Model> updateModelSettings() {
            return this.updateModelSettings;
        }

        public UnaryCallSettings.Builder<UpdateExplanationDatasetRequest, Operation> updateExplanationDatasetSettings() {
            return this.updateExplanationDatasetSettings;
        }

        public OperationCallSettings.Builder<UpdateExplanationDatasetRequest, UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetOperationSettings() {
            return this.updateExplanationDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings() {
            return this.deleteModelSettings;
        }

        public OperationCallSettings.Builder<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationSettings() {
            return this.deleteModelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteModelVersionRequest, Operation> deleteModelVersionSettings() {
            return this.deleteModelVersionSettings;
        }

        public OperationCallSettings.Builder<DeleteModelVersionRequest, Empty, DeleteOperationMetadata> deleteModelVersionOperationSettings() {
            return this.deleteModelVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<MergeVersionAliasesRequest, Model> mergeVersionAliasesSettings() {
            return this.mergeVersionAliasesSettings;
        }

        public UnaryCallSettings.Builder<ExportModelRequest, Operation> exportModelSettings() {
            return this.exportModelSettings;
        }

        public OperationCallSettings.Builder<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationSettings() {
            return this.exportModelOperationSettings;
        }

        public UnaryCallSettings.Builder<CopyModelRequest, Operation> copyModelSettings() {
            return this.copyModelSettings;
        }

        public OperationCallSettings.Builder<CopyModelRequest, CopyModelResponse, CopyModelOperationMetadata> copyModelOperationSettings() {
            return this.copyModelOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationSettings() {
            return this.importModelEvaluationSettings;
        }

        public UnaryCallSettings.Builder<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesSettings() {
            return this.batchImportModelEvaluationSlicesSettings;
        }

        public UnaryCallSettings.Builder<BatchImportEvaluatedAnnotationsRequest, BatchImportEvaluatedAnnotationsResponse> batchImportEvaluatedAnnotationsSettings() {
            return this.batchImportEvaluatedAnnotationsSettings;
        }

        public UnaryCallSettings.Builder<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings() {
            return this.getModelEvaluationSettings;
        }

        public PagedCallSettings.Builder<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelServiceClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings() {
            return this.listModelEvaluationsSettings;
        }

        public UnaryCallSettings.Builder<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceSettings() {
            return this.getModelEvaluationSliceSettings;
        }

        public PagedCallSettings.Builder<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelServiceClient.ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesSettings() {
            return this.listModelEvaluationSlicesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ModelServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ModelServiceStubSettings build() throws IOException {
            return new ModelServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

