/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.GetScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.ListSchedulesRequest;
import com.google.cloud.aiplatform.v1beta1.ListSchedulesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.PauseScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.ResumeScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.Schedule;
import com.google.cloud.aiplatform.v1beta1.ScheduleName;
import com.google.cloud.aiplatform.v1beta1.ScheduleServiceSettings;
import com.google.cloud.aiplatform.v1beta1.stub.ScheduleServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ScheduleServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ScheduleServiceClient
implements BackgroundResource {
    private final ScheduleServiceSettings settings;
    private final ScheduleServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ScheduleServiceClient create() throws IOException {
        return ScheduleServiceClient.create(ScheduleServiceSettings.newBuilder().build());
    }

    public static final ScheduleServiceClient create(ScheduleServiceSettings settings) throws IOException {
        return new ScheduleServiceClient(settings);
    }

    public static final ScheduleServiceClient create(ScheduleServiceStub stub) {
        return new ScheduleServiceClient(stub);
    }

    protected ScheduleServiceClient(ScheduleServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ScheduleServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ScheduleServiceClient(ScheduleServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ScheduleServiceSettings getSettings() {
        return this.settings;
    }

    public ScheduleServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Schedule createSchedule(LocationName parent, Schedule schedule) {
        CreateScheduleRequest request = CreateScheduleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSchedule(schedule).build();
        return this.createSchedule(request);
    }

    public final Schedule createSchedule(String parent, Schedule schedule) {
        CreateScheduleRequest request = CreateScheduleRequest.newBuilder().setParent(parent).setSchedule(schedule).build();
        return this.createSchedule(request);
    }

    public final Schedule createSchedule(CreateScheduleRequest request) {
        return (Schedule)this.createScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateScheduleRequest, Schedule> createScheduleCallable() {
        return this.stub.createScheduleCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteScheduleAsync(ScheduleName name) {
        DeleteScheduleRequest request = DeleteScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteScheduleAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteScheduleAsync(String name) {
        DeleteScheduleRequest request = DeleteScheduleRequest.newBuilder().setName(name).build();
        return this.deleteScheduleAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteScheduleAsync(DeleteScheduleRequest request) {
        return this.deleteScheduleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteScheduleRequest, Empty, DeleteOperationMetadata> deleteScheduleOperationCallable() {
        return this.stub.deleteScheduleOperationCallable();
    }

    public final UnaryCallable<DeleteScheduleRequest, Operation> deleteScheduleCallable() {
        return this.stub.deleteScheduleCallable();
    }

    public final Schedule getSchedule(ScheduleName name) {
        GetScheduleRequest request = GetScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSchedule(request);
    }

    public final Schedule getSchedule(String name) {
        GetScheduleRequest request = GetScheduleRequest.newBuilder().setName(name).build();
        return this.getSchedule(request);
    }

    public final Schedule getSchedule(GetScheduleRequest request) {
        return (Schedule)this.getScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<GetScheduleRequest, Schedule> getScheduleCallable() {
        return this.stub.getScheduleCallable();
    }

    public final ListSchedulesPagedResponse listSchedules(LocationName parent) {
        ListSchedulesRequest request = ListSchedulesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSchedules(request);
    }

    public final ListSchedulesPagedResponse listSchedules(String parent) {
        ListSchedulesRequest request = ListSchedulesRequest.newBuilder().setParent(parent).build();
        return this.listSchedules(request);
    }

    public final ListSchedulesPagedResponse listSchedules(ListSchedulesRequest request) {
        return (ListSchedulesPagedResponse)((Object)this.listSchedulesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSchedulesRequest, ListSchedulesPagedResponse> listSchedulesPagedCallable() {
        return this.stub.listSchedulesPagedCallable();
    }

    public final UnaryCallable<ListSchedulesRequest, ListSchedulesResponse> listSchedulesCallable() {
        return this.stub.listSchedulesCallable();
    }

    public final void pauseSchedule(ScheduleName name) {
        PauseScheduleRequest request = PauseScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.pauseSchedule(request);
    }

    public final void pauseSchedule(String name) {
        PauseScheduleRequest request = PauseScheduleRequest.newBuilder().setName(name).build();
        this.pauseSchedule(request);
    }

    public final void pauseSchedule(PauseScheduleRequest request) {
        this.pauseScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<PauseScheduleRequest, Empty> pauseScheduleCallable() {
        return this.stub.pauseScheduleCallable();
    }

    public final void resumeSchedule(ScheduleName name) {
        ResumeScheduleRequest request = ResumeScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.resumeSchedule(request);
    }

    public final void resumeSchedule(String name) {
        ResumeScheduleRequest request = ResumeScheduleRequest.newBuilder().setName(name).build();
        this.resumeSchedule(request);
    }

    public final void resumeSchedule(ResumeScheduleRequest request) {
        this.resumeScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeScheduleRequest, Empty> resumeScheduleCallable() {
        return this.stub.resumeScheduleCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSchedulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSchedulesRequest, ListSchedulesResponse, Schedule, ListSchedulesPage, ListSchedulesFixedSizeCollection> {
        private ListSchedulesFixedSizeCollection(List<ListSchedulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSchedulesFixedSizeCollection createEmptyCollection() {
            return new ListSchedulesFixedSizeCollection(null, 0);
        }

        protected ListSchedulesFixedSizeCollection createCollection(List<ListSchedulesPage> pages, int collectionSize) {
            return new ListSchedulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSchedulesPage
    extends AbstractPage<ListSchedulesRequest, ListSchedulesResponse, Schedule, ListSchedulesPage> {
        private ListSchedulesPage(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ListSchedulesResponse response) {
            super(context, (Object)response);
        }

        private static ListSchedulesPage createEmptyPage() {
            return new ListSchedulesPage(null, null);
        }

        protected ListSchedulesPage createPage(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ListSchedulesResponse response) {
            return new ListSchedulesPage(context, response);
        }

        public ApiFuture<ListSchedulesPage> createPageAsync(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ApiFuture<ListSchedulesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSchedulesPagedResponse
    extends AbstractPagedListResponse<ListSchedulesRequest, ListSchedulesResponse, Schedule, ListSchedulesPage, ListSchedulesFixedSizeCollection> {
        public static ApiFuture<ListSchedulesPagedResponse> createAsync(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ApiFuture<ListSchedulesResponse> futureResponse) {
            ApiFuture<ListSchedulesPage> futurePage = ListSchedulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSchedulesPagedResponse((ListSchedulesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSchedulesPagedResponse(ListSchedulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSchedulesFixedSizeCollection.createEmptyCollection());
        }
    }
}

