/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateSpecialistPoolOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.GetSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.ListSpecialistPoolsRequest;
import com.google.cloud.aiplatform.v1beta1.ListSpecialistPoolsResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.SpecialistPool;
import com.google.cloud.aiplatform.v1beta1.SpecialistPoolName;
import com.google.cloud.aiplatform.v1beta1.SpecialistPoolServiceSettings;
import com.google.cloud.aiplatform.v1beta1.UpdateSpecialistPoolOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.stub.SpecialistPoolServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.SpecialistPoolServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SpecialistPoolServiceClient
implements BackgroundResource {
    private final SpecialistPoolServiceSettings settings;
    private final SpecialistPoolServiceStub stub;
    private final OperationsClient operationsClient;

    public static final SpecialistPoolServiceClient create() throws IOException {
        return SpecialistPoolServiceClient.create(SpecialistPoolServiceSettings.newBuilder().build());
    }

    public static final SpecialistPoolServiceClient create(SpecialistPoolServiceSettings settings) throws IOException {
        return new SpecialistPoolServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SpecialistPoolServiceClient create(SpecialistPoolServiceStub stub) {
        return new SpecialistPoolServiceClient(stub);
    }

    protected SpecialistPoolServiceClient(SpecialistPoolServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SpecialistPoolServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SpecialistPoolServiceClient(SpecialistPoolServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final SpecialistPoolServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SpecialistPoolServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolAsync(LocationName parent, SpecialistPool specialistPool) {
        CreateSpecialistPoolRequest request = CreateSpecialistPoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSpecialistPool(specialistPool).build();
        return this.createSpecialistPoolAsync(request);
    }

    public final OperationFuture<SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolAsync(String parent, SpecialistPool specialistPool) {
        CreateSpecialistPoolRequest request = CreateSpecialistPoolRequest.newBuilder().setParent(parent).setSpecialistPool(specialistPool).build();
        return this.createSpecialistPoolAsync(request);
    }

    public final OperationFuture<SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolAsync(CreateSpecialistPoolRequest request) {
        return this.createSpecialistPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSpecialistPoolRequest, SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolOperationCallable() {
        return this.stub.createSpecialistPoolOperationCallable();
    }

    public final UnaryCallable<CreateSpecialistPoolRequest, Operation> createSpecialistPoolCallable() {
        return this.stub.createSpecialistPoolCallable();
    }

    public final SpecialistPool getSpecialistPool(SpecialistPoolName name) {
        GetSpecialistPoolRequest request = GetSpecialistPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpecialistPool(request);
    }

    public final SpecialistPool getSpecialistPool(String name) {
        GetSpecialistPoolRequest request = GetSpecialistPoolRequest.newBuilder().setName(name).build();
        return this.getSpecialistPool(request);
    }

    public final SpecialistPool getSpecialistPool(GetSpecialistPoolRequest request) {
        return (SpecialistPool)this.getSpecialistPoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolCallable() {
        return this.stub.getSpecialistPoolCallable();
    }

    public final ListSpecialistPoolsPagedResponse listSpecialistPools(LocationName parent) {
        ListSpecialistPoolsRequest request = ListSpecialistPoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSpecialistPools(request);
    }

    public final ListSpecialistPoolsPagedResponse listSpecialistPools(String parent) {
        ListSpecialistPoolsRequest request = ListSpecialistPoolsRequest.newBuilder().setParent(parent).build();
        return this.listSpecialistPools(request);
    }

    public final ListSpecialistPoolsPagedResponse listSpecialistPools(ListSpecialistPoolsRequest request) {
        return (ListSpecialistPoolsPagedResponse)((Object)this.listSpecialistPoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSpecialistPoolsRequest, ListSpecialistPoolsPagedResponse> listSpecialistPoolsPagedCallable() {
        return this.stub.listSpecialistPoolsPagedCallable();
    }

    public final UnaryCallable<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse> listSpecialistPoolsCallable() {
        return this.stub.listSpecialistPoolsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteSpecialistPoolAsync(SpecialistPoolName name) {
        DeleteSpecialistPoolRequest request = DeleteSpecialistPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSpecialistPoolAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteSpecialistPoolAsync(String name) {
        DeleteSpecialistPoolRequest request = DeleteSpecialistPoolRequest.newBuilder().setName(name).build();
        return this.deleteSpecialistPoolAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteSpecialistPoolAsync(DeleteSpecialistPoolRequest request) {
        return this.deleteSpecialistPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSpecialistPoolRequest, Empty, DeleteOperationMetadata> deleteSpecialistPoolOperationCallable() {
        return this.stub.deleteSpecialistPoolOperationCallable();
    }

    public final UnaryCallable<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolCallable() {
        return this.stub.deleteSpecialistPoolCallable();
    }

    public final OperationFuture<SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolAsync(SpecialistPool specialistPool, FieldMask updateMask) {
        UpdateSpecialistPoolRequest request = UpdateSpecialistPoolRequest.newBuilder().setSpecialistPool(specialistPool).setUpdateMask(updateMask).build();
        return this.updateSpecialistPoolAsync(request);
    }

    public final OperationFuture<SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolAsync(UpdateSpecialistPoolRequest request) {
        return this.updateSpecialistPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSpecialistPoolRequest, SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolOperationCallable() {
        return this.stub.updateSpecialistPoolOperationCallable();
    }

    public final UnaryCallable<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolCallable() {
        return this.stub.updateSpecialistPoolCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSpecialistPoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool, ListSpecialistPoolsPage, ListSpecialistPoolsFixedSizeCollection> {
        private ListSpecialistPoolsFixedSizeCollection(List<ListSpecialistPoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSpecialistPoolsFixedSizeCollection createEmptyCollection() {
            return new ListSpecialistPoolsFixedSizeCollection(null, 0);
        }

        protected ListSpecialistPoolsFixedSizeCollection createCollection(List<ListSpecialistPoolsPage> pages, int collectionSize) {
            return new ListSpecialistPoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSpecialistPoolsPage
    extends AbstractPage<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool, ListSpecialistPoolsPage> {
        private ListSpecialistPoolsPage(PageContext<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool> context, ListSpecialistPoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListSpecialistPoolsPage createEmptyPage() {
            return new ListSpecialistPoolsPage(null, null);
        }

        protected ListSpecialistPoolsPage createPage(PageContext<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool> context, ListSpecialistPoolsResponse response) {
            return new ListSpecialistPoolsPage(context, response);
        }

        public ApiFuture<ListSpecialistPoolsPage> createPageAsync(PageContext<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool> context, ApiFuture<ListSpecialistPoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSpecialistPoolsPagedResponse
    extends AbstractPagedListResponse<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool, ListSpecialistPoolsPage, ListSpecialistPoolsFixedSizeCollection> {
        public static ApiFuture<ListSpecialistPoolsPagedResponse> createAsync(PageContext<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool> context, ApiFuture<ListSpecialistPoolsResponse> futureResponse) {
            ApiFuture<ListSpecialistPoolsPage> futurePage = ListSpecialistPoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSpecialistPoolsPagedResponse((ListSpecialistPoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSpecialistPoolsPagedResponse(ListSpecialistPoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSpecialistPoolsFixedSizeCollection.createEmptyCollection());
        }
    }
}

