/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.DeleteModelRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportModelOperationMetadata;
import com.google.cloud.aiplatform.v1.ExportModelRequest;
import com.google.cloud.aiplatform.v1.ExportModelResponse;
import com.google.cloud.aiplatform.v1.GetModelEvaluationRequest;
import com.google.cloud.aiplatform.v1.GetModelEvaluationSliceRequest;
import com.google.cloud.aiplatform.v1.GetModelRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1.ListModelEvaluationsRequest;
import com.google.cloud.aiplatform.v1.ListModelEvaluationsResponse;
import com.google.cloud.aiplatform.v1.ListModelsRequest;
import com.google.cloud.aiplatform.v1.ListModelsResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.Model;
import com.google.cloud.aiplatform.v1.ModelEvaluation;
import com.google.cloud.aiplatform.v1.ModelEvaluationName;
import com.google.cloud.aiplatform.v1.ModelEvaluationSlice;
import com.google.cloud.aiplatform.v1.ModelEvaluationSliceName;
import com.google.cloud.aiplatform.v1.ModelName;
import com.google.cloud.aiplatform.v1.ModelServiceSettings;
import com.google.cloud.aiplatform.v1.UpdateModelRequest;
import com.google.cloud.aiplatform.v1.UploadModelOperationMetadata;
import com.google.cloud.aiplatform.v1.UploadModelRequest;
import com.google.cloud.aiplatform.v1.UploadModelResponse;
import com.google.cloud.aiplatform.v1.stub.ModelServiceStub;
import com.google.cloud.aiplatform.v1.stub.ModelServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ModelServiceClient
implements BackgroundResource {
    private final ModelServiceSettings settings;
    private final ModelServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ModelServiceClient create() throws IOException {
        return ModelServiceClient.create(ModelServiceSettings.newBuilder().build());
    }

    public static final ModelServiceClient create(ModelServiceSettings settings) throws IOException {
        return new ModelServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ModelServiceClient create(ModelServiceStub stub) {
        return new ModelServiceClient(stub);
    }

    protected ModelServiceClient(ModelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ModelServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ModelServiceClient(ModelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ModelServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ModelServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<UploadModelResponse, UploadModelOperationMetadata> uploadModelAsync(LocationName parent, Model model) {
        UploadModelRequest request = UploadModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).build();
        return this.uploadModelAsync(request);
    }

    public final OperationFuture<UploadModelResponse, UploadModelOperationMetadata> uploadModelAsync(String parent, Model model) {
        UploadModelRequest request = UploadModelRequest.newBuilder().setParent(parent).setModel(model).build();
        return this.uploadModelAsync(request);
    }

    public final OperationFuture<UploadModelResponse, UploadModelOperationMetadata> uploadModelAsync(UploadModelRequest request) {
        return this.uploadModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationCallable() {
        return this.stub.uploadModelOperationCallable();
    }

    public final UnaryCallable<UploadModelRequest, Operation> uploadModelCallable() {
        return this.stub.uploadModelCallable();
    }

    public final Model getModel(ModelName name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModel(request);
    }

    public final Model getModel(String name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name).build();
        return this.getModel(request);
    }

    public final Model getModel(GetModelRequest request) {
        return (Model)this.getModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.stub.getModelCallable();
    }

    public final ListModelsPagedResponse listModels(LocationName parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(String parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(ListModelsRequest request) {
        return (ListModelsPagedResponse)((Object)this.listModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelsRequest, ListModelsPagedResponse> listModelsPagedCallable() {
        return this.stub.listModelsPagedCallable();
    }

    public final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.stub.listModelsCallable();
    }

    public final Model updateModel(Model model, FieldMask updateMask) {
        UpdateModelRequest request = UpdateModelRequest.newBuilder().setModel(model).setUpdateMask(updateMask).build();
        return this.updateModel(request);
    }

    public final Model updateModel(UpdateModelRequest request) {
        return (Model)this.updateModelCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.stub.updateModelCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelAsync(ModelName name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelAsync(String name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationCallable() {
        return this.stub.deleteModelOperationCallable();
    }

    public final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.stub.deleteModelCallable();
    }

    public final OperationFuture<ExportModelResponse, ExportModelOperationMetadata> exportModelAsync(ModelName name, ExportModelRequest.OutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name == null ? null : name.toString()).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    public final OperationFuture<ExportModelResponse, ExportModelOperationMetadata> exportModelAsync(String name, ExportModelRequest.OutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    public final OperationFuture<ExportModelResponse, ExportModelOperationMetadata> exportModelAsync(ExportModelRequest request) {
        return this.exportModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationCallable() {
        return this.stub.exportModelOperationCallable();
    }

    public final UnaryCallable<ExportModelRequest, Operation> exportModelCallable() {
        return this.stub.exportModelCallable();
    }

    public final ModelEvaluation getModelEvaluation(ModelEvaluationName name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(String name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(GetModelEvaluationRequest request) {
        return (ModelEvaluation)this.getModelEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable() {
        return this.stub.getModelEvaluationCallable();
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ModelName parent) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(String parent) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ListModelEvaluationsRequest request) {
        return (ListModelEvaluationsPagedResponse)((Object)this.listModelEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable() {
        return this.stub.listModelEvaluationsPagedCallable();
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable() {
        return this.stub.listModelEvaluationsCallable();
    }

    public final ModelEvaluationSlice getModelEvaluationSlice(ModelEvaluationSliceName name) {
        GetModelEvaluationSliceRequest request = GetModelEvaluationSliceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelEvaluationSlice(request);
    }

    public final ModelEvaluationSlice getModelEvaluationSlice(String name) {
        GetModelEvaluationSliceRequest request = GetModelEvaluationSliceRequest.newBuilder().setName(name).build();
        return this.getModelEvaluationSlice(request);
    }

    public final ModelEvaluationSlice getModelEvaluationSlice(GetModelEvaluationSliceRequest request) {
        return (ModelEvaluationSlice)this.getModelEvaluationSliceCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceCallable() {
        return this.stub.getModelEvaluationSliceCallable();
    }

    public final ListModelEvaluationSlicesPagedResponse listModelEvaluationSlices(ModelEvaluationName parent) {
        ListModelEvaluationSlicesRequest request = ListModelEvaluationSlicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelEvaluationSlices(request);
    }

    public final ListModelEvaluationSlicesPagedResponse listModelEvaluationSlices(String parent) {
        ListModelEvaluationSlicesRequest request = ListModelEvaluationSlicesRequest.newBuilder().setParent(parent).build();
        return this.listModelEvaluationSlices(request);
    }

    public final ListModelEvaluationSlicesPagedResponse listModelEvaluationSlices(ListModelEvaluationSlicesRequest request) {
        return (ListModelEvaluationSlicesPagedResponse)((Object)this.listModelEvaluationSlicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesPagedCallable() {
        return this.stub.listModelEvaluationSlicesPagedCallable();
    }

    public final UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesCallable() {
        return this.stub.listModelEvaluationSlicesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListModelEvaluationSlicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice, ListModelEvaluationSlicesPage, ListModelEvaluationSlicesFixedSizeCollection> {
        private ListModelEvaluationSlicesFixedSizeCollection(List<ListModelEvaluationSlicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelEvaluationSlicesFixedSizeCollection createEmptyCollection() {
            return new ListModelEvaluationSlicesFixedSizeCollection(null, 0);
        }

        protected ListModelEvaluationSlicesFixedSizeCollection createCollection(List<ListModelEvaluationSlicesPage> pages, int collectionSize) {
            return new ListModelEvaluationSlicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelEvaluationSlicesPage
    extends AbstractPage<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice, ListModelEvaluationSlicesPage> {
        private ListModelEvaluationSlicesPage(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ListModelEvaluationSlicesResponse response) {
            super(context, (Object)response);
        }

        private static ListModelEvaluationSlicesPage createEmptyPage() {
            return new ListModelEvaluationSlicesPage(null, null);
        }

        protected ListModelEvaluationSlicesPage createPage(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ListModelEvaluationSlicesResponse response) {
            return new ListModelEvaluationSlicesPage(context, response);
        }

        public ApiFuture<ListModelEvaluationSlicesPage> createPageAsync(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ApiFuture<ListModelEvaluationSlicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelEvaluationSlicesPagedResponse
    extends AbstractPagedListResponse<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice, ListModelEvaluationSlicesPage, ListModelEvaluationSlicesFixedSizeCollection> {
        public static ApiFuture<ListModelEvaluationSlicesPagedResponse> createAsync(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ApiFuture<ListModelEvaluationSlicesResponse> futureResponse) {
            ApiFuture<ListModelEvaluationSlicesPage> futurePage = ListModelEvaluationSlicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListModelEvaluationSlicesPage, ListModelEvaluationSlicesPagedResponse>(){

                public ListModelEvaluationSlicesPagedResponse apply(ListModelEvaluationSlicesPage input) {
                    return new ListModelEvaluationSlicesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListModelEvaluationSlicesPagedResponse(ListModelEvaluationSlicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelEvaluationSlicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        private ListModelEvaluationsFixedSizeCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelEvaluationsFixedSizeCollection createEmptyCollection() {
            return new ListModelEvaluationsFixedSizeCollection(null, 0);
        }

        protected ListModelEvaluationsFixedSizeCollection createCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            return new ListModelEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelEvaluationsPage
    extends AbstractPage<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage> {
        private ListModelEvaluationsPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelEvaluationsPage createEmptyPage() {
            return new ListModelEvaluationsPage(null, null);
        }

        protected ListModelEvaluationsPage createPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            return new ListModelEvaluationsPage(context, response);
        }

        public ApiFuture<ListModelEvaluationsPage> createPageAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelEvaluationsPagedResponse
    extends AbstractPagedListResponse<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        public static ApiFuture<ListModelEvaluationsPagedResponse> createAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            ApiFuture<ListModelEvaluationsPage> futurePage = ListModelEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListModelEvaluationsPage, ListModelEvaluationsPagedResponse>(){

                public ListModelEvaluationsPagedResponse apply(ListModelEvaluationsPage input) {
                    return new ListModelEvaluationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListModelEvaluationsPagedResponse(ListModelEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        private ListModelsFixedSizeCollection(List<ListModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelsFixedSizeCollection createEmptyCollection() {
            return new ListModelsFixedSizeCollection(null, 0);
        }

        protected ListModelsFixedSizeCollection createCollection(List<ListModelsPage> pages, int collectionSize) {
            return new ListModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelsPage
    extends AbstractPage<ListModelsRequest, ListModelsResponse, Model, ListModelsPage> {
        private ListModelsPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelsPage createEmptyPage() {
            return new ListModelsPage(null, null);
        }

        protected ListModelsPage createPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            return new ListModelsPage(context, response);
        }

        public ApiFuture<ListModelsPage> createPageAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelsPagedResponse
    extends AbstractPagedListResponse<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        public static ApiFuture<ListModelsPagedResponse> createAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            ApiFuture<ListModelsPage> futurePage = ListModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListModelsPage, ListModelsPagedResponse>(){

                public ListModelsPagedResponse apply(ListModelsPage input) {
                    return new ListModelsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListModelsPagedResponse(ListModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

