/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.auto.value.AutoValue;
import com.google.cloud.gcs.analyticscore.client.AutoValue_GcsVectoredReadOptions;
import java.util.Map;

@AutoValue
public abstract class GcsVectoredReadOptions {
    private static final String MAX_MERGE_GAP_KEY = "analytics-core.read.vectored.range.merge-gap.max-bytes";
    private static final String MAX_MERGE_SIZE_KEY = "analytics-core.read.vectored.range.merged-size.max-bytes";

    abstract int getMaxMergeGap();

    abstract int getMaxMergeSize();

    static Builder builder() {
        return new AutoValue_GcsVectoredReadOptions.Builder().setMaxMergeGap(4096).setMaxMergeSize(0x800000);
    }

    public static GcsVectoredReadOptions createFromOptions(Map<String, String> analyticsCoreOptions, String prefix) {
        Builder optionsBuilder = GcsVectoredReadOptions.builder();
        if (analyticsCoreOptions.containsKey(prefix + MAX_MERGE_GAP_KEY)) {
            optionsBuilder.setMaxMergeGap(Integer.parseInt(analyticsCoreOptions.get(prefix + MAX_MERGE_GAP_KEY)));
        }
        if (analyticsCoreOptions.containsKey(prefix + MAX_MERGE_SIZE_KEY)) {
            optionsBuilder.setMaxMergeSize(Integer.parseInt(analyticsCoreOptions.get(prefix + MAX_MERGE_SIZE_KEY)));
        }
        return optionsBuilder.build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setMaxMergeGap(int var1);

        abstract Builder setMaxMergeSize(int var1);

        abstract GcsVectoredReadOptions build();
    }
}

