/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.auto.value.AutoValue;
import com.google.cloud.gcs.analyticscore.client.AutoValue_GcsReadOptions;
import com.google.cloud.gcs.analyticscore.client.GcsVectoredReadOptions;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class GcsReadOptions {
    private static final String GCS_CHANNEL_READ_CHUNK_SIZE_KEY = "channel.read.chunk-size-bytes";
    private static final String DECRYPTION_KEY_KEY = "decryption-key";
    private static final String FOOTER_PREFETCH_ENABLED_KEY = "analytics-core.footer.prefetch.enabled";
    private static final String SMALL_FILE_FOOTER_PREFETCH_SIZE_KEY = "analytics-core.small-file.footer.prefetch.size-bytes";
    private static final String SMALL_FILE_CACHE_THRESHOLD_KEY = "analytics-core.small-file.cache.threshold-bytes";
    private static final String LARGE_FILE_FOOTER_PREFETCH_SIZE_KEY = "analytics-core.large-file.footer.prefetch.size-bytes";
    private static final String USER_PROJECT_KEY = "user-project";
    private static final boolean DEFAULT_FOOTER_PREFETCH_ENABLED = true;
    private static final int DEFAULT_SMALL_FILE_FOOTER_PREFETCH_SIZE = 102400;
    private static final int DEFAULT_LARGE_FILE_FOOTER_PREFETCH_SIZE = 0x100000;
    private static final int DEFAULT_SMALL_FILE_CACHE_THRESHOLD = 0;

    public abstract Optional<Integer> getChunkSize();

    public abstract Optional<String> getDecryptionKey();

    public abstract Optional<String> getUserProjectId();

    public abstract int getFooterPrefetchSizeSmallFile();

    public abstract int getFooterPrefetchSizeLargeFile();

    public abstract boolean isFooterPrefetchEnabled();

    public abstract int getSmallObjectCacheSize();

    public abstract GcsVectoredReadOptions getGcsVectoredReadOptions();

    public static Builder builder() {
        return new AutoValue_GcsReadOptions.Builder().setGcsVectoredReadOptions(GcsVectoredReadOptions.builder().build()).setFooterPrefetchEnabled(true).setFooterPrefetchSizeSmallFile(102400).setFooterPrefetchSizeLargeFile(0x100000).setSmallObjectCacheSize(0);
    }

    public static GcsReadOptions createFromOptions(Map<String, String> analyticsCoreOptions, String prefix) {
        Builder optionsBuilder = GcsReadOptions.builder();
        if (analyticsCoreOptions.containsKey(prefix + GCS_CHANNEL_READ_CHUNK_SIZE_KEY)) {
            optionsBuilder.setChunkSize(Integer.parseInt(analyticsCoreOptions.get(prefix + GCS_CHANNEL_READ_CHUNK_SIZE_KEY)));
        }
        if (analyticsCoreOptions.containsKey(prefix + DECRYPTION_KEY_KEY)) {
            optionsBuilder.setDecryptionKey(analyticsCoreOptions.get(prefix + DECRYPTION_KEY_KEY));
        }
        if (analyticsCoreOptions.containsKey(prefix + USER_PROJECT_KEY)) {
            optionsBuilder.setUserProjectId(analyticsCoreOptions.get(prefix + USER_PROJECT_KEY));
        }
        if (analyticsCoreOptions.containsKey(prefix + FOOTER_PREFETCH_ENABLED_KEY)) {
            optionsBuilder.setFooterPrefetchEnabled(Boolean.parseBoolean(analyticsCoreOptions.get(prefix + FOOTER_PREFETCH_ENABLED_KEY)));
        }
        if (analyticsCoreOptions.containsKey(prefix + SMALL_FILE_FOOTER_PREFETCH_SIZE_KEY)) {
            optionsBuilder.setFooterPrefetchSizeSmallFile(GcsReadOptions.safeParseInteger(analyticsCoreOptions, prefix + SMALL_FILE_FOOTER_PREFETCH_SIZE_KEY));
        }
        if (analyticsCoreOptions.containsKey(prefix + LARGE_FILE_FOOTER_PREFETCH_SIZE_KEY)) {
            optionsBuilder.setFooterPrefetchSizeLargeFile(GcsReadOptions.safeParseInteger(analyticsCoreOptions, prefix + LARGE_FILE_FOOTER_PREFETCH_SIZE_KEY));
        }
        if (analyticsCoreOptions.containsKey(prefix + SMALL_FILE_CACHE_THRESHOLD_KEY)) {
            optionsBuilder.setSmallObjectCacheSize(GcsReadOptions.safeParseInteger(analyticsCoreOptions, prefix + SMALL_FILE_CACHE_THRESHOLD_KEY));
        }
        optionsBuilder.setGcsVectoredReadOptions(GcsVectoredReadOptions.createFromOptions(analyticsCoreOptions, prefix));
        return optionsBuilder.build();
    }

    private static int safeParseInteger(Map<String, String> analyticsCoreOptions, String key) {
        long value = Long.parseLong(analyticsCoreOptions.get(key));
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("%s=%d cannot be greater than Integer.MAX_VALUE (%d)", key, value, Integer.MAX_VALUE));
        }
        return (int)value;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setChunkSize(Integer var1);

        public abstract Builder setDecryptionKey(String var1);

        public abstract Builder setUserProjectId(String var1);

        public abstract Builder setGcsVectoredReadOptions(GcsVectoredReadOptions var1);

        public abstract Builder setFooterPrefetchEnabled(boolean var1);

        public abstract Builder setFooterPrefetchSizeSmallFile(int var1);

        public abstract Builder setFooterPrefetchSizeLargeFile(int var1);

        public abstract Builder setSmallObjectCacheSize(int var1);

        public abstract GcsReadOptions build();
    }
}

