/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.auto.value.AutoValue;
import com.google.cloud.gcs.analyticscore.client.AutoValue_GcsObjectCombinedRange;
import com.google.cloud.gcs.analyticscore.client.GcsObjectRange;
import com.google.common.collect.ImmutableList;

@AutoValue
public abstract class GcsObjectCombinedRange {
    public abstract ImmutableList<GcsObjectRange> getUnderlyingRanges();

    public abstract long getOffset();

    public abstract int getLength();

    public static Builder builder() {
        return new AutoValue_GcsObjectCombinedRange.Builder();
    }

    public GcsObjectCombinedRange union(GcsObjectRange range) {
        ImmutableList.Builder newRanges = ImmutableList.builder();
        newRanges.addAll(this.getUnderlyingRanges());
        newRanges.add((Object)range);
        long newOffset = Math.min(this.getOffset(), range.getOffset());
        long thisEnd = this.getOffset() + (long)this.getLength();
        long rangeEnd = range.getOffset() + (long)range.getLength();
        long newEnd = Math.max(thisEnd, rangeEnd);
        int newLength = (int)(newEnd - newOffset);
        return this.toBuilder().setUnderlyingRanges((ImmutableList<GcsObjectRange>)newRanges.build()).setOffset(newOffset).setLength(newLength).build();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setUnderlyingRanges(ImmutableList<GcsObjectRange> var1);

        public abstract Builder setOffset(long var1);

        public abstract Builder setLength(int var1);

        public abstract GcsObjectCombinedRange build();
    }
}

