/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.cloud.gcs.analyticscore.client.GcsClient;
import com.google.cloud.gcs.analyticscore.client.GcsClientOptions;
import com.google.cloud.gcs.analyticscore.client.GcsItemId;
import com.google.cloud.gcs.analyticscore.client.GcsItemInfo;
import com.google.cloud.gcs.analyticscore.client.GcsReadChannel;
import com.google.cloud.gcs.analyticscore.client.GcsReadOptions;
import com.google.cloud.gcs.analyticscore.client.VectoredSeekableByteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GcsClientImpl
implements GcsClient {
    private static final Logger LOG = LoggerFactory.getLogger(GcsClientImpl.class);
    private static final List<Storage.BlobField> BLOB_METADATA_FIELDS = ImmutableList.of((Object)Storage.BlobField.GENERATION, (Object)Storage.BlobField.SIZE);
    @VisibleForTesting
    Storage storage;
    private final GcsClientOptions clientOptions;
    private Supplier<ExecutorService> executorServiceSupplier;

    GcsClientImpl(Credentials credentials, GcsClientOptions clientOptions, Supplier<ExecutorService> executorServiceSupplier) {
        this.clientOptions = clientOptions;
        this.storage = this.createStorage(Optional.of(credentials));
        this.executorServiceSupplier = executorServiceSupplier;
    }

    GcsClientImpl(GcsClientOptions clientOptions, Supplier<ExecutorService> executorServiceSupplier) {
        this.clientOptions = clientOptions;
        this.storage = this.createStorage(Optional.empty());
        this.executorServiceSupplier = executorServiceSupplier;
    }

    @Override
    public VectoredSeekableByteChannel openReadChannel(GcsItemInfo gcsItemInfo, GcsReadOptions readOptions) throws IOException {
        Preconditions.checkNotNull((Object)gcsItemInfo, (Object)"itemInfo should not be null");
        Preconditions.checkNotNull((Object)readOptions, (Object)"readOptions should not be null");
        Preconditions.checkArgument((boolean)gcsItemInfo.getItemId().isGcsObject(), (Object)("Expected GCS object to be provided. But got: " + String.valueOf(gcsItemInfo.getItemId())));
        return new GcsReadChannel(this.storage, gcsItemInfo, readOptions, this.executorServiceSupplier);
    }

    @Override
    public VectoredSeekableByteChannel openReadChannel(GcsItemId gcsItemId, GcsReadOptions readOptions) throws IOException {
        Preconditions.checkNotNull((Object)gcsItemId, (Object)"gcsItemId should not be null");
        Preconditions.checkNotNull((Object)readOptions, (Object)"readOptions should not be null");
        return new GcsReadChannel(this.storage, gcsItemId, readOptions, this.executorServiceSupplier){

            @Override
            public long size() throws IOException {
                if (this.itemInfo == null) {
                    this.itemInfo = GcsClientImpl.this.getGcsItemInfo(this.itemId);
                    this.itemId = this.itemInfo.getItemId();
                }
                return this.itemInfo.getSize();
            }
        };
    }

    @Override
    public GcsItemInfo getGcsItemInfo(GcsItemId itemId) throws IOException {
        Preconditions.checkNotNull((Object)itemId, (Object)"Item ID must not be null.");
        if (itemId.isGcsObject()) {
            return this.getGcsObjectInfo(itemId);
        }
        throw new UnsupportedOperationException(String.format("Expected gcs object but got %s", itemId));
    }

    @Override
    public void close() {
        try {
            this.storage.close();
        }
        catch (Exception e) {
            LOG.debug("Exception while closing storage instance", (Throwable)e);
        }
    }

    @VisibleForTesting
    protected Storage createStorage(Optional<Credentials> credentials) {
        StorageOptions.Builder builder = StorageOptions.newBuilder();
        this.clientOptions.getUserAgent().ifPresent(userAgent -> builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)ImmutableMap.of((Object)"User-agent", (Object)userAgent))));
        this.clientOptions.getProjectId().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setProjectId(arg_0));
        this.clientOptions.getClientLibToken().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setClientLibToken(arg_0));
        this.clientOptions.getServiceHost().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setHost(arg_0));
        credentials.ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setCredentials(arg_0));
        return (Storage)builder.build().getService();
    }

    private GcsItemInfo getGcsObjectInfo(GcsItemId itemId) throws IOException {
        Preconditions.checkArgument((boolean)itemId.isGcsObject(), (Object)String.format("Expected gcs object got %s", itemId));
        Blob blob = this.getBlob(itemId.getBucketName(), itemId.getObjectName().get());
        if (blob == null) {
            throw new IOException("Object not found:" + String.valueOf(itemId));
        }
        GcsItemId itemIdWithGeneration = GcsItemId.builder().setContentGeneration(blob.getGeneration()).setBucketName(blob.getBucket()).setObjectName(blob.getName()).build();
        return GcsItemInfo.builder().setItemId(itemIdWithGeneration).setSize(blob.getSize()).setContentGeneration(blob.getGeneration()).build();
    }

    private Blob getBlob(String bucketName, String objectName) throws IOException {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)objectName);
        BlobId blobId = BlobId.of((String)bucketName, (String)objectName);
        try {
            return this.storage.get(blobId, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])BLOB_METADATA_FIELDS.toArray(new Storage.BlobField[0]))});
        }
        catch (StorageException storageException) {
            throw new IOException("Unable to access blob :" + String.valueOf(blobId), storageException);
        }
    }
}

