/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.cloud.gcs.analyticscore.client.GcsItemId;
import com.google.cloud.gcs.analyticscore.client.GcsItemInfo;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

final class AutoValue_GcsItemInfo
extends GcsItemInfo {
    private final GcsItemId itemId;
    private final long size;
    private final Optional<Long> contentGeneration;

    private AutoValue_GcsItemInfo(GcsItemId itemId, long size, Optional<Long> contentGeneration) {
        this.itemId = itemId;
        this.size = size;
        this.contentGeneration = contentGeneration;
    }

    @Override
    public GcsItemId getItemId() {
        return this.itemId;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Optional<Long> getContentGeneration() {
        return this.contentGeneration;
    }

    public String toString() {
        return "GcsItemInfo{itemId=" + String.valueOf(this.itemId) + ", size=" + this.size + ", contentGeneration=" + String.valueOf(this.contentGeneration) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GcsItemInfo) {
            GcsItemInfo that = (GcsItemInfo)o;
            return this.itemId.equals(that.getItemId()) && this.size == that.getSize() && this.contentGeneration.equals(that.getContentGeneration());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.itemId.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.size >>> 32 ^ this.size);
        h$ *= 1000003;
        return h$ ^= this.contentGeneration.hashCode();
    }

    static final class Builder
    extends GcsItemInfo.Builder {
        private @Nullable GcsItemId itemId;
        private long size;
        private Optional<Long> contentGeneration = Optional.empty();
        private byte set$0;

        Builder() {
        }

        @Override
        public GcsItemInfo.Builder setItemId(GcsItemId itemId) {
            if (itemId == null) {
                throw new NullPointerException("Null itemId");
            }
            this.itemId = itemId;
            return this;
        }

        @Override
        public GcsItemInfo.Builder setSize(long size) {
            this.size = size;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public GcsItemInfo.Builder setContentGeneration(long contentGeneration) {
            this.contentGeneration = Optional.of(contentGeneration);
            return this;
        }

        @Override
        public GcsItemInfo build() {
            if (this.set$0 != 1 || this.itemId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.itemId == null) {
                    missing.append(" itemId");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" size");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_GcsItemInfo(this.itemId, this.size, this.contentGeneration);
        }
    }
}

