/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gcs.analyticscore.client;

import com.google.cloud.gcs.analyticscore.client.GcsClientOptions;
import com.google.cloud.gcs.analyticscore.client.GcsReadOptions;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

final class AutoValue_GcsClientOptions
extends GcsClientOptions {
    private final Optional<String> projectId;
    private final Optional<String> clientLibToken;
    private final Optional<String> serviceHost;
    private final Optional<String> userAgent;
    private final GcsReadOptions gcsReadOptions;

    private AutoValue_GcsClientOptions(Optional<String> projectId, Optional<String> clientLibToken, Optional<String> serviceHost, Optional<String> userAgent, GcsReadOptions gcsReadOptions) {
        this.projectId = projectId;
        this.clientLibToken = clientLibToken;
        this.serviceHost = serviceHost;
        this.userAgent = userAgent;
        this.gcsReadOptions = gcsReadOptions;
    }

    @Override
    public Optional<String> getProjectId() {
        return this.projectId;
    }

    @Override
    public Optional<String> getClientLibToken() {
        return this.clientLibToken;
    }

    @Override
    public Optional<String> getServiceHost() {
        return this.serviceHost;
    }

    @Override
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @Override
    public GcsReadOptions getGcsReadOptions() {
        return this.gcsReadOptions;
    }

    public String toString() {
        return "GcsClientOptions{projectId=" + String.valueOf(this.projectId) + ", clientLibToken=" + String.valueOf(this.clientLibToken) + ", serviceHost=" + String.valueOf(this.serviceHost) + ", userAgent=" + String.valueOf(this.userAgent) + ", gcsReadOptions=" + String.valueOf(this.gcsReadOptions) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GcsClientOptions) {
            GcsClientOptions that = (GcsClientOptions)o;
            return this.projectId.equals(that.getProjectId()) && this.clientLibToken.equals(that.getClientLibToken()) && this.serviceHost.equals(that.getServiceHost()) && this.userAgent.equals(that.getUserAgent()) && this.gcsReadOptions.equals(that.getGcsReadOptions());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.clientLibToken.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceHost.hashCode();
        h$ *= 1000003;
        h$ ^= this.userAgent.hashCode();
        h$ *= 1000003;
        return h$ ^= this.gcsReadOptions.hashCode();
    }

    static final class Builder
    extends GcsClientOptions.Builder {
        private Optional<String> projectId = Optional.empty();
        private Optional<String> clientLibToken = Optional.empty();
        private Optional<String> serviceHost = Optional.empty();
        private Optional<String> userAgent = Optional.empty();
        private @Nullable GcsReadOptions gcsReadOptions;

        Builder() {
        }

        @Override
        public GcsClientOptions.Builder setProjectId(String projectId) {
            this.projectId = Optional.of(projectId);
            return this;
        }

        @Override
        public GcsClientOptions.Builder setClientLibToken(String clientLibToken) {
            this.clientLibToken = Optional.of(clientLibToken);
            return this;
        }

        @Override
        public GcsClientOptions.Builder setServiceHost(String serviceHost) {
            this.serviceHost = Optional.of(serviceHost);
            return this;
        }

        @Override
        public GcsClientOptions.Builder setUserAgent(String userAgent) {
            this.userAgent = Optional.of(userAgent);
            return this;
        }

        @Override
        public GcsClientOptions.Builder setGcsReadOptions(GcsReadOptions gcsReadOptions) {
            if (gcsReadOptions == null) {
                throw new NullPointerException("Null gcsReadOptions");
            }
            this.gcsReadOptions = gcsReadOptions;
            return this;
        }

        @Override
        public GcsClientOptions build() {
            if (this.gcsReadOptions == null) {
                String missing = " gcsReadOptions";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GcsClientOptions(this.projectId, this.clientLibToken, this.serviceHost, this.userAgent, this.gcsReadOptions);
        }
    }
}

