/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.cloudevents.Attributes;
import io.cloudevents.json.ZonedDateTimeDeserializer;
import io.cloudevents.v1.ContextAttributes;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class AttributesImpl
implements Attributes {
    @NotBlank
    private final String id;
    @NotNull
    private final URI source;
    @NotBlank
    @Pattern(regexp="1\\.0")
    private final @NotBlank @Pattern(regexp="1\\.0") String specversion;
    @NotBlank
    private final String type;
    private final String datacontenttype;
    private final URI dataschema;
    @Size(min=1)
    private final @Size(min=1) String subject;
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    private final ZonedDateTime time;

    public AttributesImpl(String id, URI source, String specversion, String type, String datacontenttype, URI dataschema, String subject, ZonedDateTime time) {
        this.id = id;
        this.source = source;
        this.specversion = specversion;
        this.type = type;
        this.datacontenttype = datacontenttype;
        this.dataschema = dataschema;
        this.subject = subject;
        this.time = time;
    }

    @Override
    public Optional<String> getMediaType() {
        return this.getDatacontenttype();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public String getSpecversion() {
        return this.specversion;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Optional<String> getDatacontenttype() {
        return Optional.ofNullable(this.datacontenttype);
    }

    public Optional<URI> getDataschema() {
        return Optional.ofNullable(this.dataschema);
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public Optional<ZonedDateTime> getTime() {
        return Optional.ofNullable(this.time);
    }

    public String toString() {
        return "AttibutesImpl [id=" + this.id + ", source=" + this.source + ", specversion=" + this.specversion + ", type=" + this.type + ", datacontenttype=" + this.datacontenttype + ", dataschema=" + this.dataschema + ", subject=" + this.subject + ", time=" + this.time + "]";
    }

    @JsonCreator
    public static AttributesImpl build(@JsonProperty(value="id") String id, @JsonProperty(value="source") URI source, @JsonProperty(value="specversion") String specversion, @JsonProperty(value="type") String type, @JsonProperty(value="datacontenttype") String datacontenttype, @JsonProperty(value="dataschema") URI dataschema, @JsonProperty(value="subject") String subject, @JsonProperty(value="time") ZonedDateTime time) {
        return new AttributesImpl(id, source, specversion, type, datacontenttype, dataschema, subject, time);
    }

    public static Map<String, String> marshal(AttributesImpl attributes) {
        Objects.requireNonNull(attributes);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ContextAttributes.id.name(), attributes.getId());
        result.put(ContextAttributes.source.name(), attributes.getSource().toString());
        result.put(ContextAttributes.specversion.name(), attributes.getSpecversion());
        result.put(ContextAttributes.type.name(), attributes.getType());
        attributes.getDatacontenttype().ifPresent(dct -> result.put(ContextAttributes.datacontenttype.name(), (String)dct));
        attributes.getDataschema().ifPresent(dataschema -> result.put(ContextAttributes.dataschema.name(), dataschema.toString()));
        attributes.getSubject().ifPresent(subject -> result.put(ContextAttributes.subject.name(), (String)subject));
        attributes.getTime().ifPresent(time -> result.put(ContextAttributes.time.name(), time.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        return result;
    }

    public static AttributesImpl unmarshal(Map<String, String> attributes) {
        String type = attributes.get(ContextAttributes.type.name());
        ZonedDateTime time = Optional.ofNullable(attributes.get(ContextAttributes.time.name())).map(t -> ZonedDateTime.parse(t, DateTimeFormatter.ISO_ZONED_DATE_TIME)).orElse(null);
        String specversion = attributes.get(ContextAttributes.specversion.name());
        URI source = URI.create(attributes.get(ContextAttributes.source.name()));
        URI dataschema = Optional.ofNullable(attributes.get(ContextAttributes.dataschema.name())).map(URI::create).orElse(null);
        String id = attributes.get(ContextAttributes.id.name());
        String datacontenttype = attributes.get(ContextAttributes.datacontenttype.name());
        String subject = attributes.get(ContextAttributes.subject.name());
        return AttributesImpl.build(id, source, specversion, type, datacontenttype, dataschema, subject, time);
    }
}

