/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.invoker.http.HttpRequestImpl;
import com.google.cloud.functions.invoker.http.HttpResponseImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NewHttpFunctionExecutor
extends HttpServlet {
    private static final Logger logger = Logger.getLogger("com.google.cloud.functions.invoker");
    private final HttpFunction function;

    private NewHttpFunctionExecutor(HttpFunction function) {
        this.function = function;
    }

    public static NewHttpFunctionExecutor forClass(Class<?> functionClass) {
        if (!HttpFunction.class.isAssignableFrom(functionClass)) {
            String string = functionClass.getName();
            String string2 = HttpFunction.class.getName();
            throw new RuntimeException(new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Class ").append(string).append(" does not implement ").append(string2).toString());
        }
        Class<HttpFunction> httpFunctionClass = functionClass.asSubclass(HttpFunction.class);
        try {
            HttpFunction httpFunction = httpFunctionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return new NewHttpFunctionExecutor(httpFunction);
        }
        catch (ReflectiveOperationException e) {
            String string = functionClass.getName();
            String string3 = String.valueOf(e);
            throw new RuntimeException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Could not construct an instance of ").append(string).append(": ").append(string3).toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) {
        HttpRequestImpl reqImpl = new HttpRequestImpl(req);
        HttpResponseImpl respImpl = new HttpResponseImpl(res);
        try {
            this.function.service(reqImpl, respImpl);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to execute {0}", this.function.getClass().getName());
            t.printStackTrace();
            res.setStatus(500);
        }
        finally {
            try {
                try {
                    respImpl.getOutputStream().flush();
                }
                catch (IllegalStateException e) {
                    respImpl.getWriter().flush();
                }
            }
            catch (IOException e) {}
        }
    }
}

