/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.plugin;

import com.google.cloud.functions.invoker.runner.Invoker;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.COMPILE)
public class RunFunction
extends AbstractMojo {
    @Parameter(property="run.functionTarget")
    private String functionTarget;
    @Parameter(property="run.port", defaultValue="8080")
    private Integer port;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;

    public void execute() throws MojoExecutionException {
        String classpath = String.join((CharSequence)File.pathSeparator, this.compilePath);
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("--classpath", classpath));
        if (this.functionTarget != null) {
            args.addAll(Arrays.asList("--target", this.functionTarget));
        }
        try {
            String string = String.valueOf(args);
            this.getLog().info((CharSequence)new StringBuilder(21 + String.valueOf(string).length()).append("Calling Invoker with ").append(string).toString());
            Invoker.main((String[])args.toArray(new String[0]));
        }
        catch (Exception e) {
            String string = String.valueOf(e);
            this.getLog().error((CharSequence)new StringBuilder(27 + String.valueOf(string).length()).append("Could not invoke function: ").append(string).toString(), (Throwable)e);
            throw new MojoExecutionException("Could not invoke function", e);
        }
    }
}

