/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.r2dbc.util.Assert;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpannerConnectionConfiguration {
    public static final String FQDN_PATTERN_GENERATE = "projects/%s/instances/%s/databases/%s";
    public static final Pattern FQDN_PATTERN_PARSE = Pattern.compile("projects\\/([\\w\\-]+)\\/instances\\/([\\w\\-]+)\\/databases\\/([\\w\\-]+)$");
    private static final String USER_AGENT_LIBRARY_NAME = "cloud-spanner-r2dbc";
    private static final String PACKAGE_VERSION = SpannerConnectionConfiguration.class.getPackage().getImplementationVersion();
    private static final String USER_AGENT_KEY = "user-agent";
    private final String fullyQualifiedDbName;
    private String projectId;
    private String instanceName;
    private String databaseName;
    private final OAuth2Credentials credentials;
    private int partialResultSetFetchSize;
    private Duration ddlOperationTimeout;
    private Duration ddlOperationPollInterval;
    private boolean usePlainText;
    private String optimizerVersion;
    private boolean readonly;
    private boolean autocommit;

    private SpannerConnectionConfiguration(String projectId, String instanceName, String databaseName, OAuth2Credentials credentials) {
        Assert.requireNonNull(projectId, "projectId must not be null");
        Assert.requireNonNull(instanceName, "instanceName must not be null");
        Assert.requireNonNull(databaseName, "databaseName must not be null");
        this.projectId = projectId;
        this.instanceName = instanceName;
        this.databaseName = databaseName;
        this.fullyQualifiedDbName = String.format(FQDN_PATTERN_GENERATE, projectId, instanceName, databaseName);
        this.credentials = credentials;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getFullyQualifiedDatabaseName() {
        return this.fullyQualifiedDbName;
    }

    public OAuth2Credentials getCredentials() {
        return this.credentials;
    }

    public int getPartialResultSetFetchSize() {
        return this.partialResultSetFetchSize;
    }

    public Duration getDdlOperationTimeout() {
        return this.ddlOperationTimeout;
    }

    public Duration getDdlOperationPollInterval() {
        return this.ddlOperationPollInterval;
    }

    public boolean isUsePlainText() {
        return this.usePlainText;
    }

    public String getOptimizerVersion() {
        return this.optimizerVersion;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpannerConnectionConfiguration that = (SpannerConnectionConfiguration)o;
        return this.partialResultSetFetchSize == that.partialResultSetFetchSize && Objects.equals(this.fullyQualifiedDbName, that.fullyQualifiedDbName) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.ddlOperationTimeout, that.ddlOperationTimeout) && Objects.equals(this.ddlOperationPollInterval, that.ddlOperationPollInterval);
    }

    public int hashCode() {
        return Objects.hash(this.fullyQualifiedDbName, this.credentials, this.partialResultSetFetchSize, this.ddlOperationTimeout, this.ddlOperationPollInterval);
    }

    public SpannerOptions buildSpannerOptions() {
        SpannerOptions.Builder optionsBuilder = SpannerOptions.newBuilder();
        if (this.projectId != null) {
            optionsBuilder.setProjectId(this.projectId);
        }
        if (this.credentials != null) {
            optionsBuilder.setCredentials((Credentials)this.credentials);
        }
        optionsBuilder.setHeaderProvider(() -> Collections.singletonMap(USER_AGENT_KEY, "cloud-spanner-r2dbc/" + PACKAGE_VERSION));
        return optionsBuilder.build();
    }

    public static class Builder {
        private String fullyQualifiedDatabaseName;
        private String projectId;
        private String instanceName;
        private String databaseName;
        private OAuth2Credentials credentials;
        private int partialResultSetFetchSize = 1;
        private Duration ddlOperationTimeout = Duration.ofSeconds(600L);
        private Duration ddlOperationPollInterval = Duration.ofSeconds(5L);
        private boolean usePlainText = false;
        private String optimizerVersion;
        private boolean readonly = false;
        private boolean autocommit = true;

        @Deprecated
        public Builder setUrl(String url) {
            String databaseString = (String)ConnectionFactoryOptions.parse((CharSequence)url).getValue(ConnectionFactoryOptions.DATABASE);
            this.validateFullyQualifiedDatabaseName(databaseString);
            this.fullyQualifiedDatabaseName = databaseString;
            return this;
        }

        public Builder setFullyQualifiedDatabaseName(String databaseName) {
            this.validateFullyQualifiedDatabaseName(databaseName);
            this.fullyQualifiedDatabaseName = databaseName;
            return this;
        }

        private void validateFullyQualifiedDatabaseName(String databaseString) {
            if (!FQDN_PATTERN_PARSE.matcher(databaseString).matches()) {
                throw new IllegalArgumentException(String.format("Malformed Cloud Spanner Database String: %s. The url must have the format: %s", databaseString, SpannerConnectionConfiguration.FQDN_PATTERN_GENERATE));
            }
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setInstanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setCredentials(OAuth2Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder setPartialResultSetFetchSize(int fetchSize) {
            this.partialResultSetFetchSize = fetchSize;
            return this;
        }

        public Builder setDdlOperationTimeout(Duration duration) {
            this.ddlOperationTimeout = duration;
            return this;
        }

        public Builder setDdlOperationPollInterval(Duration duration) {
            this.ddlOperationPollInterval = duration;
            return this;
        }

        public Builder setUsePlainText(boolean usePlainText) {
            this.usePlainText = true;
            return this;
        }

        public Builder setOptimizerVersion(String optimizerVersion) {
            this.optimizerVersion = optimizerVersion;
            return this;
        }

        public Builder setReadonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public Builder setAutocommit(boolean autocommit) {
            this.autocommit = autocommit;
            return this;
        }

        public SpannerConnectionConfiguration build() {
            try {
                if (this.credentials == null) {
                    this.credentials = GoogleCredentials.getApplicationDefault();
                }
            }
            catch (IOException e) {
                throw new R2dbcNonTransientResourceException("Could not acquire default application credentials", (Throwable)e);
            }
            if (this.fullyQualifiedDatabaseName != null) {
                Matcher matcher = FQDN_PATTERN_PARSE.matcher(this.fullyQualifiedDatabaseName);
                if (matcher.find()) {
                    this.projectId = matcher.group(1);
                    this.instanceName = matcher.group(2);
                    this.databaseName = matcher.group(3);
                } else {
                    throw new IllegalArgumentException("Invalid database name: " + this.fullyQualifiedDatabaseName);
                }
            }
            SpannerConnectionConfiguration configuration = new SpannerConnectionConfiguration(this.projectId, this.instanceName, this.databaseName, this.credentials);
            configuration.partialResultSetFetchSize = this.partialResultSetFetchSize;
            configuration.ddlOperationTimeout = this.ddlOperationTimeout;
            configuration.ddlOperationPollInterval = this.ddlOperationPollInterval;
            configuration.usePlainText = this.usePlainText;
            configuration.optimizerVersion = this.optimizerVersion;
            configuration.readonly = this.readonly;
            configuration.autocommit = this.autocommit;
            return configuration;
        }
    }
}

