/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryConverters;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

class ClientLibraryDecoder {
    private static final Map<Type, BiFunction<Struct, Integer, Object>> decodersMap = ClientLibraryDecoder.createDecoders();
    private static final Map<Type, BiFunction<Struct, Integer, Object>> arrayDecodersMap = ClientLibraryDecoder.createArrayDecoders();

    ClientLibraryDecoder() {
    }

    private static Map<Type, BiFunction<Struct, Integer, Object>> createArrayDecoders() {
        HashMap<Type, BiFunction<Struct, Integer, Object>> decoders = new HashMap<Type, BiFunction<Struct, Integer, Object>>();
        decoders.put(Type.array((Type)Type.int64()), AbstractStructReader::getLongArray);
        decoders.put(Type.array((Type)Type.float64()), AbstractStructReader::getDoubleArray);
        decoders.put(Type.array((Type)Type.bool()), AbstractStructReader::getBooleanArray);
        return decoders;
    }

    private static Map<Type, BiFunction<Struct, Integer, Object>> createDecoders() {
        HashMap<Type, BiFunction<Struct, Integer, Object>> decoders = new HashMap<Type, BiFunction<Struct, Integer, Object>>();
        decoders.put(Type.int64(), AbstractStructReader::getLong);
        decoders.put(Type.array((Type)Type.int64()), AbstractStructReader::getLongList);
        decoders.put(Type.float64(), AbstractStructReader::getDouble);
        decoders.put(Type.array((Type)Type.float64()), AbstractStructReader::getDoubleList);
        decoders.put(Type.bool(), AbstractStructReader::getBoolean);
        decoders.put(Type.array((Type)Type.bool()), AbstractStructReader::getBooleanList);
        decoders.put(Type.bytes(), AbstractStructReader::getBytes);
        decoders.put(Type.array((Type)Type.bytes()), AbstractStructReader::getBytesList);
        decoders.put(Type.date(), AbstractStructReader::getDate);
        decoders.put(Type.array((Type)Type.date()), AbstractStructReader::getDateList);
        decoders.put(Type.string(), AbstractStructReader::getString);
        decoders.put(Type.array((Type)Type.string()), AbstractStructReader::getStringList);
        decoders.put(Type.timestamp(), AbstractStructReader::getTimestamp);
        decoders.put(Type.array((Type)Type.timestamp()), AbstractStructReader::getTimestampList);
        decoders.put(Type.numeric(), AbstractStructReader::getBigDecimal);
        decoders.put(Type.array((Type)Type.numeric()), AbstractStructReader::getBigDecimalList);
        return decoders;
    }

    public static <T> T decode(Struct struct, int index, Class<T> type) {
        Map<Type, BiFunction<Struct, Integer, Object>> selectedCodecsMap = type.isArray() ? arrayDecodersMap : decodersMap;
        T value = struct.isNull(index) ? null : (T)ClientLibraryDecoder.readAndConvert(struct, index, selectedCodecsMap, type);
        return value;
    }

    private static <T> T readAndConvert(Struct struct, int index, Map<Type, BiFunction<Struct, Integer, Object>> selectedCodecsMap, Class<T> type) {
        Object value = selectedCodecsMap.get(struct.getColumnType(index)).apply(struct, index);
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return SpannerClientLibraryConverters.convert(value, type);
    }
}

