/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.r2dbc.CredentialsHelper;
import com.google.cloud.spanner.r2dbc.SpannerConnectionConfiguration;
import com.google.cloud.spanner.r2dbc.SpannerConnectionFactory;
import com.google.cloud.spanner.r2dbc.client.Client;
import com.google.cloud.spanner.r2dbc.client.GrpcClient;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryConnectionFactory;
import com.google.common.annotations.VisibleForTesting;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.util.HashSet;

public class SpannerConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String DRIVER_NAME = "spanner";
    public static final Option<String> PROJECT = Option.valueOf((String)"project");
    public static final Option<String> INSTANCE = Option.valueOf((String)"instance");
    public static final Option<String> URL = Option.valueOf((String)"url");
    public static final Option<Integer> THREAD_POOL_SIZE = Option.valueOf((String)"thread_pool_size");
    public static final Option<Integer> PARTIAL_RESULT_SET_FETCH_SIZE = Option.valueOf((String)"partial_result_set_fetch_size");
    public static final Option<Duration> DDL_OPERATION_TIMEOUT = Option.valueOf((String)"ddl_operation_timeout");
    public static final Option<Duration> DDL_OPERATION_POLL_INTERVAL = Option.valueOf((String)"ddl_operation_poll_interval");
    public static final Option<String> OPTIMIZER_VERSION = Option.valueOf((String)"optimizerVersion");
    public static final Option<GoogleCredentials> GOOGLE_CREDENTIALS = Option.valueOf((String)"google_credentials");
    public static final Option<String> CREDENTIALS = Option.valueOf((String)"credentials");
    public static final Option<Boolean> USE_PLAIN_TEXT = Option.valueOf((String)"usePlainText");
    public static final Option<String> OAUTH_TOKEN = Option.valueOf((String)"oauthToken");
    private static final Option[] SECURITY_OPTIONS = new Option[]{OAUTH_TOKEN, CREDENTIALS, GOOGLE_CREDENTIALS};
    private Client client;
    private CredentialsHelper credentialsHelper = new CredentialsHelper();

    public ConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        SpannerConnectionConfiguration config = this.createConfiguration(connectionFactoryOptions);
        if (connectionFactoryOptions.hasOption(Option.valueOf((String)"client-implementation")) && connectionFactoryOptions.getValue(Option.valueOf((String)"client-implementation")).equals("client-library")) {
            return new SpannerClientLibraryConnectionFactory(config);
        }
        if (this.client == null) {
            this.client = new GrpcClient(config.getCredentials());
        }
        return new SpannerConnectionFactory(this.client, config);
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return DRIVER_NAME.equals(driver);
    }

    public String getDriver() {
        return DRIVER_NAME;
    }

    @VisibleForTesting
    void setClient(Client client) {
        this.client = client;
    }

    @VisibleForTesting
    SpannerConnectionConfiguration createConfiguration(ConnectionFactoryOptions options) {
        SpannerConnectionConfiguration.Builder config = new SpannerConnectionConfiguration.Builder();
        if (options.hasOption(URL)) {
            config.setUrl((String)options.getValue(URL));
        } else if (options.hasOption(ConnectionFactoryOptions.DATABASE) && SpannerConnectionConfiguration.FQDN_PATTERN_PARSE.matcher((CharSequence)options.getValue(ConnectionFactoryOptions.DATABASE)).matches()) {
            config.setFullyQualifiedDatabaseName((String)options.getValue(ConnectionFactoryOptions.DATABASE));
        } else {
            config.setProjectId((String)options.getRequiredValue(PROJECT)).setInstanceName((String)options.getRequiredValue(INSTANCE)).setDatabaseName((String)options.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        }
        config.setCredentials(this.extractCredentials(options));
        if (options.hasOption(PARTIAL_RESULT_SET_FETCH_SIZE)) {
            config.setPartialResultSetFetchSize((Integer)options.getValue(PARTIAL_RESULT_SET_FETCH_SIZE));
        }
        if (options.hasOption(DDL_OPERATION_TIMEOUT)) {
            config.setDdlOperationTimeout((Duration)options.getValue(DDL_OPERATION_TIMEOUT));
        }
        if (options.hasOption(DDL_OPERATION_POLL_INTERVAL)) {
            config.setDdlOperationPollInterval((Duration)options.getValue(DDL_OPERATION_POLL_INTERVAL));
        }
        if (options.hasOption(THREAD_POOL_SIZE)) {
            config.setThreadPoolSize((Integer)options.getValue(THREAD_POOL_SIZE));
        }
        if (options.hasOption(USE_PLAIN_TEXT)) {
            config.setUsePlainText(true);
        }
        if (options.hasOption(OPTIMIZER_VERSION)) {
            config.setOptimizerVersion((String)options.getValue(OPTIMIZER_VERSION));
        }
        return config.build();
    }

    private OAuth2Credentials extractCredentials(ConnectionFactoryOptions options) {
        HashSet<Option> foundSecurityOptions = new HashSet<Option>();
        for (Option option : SECURITY_OPTIONS) {
            if (!options.hasOption(option)) continue;
            foundSecurityOptions.add(option);
        }
        if (foundSecurityOptions.size() > 1) {
            throw new IllegalArgumentException("Please provide at most one authentication option. Found: " + foundSecurityOptions);
        }
        if (options.hasOption(OAUTH_TOKEN)) {
            return this.credentialsHelper.getOauthCredentials((String)options.getValue(OAUTH_TOKEN));
        }
        if (options.hasOption(CREDENTIALS)) {
            return this.credentialsHelper.getFileCredentials((String)options.getValue(CREDENTIALS));
        }
        if (options.hasOption(GOOGLE_CREDENTIALS)) {
            return (OAuth2Credentials)options.getValue(GOOGLE_CREDENTIALS);
        }
        if (options.hasOption(USE_PLAIN_TEXT)) {
            return NoCredentials.getInstance();
        }
        return this.credentialsHelper.getDefaultCredentials();
    }

    @VisibleForTesting
    public void setCredentialsHelper(CredentialsHelper credentialsHelper) {
        this.credentialsHelper = credentialsHelper;
    }
}

