/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.InvocationIdContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingFormatter
extends Formatter {
    private static final String GCS_CONNECTOR_LOGGER_PREFIX = "com.google.cloud.hadoop";
    private final Formatter existingFormatter;

    public LoggingFormatter(Formatter existingFormatter) {
        this.existingFormatter = existingFormatter;
    }

    @Override
    public String format(LogRecord record) {
        String originalMessage = record.getMessage();
        Optional<String> optLoggerName = Optional.ofNullable(record.getLoggerName());
        String invocationId = InvocationIdContext.getInvocationId();
        boolean shouldFormat = optLoggerName.map(name -> name.startsWith(GCS_CONNECTOR_LOGGER_PREFIX)).orElse(false) != false && !invocationId.isEmpty() && !this.isJson(originalMessage);
        String messageToFormat = originalMessage;
        if (shouldFormat) {
            messageToFormat = String.format("[%s]: %s", invocationId, Objects.toString(originalMessage, ""));
        }
        if (this.existingFormatter != null) {
            record.setMessage(messageToFormat);
            return this.existingFormatter.format(record);
        }
        return String.format("%s%n", Objects.toString(messageToFormat, ""));
    }

    public static void addFormatter(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            LoggingFormatter.addFormatterToHandler(handler);
        }
    }

    @VisibleForTesting
    static void addFormatterToHandler(Handler handler) {
        Formatter existingFormatter = handler.getFormatter();
        if (existingFormatter instanceof LoggingFormatter) {
            return;
        }
        handler.setFormatter(new LoggingFormatter(existingFormatter));
    }

    private boolean isJson(String message) {
        if (message == null) {
            return false;
        }
        try {
            JsonElement unused = JsonParser.parseString((String)message);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }
}

