/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.JsonIdempotencyTokenInterceptor;
import com.google.cloud.hadoop.util.RequestTracker;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.util.interceptors.InvocationIdInterceptor;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LogContext;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RetryHttpInitializer
implements HttpRequestInitializer {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final ExponentialBackOff.Builder BACKOFF_BUILDER = new ExponentialBackOff.Builder().setInitialIntervalMillis(1250).setMultiplier(1.6).setRandomizationFactor(0.2).setMaxIntervalMillis(20000).setMaxElapsedTimeMillis(1800000);
    private final HttpCredentialsAdapter credentials;
    private final RetryHttpInitializerOptions options;

    public RetryHttpInitializer(Credentials credentials, RetryHttpInitializerOptions options) {
        this.credentials = credentials == null ? null : new HttpCredentialsAdapter(credentials);
        this.options = options;
    }

    public void initialize(HttpRequest request) throws IOException {
        if (this.credentials != null) {
            this.credentials.initialize(request);
        }
        RequestTracker tracker = this.getRequestTracker(request);
        request.setNumberOfRetries(this.options.getMaxRequestRetries()).setConnectTimeout(Math.toIntExact(this.options.getConnectTimeout().toMillis())).setReadTimeout(Math.toIntExact(this.options.getReadTimeout().toMillis())).setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new UnsuccessfulResponseHandler(this.credentials, tracker)).setIOExceptionHandler((HttpIOExceptionHandler)new IoExceptionHandler(tracker)).setResponseInterceptor(tracker::trackResponse);
        HttpHeaders headers = request.getHeaders();
        if (Strings.isNullOrEmpty((String)headers.getUserAgent()) && !Strings.isNullOrEmpty((String)this.options.getDefaultUserAgent())) {
            ((GoogleLogger.Api)logger.atFiner()).log("Request is missing a user-agent header, adding default value of '%s'", (Object)this.options.getDefaultUserAgent());
            headers.setUserAgent(this.options.getDefaultUserAgent());
        }
        headers.putAll(this.options.getHttpHeaders());
        request.setInterceptor((HttpExecuteInterceptor)new JsonIdempotencyTokenInterceptor(new InvocationIdInterceptor(request.getInterceptor(), tracker)));
    }

    protected RequestTracker getRequestTracker(HttpRequest request) {
        return RequestTracker.create(request);
    }

    public Credentials getCredentials() {
        return this.credentials == null ? null : this.credentials.getCredentials();
    }

    private static class UnsuccessfulResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private static final int HTTP_SC_GONE = 410;
        private static final int HTTP_SC_TOO_MANY_REQUESTS = 429;
        private static final int HTTP_REQUEST_TIMEOUT = 408;
        private static final Set<Integer> RETRYABLE_CODES = ImmutableSet.of((Object)429, (Object)408);
        private static final ImmutableSet<Integer> RESPONSE_CODES_TO_LOG_WITH_RATE_LIMIT = ImmutableSet.of((Object)429);
        private static final ImmutableSet<Integer> RESPONSE_CODES_TO_LOG = ImmutableSet.builder().addAll(RESPONSE_CODES_TO_LOG_WITH_RATE_LIMIT).add((Object[])new Integer[]{410, 503}).build();
        private static final HttpBackOffUnsuccessfulResponseHandler.BackOffRequired BACK_OFF_REQUIRED = response -> RETRYABLE_CODES.contains(response.getStatusCode()) || HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ON_SERVER_ERROR.isRequired(response);
        private final HttpCredentialsAdapter credentials;
        private final HttpBackOffUnsuccessfulResponseHandler delegate;
        private final RequestTracker tracker;

        public UnsuccessfulResponseHandler(HttpCredentialsAdapter credentials, RequestTracker tracker) {
            this.credentials = credentials;
            this.delegate = new HttpBackOffUnsuccessfulResponseHandler((BackOff)BACKOFF_BUILDER.build()).setBackOffRequired(BACK_OFF_REQUIRED);
            this.tracker = tracker;
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            this.logResponseCode(request, response);
            this.tracker.trackUnsuccessfulResponseHandler(response);
            if (this.credentials != null && this.credentials.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            long backOffStartTime = System.currentTimeMillis();
            if (this.delegate.handleResponse(request, response, supportsRetry)) {
                this.tracker.trackBackOffCompleted(backOffStartTime);
                this.tracker.trackRetryStarted();
                return true;
            }
            this.tracker.trackRetrySkipped(true);
            this.escapeRedirectPath(request, response);
            return false;
        }

        private void logResponseCode(HttpRequest request, HttpResponse response) {
            if (RESPONSE_CODES_TO_LOG.contains((Object)response.getStatusCode())) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).with(LogContext.Key.LOG_SITE_GROUPING_KEY, (Object)response.getStatusCode())).atMostEvery(RESPONSE_CODES_TO_LOG_WITH_RATE_LIMIT.contains((Object)response.getStatusCode()) ? 10 : 0, TimeUnit.SECONDS)).log("Encountered status code %d when sending %s request to URL '%s'. Delegating to response handler for possible retry.", (Object)response.getStatusCode(), (Object)request.getRequestMethod(), (Object)request.getUrl());
            }
        }

        private void escapeRedirectPath(HttpRequest request, HttpResponse response) {
            String redirectLocation;
            if (HttpStatusCodes.isRedirect((int)response.getStatusCode()) && request.getFollowRedirects() && response.getHeaders() != null && response.getHeaders().getLocation() != null && (redirectLocation = response.getHeaders().getLocation()).contains("+")) {
                String escapedLocation = redirectLocation.replace("+", "%2B");
                ((GoogleLogger.Api)logger.atFine()).log("Redirect path '%s' contains unescaped '+', replacing with '%%2B': '%s'", (Object)redirectLocation, (Object)escapedLocation);
                response.getHeaders().setLocation(escapedLocation);
            }
        }
    }

    private static class IoExceptionHandler
    implements HttpIOExceptionHandler {
        private final HttpIOExceptionHandler delegate = new HttpBackOffIOExceptionHandler((BackOff)BACKOFF_BUILDER.build());
        private final RequestTracker tracker;

        public IoExceptionHandler(RequestTracker tracker) {
            this.tracker = tracker;
        }

        public boolean handleIOException(HttpRequest httpRequest, boolean supportsRetry) throws IOException {
            ((GoogleLogger.Api)logger.atFine()).log("Encountered an IOException when accessing URL %s", (Object)httpRequest.getUrl());
            this.tracker.trackIOException();
            long backoffStartTime = System.currentTimeMillis();
            boolean result = this.delegate.handleIOException(httpRequest, supportsRetry);
            this.tracker.trackBackOffCompleted(backoffStartTime);
            if (result) {
                this.tracker.trackRetryStarted();
            } else {
                this.tracker.trackRetrySkipped(false);
            }
            return result;
        }
    }
}

