package com.google.cloud.hadoop.util;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RetryHttpInitializerOptions extends RetryHttpInitializerOptions {

  private final String defaultUserAgent;

  private final ImmutableMap<String, String> httpHeaders;

  private final Duration connectTimeout;

  private final Duration readTimeout;

  private final int maxRequestRetries;

  private AutoValue_RetryHttpInitializerOptions(
      @Nullable String defaultUserAgent,
      ImmutableMap<String, String> httpHeaders,
      Duration connectTimeout,
      Duration readTimeout,
      int maxRequestRetries) {
    this.defaultUserAgent = defaultUserAgent;
    this.httpHeaders = httpHeaders;
    this.connectTimeout = connectTimeout;
    this.readTimeout = readTimeout;
    this.maxRequestRetries = maxRequestRetries;
  }

  @Nullable
  @Override
  public String getDefaultUserAgent() {
    return defaultUserAgent;
  }

  @Override
  public ImmutableMap<String, String> getHttpHeaders() {
    return httpHeaders;
  }

  @Override
  public Duration getConnectTimeout() {
    return connectTimeout;
  }

  @Override
  public Duration getReadTimeout() {
    return readTimeout;
  }

  @Override
  public int getMaxRequestRetries() {
    return maxRequestRetries;
  }

  @Override
  public String toString() {
    return "RetryHttpInitializerOptions{"
        + "defaultUserAgent=" + defaultUserAgent + ", "
        + "httpHeaders=" + httpHeaders + ", "
        + "connectTimeout=" + connectTimeout + ", "
        + "readTimeout=" + readTimeout + ", "
        + "maxRequestRetries=" + maxRequestRetries
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RetryHttpInitializerOptions) {
      RetryHttpInitializerOptions that = (RetryHttpInitializerOptions) o;
      return (this.defaultUserAgent == null ? that.getDefaultUserAgent() == null : this.defaultUserAgent.equals(that.getDefaultUserAgent()))
          && this.httpHeaders.equals(that.getHttpHeaders())
          && this.connectTimeout.equals(that.getConnectTimeout())
          && this.readTimeout.equals(that.getReadTimeout())
          && this.maxRequestRetries == that.getMaxRequestRetries();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (defaultUserAgent == null) ? 0 : defaultUserAgent.hashCode();
    h$ *= 1000003;
    h$ ^= httpHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= connectTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= readTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= maxRequestRetries;
    return h$;
  }

  @Override
  public RetryHttpInitializerOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends RetryHttpInitializerOptions.Builder {
    private String defaultUserAgent;
    private ImmutableMap<String, String> httpHeaders;
    private Duration connectTimeout;
    private Duration readTimeout;
    private int maxRequestRetries;
    private byte set$0;
    Builder() {
    }
    private Builder(RetryHttpInitializerOptions source) {
      this.defaultUserAgent = source.getDefaultUserAgent();
      this.httpHeaders = source.getHttpHeaders();
      this.connectTimeout = source.getConnectTimeout();
      this.readTimeout = source.getReadTimeout();
      this.maxRequestRetries = source.getMaxRequestRetries();
      set$0 = (byte) 1;
    }
    @Override
    public RetryHttpInitializerOptions.Builder setDefaultUserAgent(String defaultUserAgent) {
      this.defaultUserAgent = defaultUserAgent;
      return this;
    }
    @Override
    public RetryHttpInitializerOptions.Builder setHttpHeaders(Map<String, String> httpHeaders) {
      this.httpHeaders = ImmutableMap.copyOf(httpHeaders);
      return this;
    }
    @Override
    public RetryHttpInitializerOptions.Builder setConnectTimeout(Duration connectTimeout) {
      if (connectTimeout == null) {
        throw new NullPointerException("Null connectTimeout");
      }
      this.connectTimeout = connectTimeout;
      return this;
    }
    @Override
    public RetryHttpInitializerOptions.Builder setReadTimeout(Duration readTimeout) {
      if (readTimeout == null) {
        throw new NullPointerException("Null readTimeout");
      }
      this.readTimeout = readTimeout;
      return this;
    }
    @Override
    public RetryHttpInitializerOptions.Builder setMaxRequestRetries(int maxRequestRetries) {
      this.maxRequestRetries = maxRequestRetries;
      set$0 |= 1;
      return this;
    }
    @Override
    public RetryHttpInitializerOptions build() {
      if (set$0 != 1
          || this.httpHeaders == null
          || this.connectTimeout == null
          || this.readTimeout == null) {
        StringBuilder missing = new StringBuilder();
        if (this.httpHeaders == null) {
          missing.append(" httpHeaders");
        }
        if (this.connectTimeout == null) {
          missing.append(" connectTimeout");
        }
        if (this.readTimeout == null) {
          missing.append(" readTimeout");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" maxRequestRetries");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RetryHttpInitializerOptions(
          this.defaultUserAgent,
          this.httpHeaders,
          this.connectTimeout,
          this.readTimeout,
          this.maxRequestRetries);
    }
  }

}
