package com.google.cloud.hadoop.util;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AsyncWriteChannelOptions extends AsyncWriteChannelOptions {

  private final int bufferSize;

  private final int pipeBufferSize;

  private final int uploadChunkSize;

  private final int uploadCacheSize;

  private final boolean directUploadEnabled;

  private final boolean grpcChecksumsEnabled;

  private AutoValue_AsyncWriteChannelOptions(
      int bufferSize,
      int pipeBufferSize,
      int uploadChunkSize,
      int uploadCacheSize,
      boolean directUploadEnabled,
      boolean grpcChecksumsEnabled) {
    this.bufferSize = bufferSize;
    this.pipeBufferSize = pipeBufferSize;
    this.uploadChunkSize = uploadChunkSize;
    this.uploadCacheSize = uploadCacheSize;
    this.directUploadEnabled = directUploadEnabled;
    this.grpcChecksumsEnabled = grpcChecksumsEnabled;
  }

  @Override
  public int getBufferSize() {
    return bufferSize;
  }

  @Override
  public int getPipeBufferSize() {
    return pipeBufferSize;
  }

  @Override
  public int getUploadChunkSize() {
    return uploadChunkSize;
  }

  @Override
  public int getUploadCacheSize() {
    return uploadCacheSize;
  }

  @Override
  public boolean isDirectUploadEnabled() {
    return directUploadEnabled;
  }

  @Override
  public boolean isGrpcChecksumsEnabled() {
    return grpcChecksumsEnabled;
  }

  @Override
  public String toString() {
    return "AsyncWriteChannelOptions{"
        + "bufferSize=" + bufferSize + ", "
        + "pipeBufferSize=" + pipeBufferSize + ", "
        + "uploadChunkSize=" + uploadChunkSize + ", "
        + "uploadCacheSize=" + uploadCacheSize + ", "
        + "directUploadEnabled=" + directUploadEnabled + ", "
        + "grpcChecksumsEnabled=" + grpcChecksumsEnabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AsyncWriteChannelOptions) {
      AsyncWriteChannelOptions that = (AsyncWriteChannelOptions) o;
      return this.bufferSize == that.getBufferSize()
          && this.pipeBufferSize == that.getPipeBufferSize()
          && this.uploadChunkSize == that.getUploadChunkSize()
          && this.uploadCacheSize == that.getUploadCacheSize()
          && this.directUploadEnabled == that.isDirectUploadEnabled()
          && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= bufferSize;
    h$ *= 1000003;
    h$ ^= pipeBufferSize;
    h$ *= 1000003;
    h$ ^= uploadChunkSize;
    h$ *= 1000003;
    h$ ^= uploadCacheSize;
    h$ *= 1000003;
    h$ ^= directUploadEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcChecksumsEnabled ? 1231 : 1237;
    return h$;
  }

  @Override
  public AsyncWriteChannelOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AsyncWriteChannelOptions.Builder {
    private Integer bufferSize;
    private Integer pipeBufferSize;
    private Integer uploadChunkSize;
    private Integer uploadCacheSize;
    private Boolean directUploadEnabled;
    private Boolean grpcChecksumsEnabled;
    Builder() {
    }
    private Builder(AsyncWriteChannelOptions source) {
      this.bufferSize = source.getBufferSize();
      this.pipeBufferSize = source.getPipeBufferSize();
      this.uploadChunkSize = source.getUploadChunkSize();
      this.uploadCacheSize = source.getUploadCacheSize();
      this.directUploadEnabled = source.isDirectUploadEnabled();
      this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
    }
    @Override
    public AsyncWriteChannelOptions.Builder setBufferSize(int bufferSize) {
      this.bufferSize = bufferSize;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPipeBufferSize(int pipeBufferSize) {
      this.pipeBufferSize = pipeBufferSize;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setUploadChunkSize(int uploadChunkSize) {
      this.uploadChunkSize = uploadChunkSize;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setUploadCacheSize(int uploadCacheSize) {
      this.uploadCacheSize = uploadCacheSize;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setDirectUploadEnabled(boolean directUploadEnabled) {
      this.directUploadEnabled = directUploadEnabled;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
      this.grpcChecksumsEnabled = grpcChecksumsEnabled;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions build() {
      String missing = "";
      if (this.bufferSize == null) {
        missing += " bufferSize";
      }
      if (this.pipeBufferSize == null) {
        missing += " pipeBufferSize";
      }
      if (this.uploadChunkSize == null) {
        missing += " uploadChunkSize";
      }
      if (this.uploadCacheSize == null) {
        missing += " uploadCacheSize";
      }
      if (this.directUploadEnabled == null) {
        missing += " directUploadEnabled";
      }
      if (this.grpcChecksumsEnabled == null) {
        missing += " grpcChecksumsEnabled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AsyncWriteChannelOptions(
          this.bufferSize,
          this.pipeBufferSize,
          this.uploadChunkSize,
          this.uploadCacheSize,
          this.directUploadEnabled,
          this.grpcChecksumsEnabled);
    }
  }

}
