/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.util.GcsRequestExecutionEvent;
import com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;

@VisibleForTesting
public class GoogleCloudStorageClientGrpcStatisticsInterceptor
implements ClientInterceptor {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                try {
                    GoogleCloudStorageEventBus.onGcsRequest((GcsRequestExecutionEvent)new GcsRequestExecutionEvent());
                }
                catch (Throwable throwable) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            try {
                                GoogleCloudStorageEventBus.onGrpcStatus((Status)status);
                            }
                            finally {
                                super.onClose(status, trailers);
                            }
                        }
                    }, headers);
                    throw throwable;
                }
                super.start((ClientCall.Listener)new /* invalid duplicate definition of identical inner class */, headers);
            }
        };
    }
}

