/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.google.storage.v1.ChecksummedData;
import com.google.google.storage.v1.InsertObjectRequest;
import com.google.google.storage.v1.InsertObjectSpec;
import com.google.google.storage.v1.ObjectChecksums;
import com.google.google.storage.v1.QueryWriteStatusRequest;
import com.google.google.storage.v1.QueryWriteStatusResponse;
import com.google.google.storage.v1.ServiceConstants;
import com.google.google.storage.v1.StartResumableWriteRequest;
import com.google.google.storage.v1.StartResumableWriteResponse;
import com.google.google.storage.v1.StorageGrpc;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.util.Timestamps;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class GoogleCloudStorageGrpcWriteChannel
extends BaseAbstractGoogleAsyncWriteChannel<com.google.google.storage.v1.Object>
implements GoogleCloudStorageItemInfo.Provider {
    static final int GCS_MINIMUM_CHUNK_SIZE = 262144;
    private static final Duration START_RESUMABLE_WRITE_TIMEOUT = Duration.ofMinutes(10L);
    private static final Duration QUERY_WRITE_STATUS_TIMEOUT = Duration.ofMinutes(10L);
    private static final Duration WRITE_STREAM_TIMEOUT = Duration.ofMinutes(20L);
    private static final int UPLOAD_RETRIES = 10;
    private final StorageGrpc.StorageStub stub;
    private final StorageResourceId resourceId;
    private final ObjectWriteConditions writeConditions;
    private final Optional<String> requesterPaysProject;
    private final ImmutableMap<String, String> metadata;
    private final boolean checksumsEnabled;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    GoogleCloudStorageGrpcWriteChannel(ExecutorService threadPool, StorageGrpc.StorageStub stub, StorageResourceId resourceId, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Optional<String> requesterPaysProject, Map<String, String> metadata, String contentType) {
        super(threadPool, options);
        this.stub = stub;
        this.resourceId = resourceId;
        this.writeConditions = writeConditions;
        this.requesterPaysProject = requesterPaysProject;
        this.metadata = ImmutableMap.copyOf(metadata);
        this.contentType = contentType;
        this.checksumsEnabled = options.isGrpcChecksumsEnabled();
    }

    protected String getResourceString() {
        return this.resourceId.toString();
    }

    public void setDirectUploadEnabled(boolean enableDirectUpload) {
    }

    public void setUploadChunkSize(int chunkSize) {
        Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"Upload chunk size must be greater than 0.");
    }

    public void handleResponse(com.google.google.storage.v1.Object response) {
        Preconditions.checkArgument((!response.getBucket().isEmpty() ? 1 : 0) != 0, (String)"Got response from service with empty/missing bucketName: %s", (Object)response);
        Map<String, byte[]> metadata = response.getMetadataMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> BaseEncoding.base64().decode((CharSequence)entry.getValue())));
        byte[] md5Hash = response.getMd5Hash().length() > 0 ? BaseEncoding.base64().decode((CharSequence)response.getMd5Hash()) : null;
        byte[] crc32c = response.hasCrc32C() ? ByteBuffer.allocate(4).putInt(response.getCrc32C().getValue()).array() : null;
        this.completedItemInfo = new GoogleCloudStorageItemInfo(new StorageResourceId(response.getBucket(), response.getName()), Timestamps.toMillis((Timestamp)response.getTimeCreated()), Timestamps.toMillis((Timestamp)response.getUpdated()), response.getSize(), null, null, response.getContentType(), response.getContentEncoding(), metadata, response.getGeneration(), response.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    public void startUpload(PipedInputStream pipeSource) {
        try {
            this.uploadOperation = this.threadPool.submit(new UploadOperation(pipeSource));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to start upload for '%s'", this.resourceId), e);
        }
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }

    private class UploadOperation
    implements Callable<com.google.google.storage.v1.Object> {
        private final BufferedInputStream pipeSource;
        private final int MAX_BYTES_PER_MESSAGE = ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber();

        UploadOperation(PipedInputStream pipeSource) {
            this.pipeSource = new BufferedInputStream(pipeSource, this.MAX_BYTES_PER_MESSAGE);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public com.google.google.storage.v1.Object call() throws IOException, InterruptedException {
            try (BufferedInputStream toClose = this.pipeSource;){
                com.google.google.storage.v1.Object object = this.doResumableUpload();
                return object;
            }
            catch (Exception e) {
                throw new IOException(String.format("Caught exception during upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
        }

        private com.google.google.storage.v1.Object doResumableUpload() throws IOException, InterruptedException {
            InsertChunkResponseObserver responseObserver;
            String uploadId = this.startResumableUpload();
            long writeOffset = 0L;
            int retriesAttempted = 0;
            Hasher objectHasher = Hashing.crc32c().newHasher();
            do {
                responseObserver = new InsertChunkResponseObserver(uploadId, writeOffset, objectHasher);
                ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(WRITE_STREAM_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).insertObject((StreamObserver<com.google.google.storage.v1.Object>)responseObserver);
                responseObserver.done.await();
                if (responseObserver.hasError()) {
                    long committedSize = this.getCommittedWriteSize(uploadId);
                    this.pipeSource.reset();
                    if (committedSize > writeOffset) {
                        int uploadedDataChunkSize = Math.toIntExact(committedSize - writeOffset);
                        this.pipeSource.skip(uploadedDataChunkSize);
                        writeOffset += (long)uploadedDataChunkSize;
                    }
                    ++retriesAttempted;
                } else {
                    writeOffset += (long)responseObserver.bytesWritten();
                    retriesAttempted = 0;
                }
                if (retriesAttempted < 10) continue;
                throw new IOException(String.format("Insert failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), responseObserver.getError());
            } while (!responseObserver.isFinished());
            return responseObserver.getResponse();
        }

        private void runWithRetries(Runnable block, SimpleResponseObserver responseObserver) throws IOException {
            for (int attemptedRetries = 0; attemptedRetries < 10; ++attemptedRetries) {
                block.run();
                if (responseObserver.hasError()) continue;
                return;
            }
            throw new IOException(String.format("Failed to start resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), responseObserver.getError());
        }

        private String startResumableUpload() throws InterruptedException, IOException {
            InsertObjectSpec.Builder insertObjectSpecBuilder = InsertObjectSpec.newBuilder().setResource(com.google.google.storage.v1.Object.newBuilder().setBucket(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getBucketName()).setName(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getObjectName()).setContentType(GoogleCloudStorageGrpcWriteChannel.this.contentType).putAllMetadata((Map<String, String>)GoogleCloudStorageGrpcWriteChannel.this.metadata).build());
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasContentGenerationMatch()) {
                insertObjectSpecBuilder.setIfGenerationMatch(Int64Value.newBuilder().setValue(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getContentGenerationMatch()));
            }
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasMetaGenerationMatch()) {
                insertObjectSpecBuilder.setIfMetagenerationMatch(Int64Value.newBuilder().setValue(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getMetaGenerationMatch()));
            }
            if (GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject.isPresent()) {
                insertObjectSpecBuilder.setUserProject((String)GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject.get());
            }
            StartResumableWriteRequest request = StartResumableWriteRequest.newBuilder().setInsertObjectSpec(insertObjectSpecBuilder).build();
            SimpleResponseObserver responseObserver = new SimpleResponseObserver();
            this.runWithRetries(() -> {
                ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(START_RESUMABLE_WRITE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).startResumableWrite(request, responseObserver);
                try {
                    responseObserver.done.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Failed to start resumable upload.", e);
                }
            }, responseObserver);
            return ((StartResumableWriteResponse)responseObserver.getResponse()).getUploadId();
        }

        private long getCommittedWriteSize(String uploadId) throws InterruptedException, IOException {
            QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
            SimpleResponseObserver responseObserver = new SimpleResponseObserver();
            this.runWithRetries(() -> {
                ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(QUERY_WRITE_STATUS_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).queryWriteStatus(request, responseObserver);
                try {
                    responseObserver.done.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Failed to get committed write size.", e);
                }
            }, responseObserver);
            return ((QueryWriteStatusResponse)responseObserver.getResponse()).getCommittedSize();
        }

        private class SimpleResponseObserver<T>
        implements StreamObserver<T> {
            private T response;
            private Throwable error;
            final CountDownLatch done = new CountDownLatch(1);

            private SimpleResponseObserver() {
            }

            public T getResponse() {
                return (T)Preconditions.checkNotNull(this.response, (String)"Response not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasError() {
                return this.error != null || this.response == null;
            }

            public Throwable getError() {
                return (Throwable)Preconditions.checkNotNull((Object)this.error, (String)"Error not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            public void onNext(T response) {
                this.response = response;
            }

            public void onError(Throwable t) {
                this.error = new IOException(String.format("Caught exception for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), t);
                this.done.countDown();
            }

            public void onCompleted() {
                this.done.countDown();
            }
        }

        private class InsertChunkResponseObserver
        implements ClientResponseObserver<InsertObjectRequest, com.google.google.storage.v1.Object> {
            private final long writeOffset;
            private final String uploadId;
            private volatile boolean objectFinalized = false;
            private Throwable error;
            private com.google.google.storage.v1.Object response;
            private ByteString chunkData;
            private Hasher objectHasher;
            final CountDownLatch done = new CountDownLatch(1);

            InsertChunkResponseObserver(String uploadId, long writeOffset, Hasher objectHasher) {
                this.uploadId = uploadId;
                this.chunkData = ByteString.EMPTY;
                this.writeOffset = writeOffset;
                this.objectHasher = objectHasher;
            }

            public void beforeStart(final ClientCallStreamObserver<InsertObjectRequest> requestObserver) {
                requestObserver.setOnReadyHandler(new Runnable(){

                    @Override
                    public void run() {
                        if (InsertChunkResponseObserver.this.objectFinalized) {
                            return;
                        }
                        try {
                            InsertChunkResponseObserver.this.chunkData = this.readRequestData();
                        }
                        catch (IOException e) {
                            InsertChunkResponseObserver.this.error = new IOException(String.format("Failed to read chunk for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
                            return;
                        }
                        InsertObjectRequest.Builder requestBuilder = InsertObjectRequest.newBuilder().setUploadId(InsertChunkResponseObserver.this.uploadId).setWriteOffset(InsertChunkResponseObserver.this.writeOffset);
                        if (InsertChunkResponseObserver.this.chunkData.size() > 0) {
                            ChecksummedData.Builder requestDataBuilder = ChecksummedData.newBuilder().setContent(InsertChunkResponseObserver.this.chunkData);
                            if (GoogleCloudStorageGrpcWriteChannel.this.checksumsEnabled) {
                                Hasher chunkHasher = Hashing.crc32c().newHasher();
                                for (ByteBuffer buffer : InsertChunkResponseObserver.this.chunkData.asReadOnlyByteBufferList()) {
                                    chunkHasher.putBytes(buffer.duplicate());
                                    InsertChunkResponseObserver.this.objectHasher.putBytes(buffer.duplicate());
                                }
                                requestDataBuilder.setCrc32C(UInt32Value.newBuilder().setValue(chunkHasher.hash().asInt()));
                            }
                            requestBuilder.setChecksummedData(requestDataBuilder);
                        }
                        if (InsertChunkResponseObserver.this.objectFinalized) {
                            requestBuilder.setFinishWrite(true);
                            if (GoogleCloudStorageGrpcWriteChannel.this.checksumsEnabled) {
                                requestBuilder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(UInt32Value.newBuilder().setValue(InsertChunkResponseObserver.this.objectHasher.hash().asInt())));
                            }
                        }
                        requestObserver.onNext((Object)requestBuilder.build());
                        if (InsertChunkResponseObserver.this.objectFinalized) {
                            requestObserver.onCompleted();
                        }
                    }

                    private ByteString readRequestData() throws IOException {
                        UploadOperation.this.pipeSource.mark(UploadOperation.this.MAX_BYTES_PER_MESSAGE);
                        ByteString data = ByteString.readFrom((InputStream)ByteStreams.limit((InputStream)UploadOperation.this.pipeSource, (long)UploadOperation.this.MAX_BYTES_PER_MESSAGE));
                        InsertChunkResponseObserver.this.objectFinalized = data.size() < UploadOperation.this.MAX_BYTES_PER_MESSAGE || UploadOperation.this.pipeSource.available() > 0;
                        return data;
                    }
                });
            }

            public com.google.google.storage.v1.Object getResponse() {
                return (com.google.google.storage.v1.Object)Preconditions.checkNotNull((Object)this.response, (String)"Response not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasError() {
                return this.error != null || this.response == null;
            }

            int bytesWritten() {
                return this.chunkData.size();
            }

            public Throwable getError() {
                return (Throwable)Preconditions.checkNotNull((Object)this.error, (String)"Error not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean isFinished() {
                return this.objectFinalized || this.hasError();
            }

            public void onNext(com.google.google.storage.v1.Object response) {
                this.response = response;
            }

            public void onError(Throwable t) {
                this.error = new IOException(String.format("Caught exception for '%s', while uploading to uploadId %s at writeOffset %d", GoogleCloudStorageGrpcWriteChannel.this.resourceId, this.uploadId, this.writeOffset), t);
                this.done.countDown();
            }

            public void onCompleted() {
                this.done.countDown();
            }
        }
    }
}

