/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.EclipseHack;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.SimpleMethod;
import com.google.auto.value.processor.TypeEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class PropertyBuilderClassifier {
    private final ErrorReporter errorReporter;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final BuilderMethodClassifier builderMethodClassifier;
    private final $ImmutableBiMap<ExecutableElement, String> getterToPropertyName;
    private final EclipseHack eclipseHack;
    private static final String COM_GOOGLE_COMMON_COLLECT_IMMUTABLE = "com".concat(".google.common.collect.Immutable");
    private static final $ImmutableSet<String> BUILDER_METHOD_NAMES = $ImmutableSet.of("naturalOrder", "builder", "newBuilder");

    PropertyBuilderClassifier(ErrorReporter errorReporter, Types typeUtils, Elements elementUtils, BuilderMethodClassifier builderMethodClassifier, $ImmutableBiMap<ExecutableElement, String> getterToPropertyName, EclipseHack eclipseHack) {
        this.errorReporter = errorReporter;
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.builderMethodClassifier = builderMethodClassifier;
        this.getterToPropertyName = getterToPropertyName;
        this.eclipseHack = eclipseHack;
    }

    Optional<PropertyBuilder> makePropertyBuilder(ExecutableElement method, String property) {
        String initDefault;
        String beforeInitDefault;
        boolean hasOf;
        TypeMirror barBuilderTypeMirror = this.builderMethodClassifier.builderMethodReturnType(method);
        if (barBuilderTypeMirror.getKind() != TypeKind.DECLARED) {
            this.errorReporter.reportError("Method looks like a property builder, but its return type is not a class or interface", method);
            return Optional.empty();
        }
        DeclaredType barBuilderDeclaredType = $MoreTypes.asDeclared(barBuilderTypeMirror);
        TypeElement barBuilderTypeElement = $MoreTypes.asTypeElement(barBuilderTypeMirror);
        Map<String, ExecutableElement> barBuilderNoArgMethods = this.noArgMethodsOf(barBuilderTypeElement);
        ExecutableElement barGetter = (ExecutableElement)(($ImmutableMap)((Object)this.getterToPropertyName.inverse())).get(property);
        TypeMirror barTypeMirror = barGetter.getReturnType();
        if (barTypeMirror.getKind() != TypeKind.DECLARED) {
            this.errorReporter.reportError("Method looks like a property builder, but the type of property " + property + " is not a class or interface", method);
            return Optional.empty();
        }
        if (PropertyBuilderClassifier.isNullable(barGetter)) {
            this.errorReporter.reportError("Property " + property + " has a property builder so it cannot be @Nullable", barGetter);
        }
        TypeElement barTypeElement = $MoreTypes.asTypeElement(barTypeMirror);
        Map<String, ExecutableElement> barNoArgMethods = this.noArgMethodsOf(barTypeElement);
        ExecutableElement build = barBuilderNoArgMethods.get("build");
        if (build == null || build.getModifiers().contains((Object)Modifier.STATIC)) {
            this.errorReporter.reportError("Method looks like a property builder, but it returns " + barBuilderTypeElement + " which does not have a non-static build() method", method);
            return Optional.empty();
        }
        TypeMirror buildType = this.eclipseHack.methodReturnType(build, barBuilderDeclaredType);
        if (!$MoreTypes.equivalence().equivalent(barTypeMirror, buildType)) {
            this.errorReporter.reportError("Property builder for " + property + " has type " + barBuilderTypeElement + " whose build() method returns " + buildType + " instead of " + barTypeMirror, method);
            return Optional.empty();
        }
        Optional<ExecutableElement> maybeBuilderMaker = this.builderMaker(barNoArgMethods, barBuilderTypeElement);
        if (!maybeBuilderMaker.isPresent()) {
            this.errorReporter.reportError("Method looks like a property builder, but its type " + barBuilderTypeElement + " does not have a public constructor and " + barTypeElement + " does not have a static builder() or newBuilder() method that returns " + barBuilderTypeElement, method);
            return Optional.empty();
        }
        ExecutableElement builderMaker = maybeBuilderMaker.get();
        String barBuilderType = TypeEncoder.encodeWithAnnotations(barBuilderTypeMirror);
        String rawBarType = TypeEncoder.encodeRaw(barTypeMirror);
        String initializer = builderMaker.getKind() == ElementKind.CONSTRUCTOR ? "new " + barBuilderType + "()" : rawBarType + "." + builderMaker.getSimpleName() + "()";
        String builtToBuilder = null;
        String copyAll = null;
        ExecutableElement toBuilder = barNoArgMethods.get("toBuilder");
        if (toBuilder != null && !toBuilder.getModifiers().contains((Object)Modifier.STATIC) && this.typeUtils.isAssignable(this.typeUtils.erasure(toBuilder.getReturnType()), this.typeUtils.erasure(barBuilderTypeMirror))) {
            builtToBuilder = toBuilder.getSimpleName().toString();
        } else {
            boolean isGuavaBuilder = barBuilderTypeMirror.toString().startsWith(COM_GOOGLE_COMMON_COLLECT_IMMUTABLE) && barBuilderTypeMirror.toString().contains(".Builder<");
            Optional<ExecutableElement> maybeCopyAll = this.addAllPutAll(barBuilderTypeElement);
            if (maybeCopyAll.isPresent() && isGuavaBuilder) {
                copyAll = maybeCopyAll.get().getSimpleName().toString();
            }
        }
        ExecutableElement barOf = barNoArgMethods.get("of");
        boolean bl = hasOf = barOf != null && barOf.getModifiers().contains((Object)Modifier.STATIC);
        if (hasOf) {
            beforeInitDefault = "";
            initDefault = rawBarType + ".of()";
        } else {
            String localBuilder = property + "$builder";
            beforeInitDefault = barBuilderType + " " + localBuilder + " = " + initializer + ";";
            initDefault = localBuilder + ".build()";
        }
        PropertyBuilder propertyBuilder = new PropertyBuilder(method, barBuilderType, barBuilderTypeMirror, initializer, beforeInitDefault, initDefault, builtToBuilder, copyAll);
        return Optional.of(propertyBuilder);
    }

    private Optional<ExecutableElement> builderMaker(Map<String, ExecutableElement> barNoArgMethods, TypeElement barBuilderTypeElement) {
        for (String builderMethodName : BUILDER_METHOD_NAMES) {
            ExecutableElement method = barNoArgMethods.get(builderMethodName);
            if (method == null || !method.getModifiers().contains((Object)Modifier.STATIC) || !this.typeUtils.isSameType(this.typeUtils.erasure(method.getReturnType()), this.typeUtils.erasure(barBuilderTypeElement.asType()))) continue;
            return Optional.of(method);
        }
        return ElementFilter.constructorsIn(barBuilderTypeElement.getEnclosedElements()).stream().filter(c -> c.getParameters().isEmpty()).filter(c -> c.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst();
    }

    private Map<String, ExecutableElement> noArgMethodsOf(TypeElement type) {
        LinkedHashMap<String, ExecutableElement> methods = new LinkedHashMap<String, ExecutableElement>();
        for (ExecutableElement method : ElementFilter.methodsIn(this.elementUtils.getAllMembers(type))) {
            if (!method.getParameters().isEmpty() || PropertyBuilderClassifier.isStaticInterfaceMethodNotIn(method, type)) continue;
            methods.put(method.getSimpleName().toString(), method);
        }
        return methods;
    }

    private static boolean isStaticInterfaceMethodNotIn(ExecutableElement method, TypeElement type) {
        return method.getModifiers().contains((Object)Modifier.STATIC) && !method.getEnclosingElement().equals(type) && method.getEnclosingElement().getKind().equals((Object)ElementKind.INTERFACE);
    }

    private Optional<ExecutableElement> addAllPutAll(TypeElement barBuilderTypeElement) {
        for (ExecutableElement method : $MoreElements.getLocalAndInheritedMethods(barBuilderTypeElement, this.typeUtils, this.elementUtils)) {
            Name name = method.getSimpleName();
            if (!name.contentEquals("addAll") && !name.contentEquals("putAll")) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private static boolean isNullable(ExecutableElement getter) {
        $ImmutableList<List<? extends AnnotationMirror>> annotationLists = $ImmutableList.of(getter.getAnnotationMirrors(), getter.getReturnType().getAnnotationMirrors());
        for (List list : annotationLists) {
            for (AnnotationMirror annotation : list) {
                if (!annotation.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
                return true;
            }
        }
        return false;
    }

    public static class PropertyBuilder {
        private final ExecutableElement propertyBuilderMethod;
        private final String name;
        private final String builderType;
        private final TypeMirror builderTypeMirror;
        private final String initializer;
        private final String beforeInitDefault;
        private final String initDefault;
        private final String builtToBuilder;
        private final String copyAll;

        PropertyBuilder(ExecutableElement propertyBuilderMethod, String builderType, TypeMirror builderTypeMirror, String initializer, String beforeInitDefault, String initDefault, String builtToBuilder, String copyAll) {
            this.propertyBuilderMethod = propertyBuilderMethod;
            this.name = propertyBuilderMethod.getSimpleName() + "$";
            this.builderType = builderType;
            this.builderTypeMirror = builderTypeMirror;
            this.initializer = initializer;
            this.beforeInitDefault = beforeInitDefault;
            this.initDefault = initDefault;
            this.builtToBuilder = builtToBuilder;
            this.copyAll = copyAll;
        }

        public ExecutableElement getPropertyBuilderMethod() {
            return this.propertyBuilderMethod;
        }

        public String getAccess() {
            return SimpleMethod.access(this.propertyBuilderMethod);
        }

        public String getName() {
            return this.name;
        }

        public String getBuilderType() {
            return this.builderType;
        }

        TypeMirror getBuilderTypeMirror() {
            return this.builderTypeMirror;
        }

        public String getInitializer() {
            return this.initializer;
        }

        public String getBeforeInitDefault() {
            return this.beforeInitDefault;
        }

        public String getInitDefault() {
            return this.initDefault;
        }

        public String getBuiltToBuilder() {
            return this.builtToBuilder;
        }

        public String getCopyAll() {
            return this.copyAll;
        }
    }
}

