/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.AnnotationMirrors;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.base.Throwables;
import autovalue.shaded.com.google.common.collect.ImmutableCollection;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.google.auto.value.processor.ClassNames;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.Executable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class KotlinMetadata {
    private final ErrorReporter errorReporter;
    private boolean warnedAboutMissingMetadataApi;
    private static final Constructor<?> NEW_KOTLIN_CLASS_HEADER;
    private static final Method KOTLIN_CLASS_METADATA_READ_LENIENT;
    private static final Method KOTLIN_CLASS_METADATA_CLASS_GET_KM_CLASS;
    private static final Method KM_CLASS_GET_CONSTRUCTORS;
    private static final Method KM_CONSTRUCTOR_GET_VALUE_PARAMETERS;
    private static final Method KM_VALUE_PARAMETER_GET_NAME;
    private static final Method ATTRIBUTES_GET_DECLARES_DEFAULT_VALUE;
    private static final boolean KOTLIN_METADATA_AVAILABLE;

    KotlinMetadata(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    ImmutableList<Executable> kotlinConstructorsIn(AnnotationMirror metadata, TypeElement ofClass) {
        if (!KOTLIN_METADATA_AVAILABLE) {
            if (!this.warnedAboutMissingMetadataApi) {
                this.warnedAboutMissingMetadataApi = true;
                this.errorReporter.reportWarning(ofClass, "[AutoBuilderNoMetadataApi] The Kotlin metadata API (kotlinx.metadata or kotlin.metadata) is not available. You may need to add a dependency on org.jetbrains.kotlin:kotlin-metadata-jvm.", new Object[0]);
            }
            return ImmutableList.of();
        }
        try {
            return KotlinMetadata.kotlinConstructorsFromReflection(metadata, ofClass);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked(e.getCause());
            throw new LinkageError(e.getMessage(), e);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static ImmutableList<Executable> kotlinConstructorsFromReflection(AnnotationMirror metadata, TypeElement ofClass) throws ReflectiveOperationException {
        ImmutableMap<String, AnnotationValue> annotationValues = AnnotationMirrors.getAnnotationValuesWithDefaults(metadata).entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString(), e -> (AnnotationValue)e.getValue()));
        Map map = ElementFilter.constructorsIn(ofClass.getEnclosedElements()).stream().collect(Collectors.toMap(c -> KotlinMetadata.parameterNames(c), c -> c, (a, b) -> a, LinkedHashMap::new));
        ImmutableMap paramNamesToConstructor = ImmutableMap.copyOf(map);
        KotlinClassHeader header = new KotlinClassHeader((Integer)annotationValues.get("k").getValue(), KotlinMetadata.intArrayValue(annotationValues.get("mv")), KotlinMetadata.stringArrayValue(annotationValues.get("d1")), KotlinMetadata.stringArrayValue(annotationValues.get("d2")), (String)annotationValues.get("xs").getValue(), (String)annotationValues.get("pn").getValue(), (Integer)annotationValues.get("xi").getValue());
        KotlinClassMetadata.Class classMetadata = KotlinClassMetadata.readLenient(header);
        KmClass kmClass = classMetadata.getKmClass();
        ImmutableList.Builder kotlinConstructorsBuilder = ImmutableList.builder();
        for (KmConstructor constructor : kmClass.getConstructors()) {
            ImmutableSet.Builder allBuilder = ImmutableSet.builder();
            ImmutableSet.Builder optionalBuilder = ImmutableSet.builder();
            for (KmValueParameter param : constructor.getValueParameters()) {
                String name = param.getName();
                allBuilder.add(name);
                if (!Attributes.getDeclaresDefaultValue(param)) continue;
                optionalBuilder.add(name);
            }
            ImmutableCollection optional = optionalBuilder.build();
            ImmutableCollection all = allBuilder.build();
            ExecutableElement javaConstructor = (ExecutableElement)paramNamesToConstructor.get(all);
            if (javaConstructor == null) continue;
            kotlinConstructorsBuilder.add(Executable.of(javaConstructor, (ImmutableSet<String>)optional));
        }
        return kotlinConstructorsBuilder.build();
    }

    private static ImmutableSet<String> parameterNames(ExecutableElement executableElement) {
        return executableElement.getParameters().stream().map(v -> v.getSimpleName().toString()).collect(ImmutableSet.toImmutableSet());
    }

    Optional<AnnotationMirror> kotlinMetadataAnnotation(Element element) {
        return element.getAnnotationMirrors().stream().filter(a -> MoreTypes.asTypeElement(a.getAnnotationType()).getQualifiedName().contentEquals(ClassNames.KOTLIN_METADATA_NAME)).map(a -> a).findFirst();
    }

    private static int[] intArrayValue(AnnotationValue value) {
        List list = (List)value.getValue();
        return list.stream().mapToInt(v -> (Integer)v.getValue()).toArray();
    }

    private static String[] stringArrayValue(AnnotationValue value) {
        List list = (List)value.getValue();
        return (String[])list.stream().map(AnnotationValue::getValue).toArray(String[]::new);
    }

    static {
        Constructor<?> newKotlinClassHeader = null;
        Method kotlinClassMetadataReadLenient = null;
        Method kotlinClassMetadataClassGetKmClass = null;
        Method kmClassGetConstructors = null;
        Method kmConstructorGetValueParameters = null;
        Method kmValueParameterGetName = null;
        Method attributeGetDeclaresDefaultValue = null;
        boolean kotlinMetadataAvailable = false;
        for (String prefix : new String[]{"kotlin.metadata.", "kotlinx.metadata."}) {
            try {
                Class<?> kotlinClassHeaderClass = Class.forName(prefix + "jvm.KotlinClassHeader");
                newKotlinClassHeader = kotlinClassHeaderClass.getConstructor(Integer.class, int[].class, String[].class, String[].class, String.class, String.class, Integer.class);
                Class<?> kotlinClassMetadataClass = Class.forName(prefix + "jvm.KotlinClassMetadata");
                Class<?> kotlinMetadataClass = Class.forName("kotlin.Metadata", false, kotlinClassHeaderClass.getClassLoader());
                kotlinClassMetadataReadLenient = kotlinClassMetadataClass.getMethod("readLenient", kotlinMetadataClass);
                Class<?> kotlinClassMetadataClassClass = Class.forName(prefix + "jvm.KotlinClassMetadata$Class");
                Class<?> kmClassClass = Class.forName(prefix + "KmClass");
                kotlinClassMetadataClassGetKmClass = kotlinClassMetadataClassClass.getMethod("getKmClass", new Class[0]);
                kmClassGetConstructors = kmClassClass.getMethod("getConstructors", new Class[0]);
                Class<?> kmConstructorClass = Class.forName(prefix + "KmConstructor");
                kmConstructorGetValueParameters = kmConstructorClass.getMethod("getValueParameters", new Class[0]);
                Class<?> kmValueParameterClass = Class.forName(prefix + "KmValueParameter");
                kmValueParameterGetName = kmValueParameterClass.getMethod("getName", new Class[0]);
                Class<?> attributeClass = Class.forName(prefix + "Attributes");
                attributeGetDeclaresDefaultValue = attributeClass.getMethod("getDeclaresDefaultValue", kmValueParameterClass);
                kotlinMetadataAvailable = true;
                break;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        NEW_KOTLIN_CLASS_HEADER = newKotlinClassHeader;
        KOTLIN_CLASS_METADATA_READ_LENIENT = kotlinClassMetadataReadLenient;
        KOTLIN_CLASS_METADATA_CLASS_GET_KM_CLASS = kotlinClassMetadataClassGetKmClass;
        KM_CLASS_GET_CONSTRUCTORS = kmClassGetConstructors;
        KM_CONSTRUCTOR_GET_VALUE_PARAMETERS = kmConstructorGetValueParameters;
        KM_VALUE_PARAMETER_GET_NAME = kmValueParameterGetName;
        ATTRIBUTES_GET_DECLARES_DEFAULT_VALUE = attributeGetDeclaresDefaultValue;
        KOTLIN_METADATA_AVAILABLE = kotlinMetadataAvailable;
    }

    private static class Attributes {
        private Attributes() {
        }

        static boolean getDeclaresDefaultValue(KmValueParameter kmValueParameter) throws ReflectiveOperationException {
            return (Boolean)ATTRIBUTES_GET_DECLARES_DEFAULT_VALUE.invoke(null, kmValueParameter.wrapped);
        }
    }

    private static class KmValueParameter {
        final Object wrapped;

        KmValueParameter(Object wrapped) {
            this.wrapped = wrapped;
        }

        String getName() throws ReflectiveOperationException {
            return (String)KM_VALUE_PARAMETER_GET_NAME.invoke(this.wrapped, new Object[0]);
        }
    }

    private static class KmConstructor {
        final Object wrapped;

        KmConstructor(Object wrapped) {
            this.wrapped = wrapped;
        }

        List<KmValueParameter> getValueParameters() throws ReflectiveOperationException {
            return ((List)KM_CONSTRUCTOR_GET_VALUE_PARAMETERS.invoke(this.wrapped, new Object[0])).stream().map(KmValueParameter::new).collect(ImmutableList.toImmutableList());
        }
    }

    private static class KmClass {
        final Object wrapped;

        KmClass(Object wrapped) {
            this.wrapped = wrapped;
        }

        List<KmConstructor> getConstructors() throws ReflectiveOperationException {
            return ((List)KM_CLASS_GET_CONSTRUCTORS.invoke(this.wrapped, new Object[0])).stream().map(KmConstructor::new).collect(ImmutableList.toImmutableList());
        }
    }

    private static class KotlinClassMetadata {
        private KotlinClassMetadata() {
        }

        static Class readLenient(KotlinClassHeader kotlinClassHeader) throws ReflectiveOperationException {
            return new Class(KOTLIN_CLASS_METADATA_READ_LENIENT.invoke(null, kotlinClassHeader.wrapped));
        }

        static class Class {
            final Object wrapped;

            Class(Object wrapped) {
                this.wrapped = wrapped;
            }

            KmClass getKmClass() throws ReflectiveOperationException {
                return new KmClass(KOTLIN_CLASS_METADATA_CLASS_GET_KM_CLASS.invoke(this.wrapped, new Object[0]));
            }
        }
    }

    private static class KotlinClassHeader {
        final Object wrapped;

        KotlinClassHeader(Integer k, int[] mv, String[] d1, String[] d2, String xs, String pn, Integer xi) throws ReflectiveOperationException {
            this.wrapped = NEW_KOTLIN_CLASS_HEADER.newInstance(k, mv, d1, d2, xs, pn, xi);
        }
    }
}

