/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class UserCredentials
extends GoogleCredentials {
    private static final String GRANT_TYPE = "refresh_token";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final long serialVersionUID = -4800758775038679176L;
    private final String clientId;
    private final String clientSecret;
    private final String refreshToken;
    private final URI tokenServerUri;
    private final String transportFactoryClassName;
    private transient HttpTransportFactory transportFactory;

    public UserCredentials(String clientId, String clientSecret, String refreshToken) {
        this(clientId, clientSecret, refreshToken, null, null, null);
    }

    public UserCredentials(String clientId, String clientSecret, String refreshToken, AccessToken accessToken) {
        this(clientId, clientSecret, refreshToken, accessToken, null, null);
    }

    public UserCredentials(String clientId, String clientSecret, String refreshToken, AccessToken accessToken, HttpTransportFactory transportFactory, URI tokenServerUri) {
        super(accessToken);
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId);
        this.clientSecret = (String)Preconditions.checkNotNull((Object)clientSecret);
        this.refreshToken = refreshToken;
        this.transportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)transportFactory, (Object)UserCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.tokenServerUri = tokenServerUri == null ? OAuth2Utils.TOKEN_SERVER_URI : tokenServerUri;
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        Preconditions.checkState((accessToken != null || refreshToken != null ? 1 : 0) != 0, (Object)"Either accessToken or refreshToken must not be null");
    }

    static UserCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientSecret = (String)json.get("client_secret");
        String refreshToken = (String)json.get(GRANT_TYPE);
        if (clientId == null || clientSecret == null || refreshToken == null) {
            throw new IOException("Error reading user credential from JSON,  expecting 'client_id', 'client_secret' and 'refresh_token'.");
        }
        return new UserCredentials(clientId, clientSecret, refreshToken, null, transportFactory, null);
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        if (this.refreshToken == null) {
            throw new IllegalStateException("UserCredentials instance cannot refresh because there is no refresh token.");
        }
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("client_id", (Object)this.clientId);
        tokenRequest.set("client_secret", (Object)this.clientSecret);
        tokenRequest.set(GRANT_TYPE, (Object)this.refreshToken);
        tokenRequest.set("grant_type", (Object)GRANT_TYPE);
        UrlEncodedContent content = new UrlEncodedContent((Object)tokenRequest);
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), (HttpContent)content);
        request.setParser((ObjectParser)new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        HttpResponse response = request.execute();
        GenericData responseData = (GenericData)response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString((Map<String, Object>)responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32((Map<String, Object>)responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)(expiresInSeconds * 1000);
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientSecret() {
        return this.clientSecret;
    }

    public final String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientId, this.clientSecret, this.refreshToken, this.tokenServerUri, this.transportFactoryClassName);
    }

    @Override
    public String toString() {
        return this.toStringHelper().add("clientId", (Object)this.clientId).add("refreshToken", (Object)this.refreshToken).add("tokenServerUri", (Object)this.tokenServerUri).add("transportFactoryClassName", (Object)this.transportFactoryClassName).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UserCredentials)) {
            return false;
        }
        UserCredentials other = (UserCredentials)((Object)obj);
        return super.equals((Object)other) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.refreshToken, other.refreshToken) && Objects.equals(this.tokenServerUri, other.tokenServerUri) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)UserCredentials.newInstance(this.transportFactoryClassName);
    }
}

