/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.Preconditions;
import com.google.auth.Credentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCredentialsAdapter
implements HttpRequestInitializer {
    private final Credentials credentials;

    public HttpCredentialsAdapter(Credentials credentials) {
        Preconditions.checkNotNull((Object)credentials);
        this.credentials = credentials;
    }

    public void initialize(HttpRequest request) throws IOException {
        if (!this.credentials.hasRequestMetadata()) {
            return;
        }
        HttpHeaders requestHeaders = request.getHeaders();
        Map credentialHeaders = this.credentials.getRequestMetadata();
        if (credentialHeaders == null) {
            return;
        }
        for (Map.Entry entry : credentialHeaders.entrySet()) {
            String headerName = (String)entry.getKey();
            List<String> requestValues = this.getHeadersValue(requestHeaders, headerName);
            if (requestValues == null) {
                requestValues = new ArrayList<String>();
                requestHeaders.put(headerName, requestValues);
            }
            List credentialValues = (List)entry.getValue();
            for (String credentialValue : credentialValues) {
                requestValues.add(credentialValue);
            }
        }
    }

    private List<String> getHeadersValue(HttpHeaders headers, String headerName) {
        return (List)headers.get((Object)headerName);
    }
}

