/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.protocol;

import com.google.io.protocol.ProtocolSupport;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class Protocol {
    public static final int NUMERIC = 0;
    public static final int DOUBLE = 1;
    public static final int STRING = 2;
    public static final int STARTGROUP = 3;
    public static final int ENDGROUP = 4;
    public static final int FLOAT = 5;
    public static final int MAX_TYPE = 6;
    public static final int MAX_VARINT_SIZE = 5;
    public static final int MAX_VARLONG_SIZE = 10;

    public static int getTagFormat(int tag_word) {
        return tag_word & 7;
    }

    public static int getTag(int tag_word) {
        return tag_word >>> 3;
    }

    public static int makeTagWord(int tag, int tag_format) {
        assert ((tag_format & 7) == tag_format);
        return tag << 3 | tag_format;
    }

    public static int endTag(int tag) {
        return Protocol.makeTagWord(tag, 4);
    }

    public static boolean getBoolean(ByteBuffer source) {
        return Protocol.getVarInt(source) != 0;
    }

    public static void putBoolean(boolean v, ByteBuffer sink) {
        sink.put((byte)(v ? 1 : 0));
    }

    public static int varIntSize(int v) {
        int result = 0;
        do {
            ++result;
        } while ((v >>>= 7) != 0);
        return result;
    }

    public static int getVarInt(ByteBuffer source) {
        byte tmp = source.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = source.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = source.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = source.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = source.get();
                    result |= tmp << 28;
                    while (tmp < 0) {
                        tmp = source.get();
                    }
                }
            }
        }
        return result;
    }

    public static void putVarInt(int v, ByteBuffer sink) {
        while (true) {
            int bits = v & 0x7F;
            if ((v >>>= 7) == 0) {
                sink.put((byte)bits);
                return;
            }
            sink.put((byte)(bits | 0x80));
        }
    }

    public static int varLongSize(long v) {
        int result = 0;
        do {
            ++result;
        } while ((v >>>= 7) != 0L);
        return result;
    }

    public static long getVarLong(ByteBuffer source) {
        long tmp = source.get();
        if (tmp >= 0L) {
            return tmp;
        }
        long result = tmp & 0x7FL;
        tmp = source.get();
        if (tmp >= 0L) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7FL) << 7;
            tmp = source.get();
            if (tmp >= 0L) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7FL) << 14;
                tmp = source.get();
                if (tmp >= 0L) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7FL) << 21;
                    tmp = source.get();
                    if (tmp >= 0L) {
                        result |= tmp << 28;
                    } else {
                        result |= (tmp & 0x7FL) << 28;
                        tmp = source.get();
                        if (tmp >= 0L) {
                            result |= tmp << 35;
                        } else {
                            result |= (tmp & 0x7FL) << 35;
                            tmp = source.get();
                            if (tmp >= 0L) {
                                result |= tmp << 42;
                            } else {
                                result |= (tmp & 0x7FL) << 42;
                                tmp = source.get();
                                if (tmp >= 0L) {
                                    result |= tmp << 49;
                                } else {
                                    result |= (tmp & 0x7FL) << 49;
                                    tmp = source.get();
                                    if (tmp >= 0L) {
                                        result |= tmp << 56;
                                    } else {
                                        result |= (tmp & 0x7FL) << 56;
                                        result |= (long)source.get() << 63;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public static void putVarLong(long v, ByteBuffer sink) {
        while (true) {
            int bits = (int)v & 0x7F;
            if ((v >>>= 7) == 0L) {
                sink.put((byte)bits);
                return;
            }
            sink.put((byte)(bits | 0x80));
        }
    }

    public static int stringSize(int len) {
        return Protocol.varIntSize(len) + len;
    }

    public static byte[] getPrefixedData(ByteBuffer source) {
        int len = Protocol.getVarInt(source);
        byte[] b = new byte[len];
        source.get(b, 0, len);
        return b;
    }

    public static void putPrefixedData(byte[] v, ByteBuffer sink) {
        Protocol.putVarInt(v.length, sink);
        sink.put(v, 0, v.length);
    }

    public static void skipData(ByteBuffer source, int tagWord) {
        switch (Protocol.getTagFormat(tagWord)) {
            case 0: {
                Protocol.getVarLong(source);
                break;
            }
            case 5: {
                source.getFloat();
                break;
            }
            case 1: {
                source.getDouble();
                break;
            }
            case 2: {
                int len = Protocol.getVarInt(source);
                source.position(source.position() + len);
                break;
            }
            case 3: {
                int nextTagWord;
                int endWord = Protocol.endTag(Protocol.getTag(tagWord));
                while ((nextTagWord = Protocol.getVarInt(source)) != endWord) {
                    Protocol.skipData(source, nextTagWord);
                }
                break;
            }
            case 4: {
                throw new IllegalArgumentException("unexpected ENDGROUP " + tagWord);
            }
            default: {
                throw new IllegalArgumentException("unexpected type code in " + tagWord);
            }
        }
    }

    public static void putString(String v, ByteBuffer sink) {
        byte[] utf8Bytes = v.getBytes(StandardCharsets.UTF_8);
        sink.put(utf8Bytes, 0, utf8Bytes.length);
    }

    public static byte[] toBytesUtf8(String str) {
        return ProtocolSupport.toBytesUtf8(str);
    }

    public static String toString(byte[] data, Charset charset) {
        return ProtocolSupport.toString(data, charset);
    }

    public static String toStringUtf8(byte[] data) {
        return ProtocolSupport.toStringUtf8(data);
    }

    private Protocol() {
    }
}

