/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;

public class YamlUtils {
    static final Pattern TRUE_PATTERN = Pattern.compile("y|Y|yes|Yes|YES|true|True|TRUE|on|On|ON");
    static final Pattern FALSE_PATTERN = Pattern.compile("n|N|no|No|NO|false|False|FALSE|off|Off|OFF");
    private static final String RESERVED_URL = "The URL '%s' is reserved and cannot be used.";
    private static final ImmutableMap<Class<?>, Function<String, Object>> SIMPLE_DECODERS = ImmutableMap.of(Integer.class, Integer::decode, Integer.TYPE, Integer::decode, Double.class, Double::parseDouble, Double.TYPE, Double::parseDouble, Boolean.class, YamlUtils::parseBoolean, Boolean.TYPE, YamlUtils::parseBoolean, String.class, x -> x);

    private YamlUtils() {
    }

    static boolean parseBoolean(String value) {
        if (TRUE_PATTERN.matcher(value).matches()) {
            return true;
        }
        if (FALSE_PATTERN.matcher(value).matches()) {
            return false;
        }
        throw new AppEngineConfigException("Invalid boolean value '" + value + "'.");
    }

    static void validateUrl(String url) {
        if (url.equals("/form")) {
            throw new AppEngineConfigException(String.format(RESERVED_URL, url));
        }
    }

    static <T> T parse(Reader reader, Class<T> targetClass) throws YamlException {
        YamlReader yamlReader = new YamlReader(reader);
        Map map = (Map)yamlReader.read(Map.class);
        if (map == null) {
            return null;
        }
        try {
            return targetClass.cast(YamlUtils.decode(map, targetClass));
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new YamlException(e.getMessage(), (Throwable)e);
        }
    }

    private static Object decode(Object encoded, Type targetType) throws YamlException {
        if (targetType instanceof Class) {
            Class targetClass = (Class)targetType;
            if (encoded instanceof Map) {
                Map map = (Map)encoded;
                return YamlUtils.decodeBean(map, targetClass);
            }
            if (targetClass.isEnum()) {
                try {
                    Object result = Enum.valueOf(targetClass, (String)encoded);
                    return result;
                }
                catch (IllegalArgumentException e) {
                    throw new YamlException(encoded + " is not a legal value of " + targetClass.getName(), (Throwable)e);
                }
            }
            Function decoder = (Function)SIMPLE_DECODERS.get((Object)targetClass);
            if (decoder == null) {
                if (encoded == null || encoded.equals("")) {
                    return YamlUtils.decodeBean((Map<String, Object>)ImmutableMap.of(), targetClass);
                }
                throw new YamlException("Don't know how to decode " + targetClass.getName() + " from <" + encoded + ">");
            }
            return decoder.apply((String)encoded);
        }
        if (targetType instanceof ParameterizedType) {
            return YamlUtils.decodeParameterized(encoded, (ParameterizedType)targetType);
        }
        throw new YamlException("Don't know how to decode " + targetType + " from " + encoded);
    }

    private static <T> T decodeBean(Map<String, Object> map, Class<T> targetClass) throws YamlException {
        T object;
        try {
            object = targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new YamlException("Can't construct " + targetClass.getName(), (Throwable)e);
        }
        ImmutableMap propertyToSetter = (ImmutableMap)Arrays.stream(targetClass.getMethods()).filter(m -> m.getName().startsWith("set") && m.getName().length() > 3 && m.getParameterCount() == 1).collect(ImmutableMap.toImmutableMap(m -> {
            String name = m.getName().substring(3);
            return Ascii.toLowerCase((char)name.charAt(0)) + name.substring(1);
        }, m -> m));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Method setter = (Method)propertyToSetter.get((Object)entry.getKey());
            if (setter == null) {
                throw new YamlException("Unable to find property '" + entry.getKey() + "' in " + targetClass.getName());
            }
            Type parameterType = setter.getGenericParameterTypes()[0];
            try {
                Object decodedArg = YamlUtils.decode(entry.getValue(), parameterType);
                setter.invoke(object, decodedArg);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new YamlException("Error setting property '" + entry.getKey() + "' in " + targetClass.getName(), (Throwable)e);
            }
        }
        return object;
    }

    private static Object decodeParameterized(Object encoded, ParameterizedType targetType) throws YamlException {
        if (targetType.getRawType().equals(List.class)) {
            Type elementType = targetType.getActualTypeArguments()[0];
            if (encoded == null || encoded.equals("")) {
                encoded = ImmutableList.of();
            }
            return YamlUtils.decodeList((Iterable)encoded, elementType);
        }
        if (targetType.getRawType().equals(Map.class)) {
            Type keyType = targetType.getActualTypeArguments()[0];
            Type valueType = targetType.getActualTypeArguments()[1];
            return YamlUtils.decodeMap((Map)encoded, keyType, valueType);
        }
        throw new YamlException("Don't know how to decode " + targetType);
    }

    private static ImmutableList<?> decodeList(Iterable<?> encoded, Type elementType) throws YamlException {
        if (encoded == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder list = ImmutableList.builder();
        for (Object element : encoded) {
            list.add(YamlUtils.decode(element, elementType));
        }
        return list.build();
    }

    private static ImmutableMap<?, ?> decodeMap(Map<?, ?> encoded, Type keyType, Type valueType) throws YamlException {
        if (encoded == null) {
            return ImmutableMap.of();
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : encoded.entrySet()) {
            Object key = YamlUtils.decode(entry.getKey(), keyType);
            Object value = YamlUtils.decode(entry.getValue(), valueType);
            map.put(key, value);
        }
        return ImmutableMap.copyOf(map);
    }
}

