/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class QueueYamlReader {
    private static final String FILENAME = "queue.yaml";
    private final String fileName;

    public String getFilename() {
        return this.fileName;
    }

    public QueueYamlReader(String yamlDir) {
        this.fileName = yamlDir + File.separatorChar + FILENAME;
    }

    public QueueXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return QueueYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename(), ex);
            }
        }
        return null;
    }

    public static QueueYaml parseYaml(Reader yaml) {
        try {
            return YamlUtils.parse(yaml, QueueYaml.class);
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static QueueXml parse(Reader yaml) {
        QueueYaml queueYaml = QueueYamlReader.parseYaml(yaml);
        return queueYaml.toXml();
    }

    public static QueueYaml parseFromYaml(String yaml) {
        return QueueYamlReader.parseYaml(new StringReader(yaml));
    }

    public static QueueXml parse(String yaml) {
        return QueueYamlReader.parse(new StringReader(yaml));
    }

    public static class QueueYaml {
        private List<Queue> entries;
        private String total_storage_limit;

        public List<Queue> getQueue() {
            return this.entries;
        }

        public void setQueue(List<Queue> entries) {
            this.entries = entries;
        }

        public String getTotal_storage_limit() {
            return this.total_storage_limit;
        }

        public void setTotal_storage_limit(String totalStorageLimit) {
            this.total_storage_limit = totalStorageLimit;
        }

        public QueueXml toXml() {
            QueueXml xml = new QueueXml();
            if (this.total_storage_limit != null) {
                xml.setTotalStorageLimit(this.total_storage_limit);
            }
            if (this.entries != null) {
                for (Queue entry : this.entries) {
                    xml.addEntry(entry.toXml());
                }
            }
            return xml;
        }

        public static class Queue {
            private final QueueXml.Entry entry = new QueueXml.Entry();
            private RetryParameters retryParameters;

            public void setName(String name) {
                this.entry.setName(name);
            }

            public String getName() {
                return this.entry.getName();
            }

            public void setRate(String rate) {
                this.entry.setRate(rate);
            }

            public String getRate() {
                return this.entry.getRate() + "/" + this.entry.getRateUnit().getIdent();
            }

            public Double getRateDouble() {
                return this.entry.getRate();
            }

            public void setBucket_size(int size) {
                this.entry.setBucketSize(size);
            }

            public int getBucket_size() {
                return this.entry.getBucketSize();
            }

            public void setMax_concurrent_requests(int size) {
                this.entry.setMaxConcurrentRequests(size);
            }

            public int getMax_concurrent_requests() {
                return this.entry.getMaxConcurrentRequests();
            }

            public void setRetry_parameters(RetryParameters retryParameters) {
                this.retryParameters = retryParameters;
                if (retryParameters != null) {
                    this.entry.setRetryParameters(retryParameters.toXml());
                } else {
                    this.entry.setRetryParameters(new QueueXml.RetryParameters());
                }
            }

            public RetryParameters getRetry_parameters() {
                return this.retryParameters;
            }

            public void setTarget(String target) {
                this.entry.setTarget(target);
            }

            public String getTarget() {
                return this.entry.getTarget();
            }

            public void setMode(String mode) {
                this.entry.setMode(mode);
            }

            public String getMode() {
                return this.entry.getMode();
            }

            public QueueXml.Entry toXml() {
                return this.entry;
            }
        }

        public static class RetryParameters {
            private QueueXml.RetryParameters retryParameters = new QueueXml.RetryParameters();

            public void setTask_retry_limit(int limit) {
                this.retryParameters.setRetryLimit(limit);
            }

            public int getTask_retry_limit() {
                return this.retryParameters.getRetryLimit();
            }

            public void setTask_age_limit(String ageLimit) {
                this.retryParameters.setAgeLimitSec(ageLimit);
            }

            public String getTask_age_limit() {
                return this.retryParameters.getAgeLimitSec().toString() + "s";
            }

            public long getTask_age_limit_sec() {
                return this.retryParameters.getAgeLimitSec().intValue();
            }

            public void setMin_backoff_seconds(double backoff) {
                this.retryParameters.setMinBackoffSec(backoff);
            }

            public double getMin_backoff_seconds() {
                return this.retryParameters.getMinBackoffSec();
            }

            public void setMax_backoff_seconds(double backoff) {
                this.retryParameters.setMaxBackoffSec(backoff);
            }

            public double getMax_backoff_seconds() {
                return this.retryParameters.getMaxBackoffSec();
            }

            public void setMax_doublings(int doublings) {
                this.retryParameters.setMaxDoublings(doublings);
            }

            public int getMax_doublings() {
                return this.retryParameters.getMaxDoublings();
            }

            public QueueXml.RetryParameters toXml() {
                return this.retryParameters;
            }
        }
    }
}

