/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.HttpHeaderParseException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class HttpHeaderParser {
    private char[] chars_;
    private int start_;
    private String header_;
    private static final SimpleDateFormat COOKIE_DATE_FORMAT = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);

    public HttpHeaderParser(String header) {
        this.chars_ = header.toCharArray();
        this.start_ = 0;
        this.header_ = header;
    }

    public boolean isEnd() {
        return this.start_ >= this.chars_.length;
    }

    public int peek() {
        if (this.start_ >= this.chars_.length) {
            return -1;
        }
        return this.chars_[this.start_];
    }

    public void eatChar(char ch) throws HttpHeaderParseException {
        if (this.start_ >= this.chars_.length || this.chars_[this.start_] != ch) {
            String string = this.header_;
            int n = this.start_;
            throw new HttpHeaderParseException(new StringBuilder(48 + String.valueOf(string).length()).append("invalid http header: '").append(ch).append("' expected: ").append(string).append("[").append(n).append("]").toString());
        }
        ++this.start_;
    }

    public void eatLWS() {
        while (this.start_ < this.chars_.length && " \t\r\n".indexOf(this.chars_[this.start_]) >= 0) {
            ++this.start_;
        }
    }

    public String eatToken() throws HttpHeaderParseException {
        int mark = this.start_;
        while (this.start_ < this.chars_.length && this.chars_[this.start_] > '\u001f' && this.chars_[this.start_] != '\u007f' && !HttpHeaderParser.isSeparator(this.chars_[this.start_])) {
            ++this.start_;
        }
        if (mark >= this.start_) {
            String string = this.header_;
            int n = this.start_;
            throw new HttpHeaderParseException(new StringBuilder(50 + String.valueOf(string).length()).append("invalid http header: token expected: ").append(string).append("[").append(n).append("]").toString());
        }
        return new String(this.chars_, mark, this.start_ - mark);
    }

    public String eatQuotedString() throws HttpHeaderParseException {
        this.eatChar('\"');
        int mark = this.start_;
        int write = this.start_;
        boolean escaped = false;
        while (this.start_ < this.chars_.length) {
            if (escaped) {
                if (this.chars_[this.start_] > '\u007f') break;
                this.chars_[write++] = this.chars_[this.start_];
                escaped = false;
            } else {
                if (this.chars_[this.start_] == '\"') break;
                if (this.chars_[this.start_] == '\\') {
                    escaped = true;
                } else {
                    if (this.chars_[this.start_] <= '\u001f' || this.chars_[this.start_] == '\u007f') break;
                    this.chars_[write++] = this.chars_[this.start_];
                }
            }
            ++this.start_;
        }
        this.eatChar('\"');
        return new String(this.chars_, mark, write - mark);
    }

    public String eatTokenOrQuotedString() throws HttpHeaderParseException {
        if (this.start_ >= this.chars_.length) {
            String string = this.header_;
            int n = this.start_;
            throw new HttpHeaderParseException(new StringBuilder(67 + String.valueOf(string).length()).append("invalid http header: token or quoted string expected: ").append(string).append("[").append(n).append("]").toString());
        }
        if (this.chars_[this.start_] == '\"') {
            return this.eatQuotedString();
        }
        return this.eatToken();
    }

    public String eatV0CookieToken() throws HttpHeaderParseException {
        int mark = this.start_;
        while (this.start_ < this.chars_.length && ";, \t\r\n=".indexOf(this.chars_[this.start_]) < 0) {
            ++this.start_;
        }
        if (mark >= this.start_) {
            String string = this.header_;
            int n = this.start_;
            throw new HttpHeaderParseException(new StringBuilder(60 + String.valueOf(string).length()).append("invalid v0 cookie http header: token expected: ").append(string).append("[").append(n).append("]").toString());
        }
        return new String(this.chars_, mark, this.start_ - mark);
    }

    public String eatV0CookieValue() {
        int mark = this.start_;
        while (this.start_ < this.chars_.length && ";, \t\r\n".indexOf(this.chars_[this.start_]) < 0) {
            ++this.start_;
        }
        return new String(this.chars_, mark, this.start_ - mark);
    }

    public Date eatV0CookieDate() throws HttpHeaderParseException {
        int mark = this.start_;
        while (this.start_ < this.chars_.length && this.chars_[this.start_] != ';') {
            ++this.start_;
        }
        String value = new String(this.chars_, mark, this.start_ - mark).trim();
        try {
            Date result = COOKIE_DATE_FORMAT.parse(value);
            if (result == null) {
                throw new ParseException(value, 0);
            }
            return result;
        }
        catch (ParseException e) {
            String string = this.header_;
            throw new HttpHeaderParseException(new StringBuilder(59 + String.valueOf(string).length()).append("invalid v0 cookie http header: date expected: ").append(string).append("[").append(mark).append("]").toString());
        }
    }

    public static StringBuffer makeAttributeValuePair(String attribute, String value) {
        if (!HttpHeaderParser.isToken(attribute)) {
            String string = String.valueOf(attribute);
            throw new IllegalArgumentException(string.length() != 0 ? "not an http token: ".concat(string) : new String("not an http token: "));
        }
        StringBuffer result = new StringBuffer(attribute);
        result.append('=');
        if (HttpHeaderParser.isToken(value)) {
            result.append(value);
        } else {
            result.append('\"');
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                char ch = value.charAt(i);
                if (ch == '\"' || ch == '\\' || ch == '\u007f' || ch <= '\u001f' && ch != ' ' && ch != '\t') {
                    if (ch == '\r' || ch == '\n') {
                        throw new IllegalArgumentException("CR, LF not allowed");
                    }
                    result.append('\\');
                    result.append(ch);
                    continue;
                }
                result.append(ch);
            }
            result.append('\"');
        }
        return result;
    }

    public static String getContentCharset(String contentType) throws HttpHeaderParseException {
        HttpHeaderParser parser = new HttpHeaderParser(contentType);
        parser.eatLWS();
        parser.eatToken();
        parser.eatChar('/');
        parser.eatToken();
        parser.eatLWS();
        while (!parser.isEnd()) {
            parser.eatChar(';');
            parser.eatLWS();
            String name = parser.eatToken();
            parser.eatChar('=');
            String value = parser.eatTokenOrQuotedString();
            parser.eatLWS();
            if (!name.equalsIgnoreCase("charset")) continue;
            return value;
        }
        return null;
    }

    private static boolean isSeparator(char ch) {
        return "()<>@,;:\\\"/[]?={} \t".indexOf(ch) >= 0;
    }

    private static boolean isToken(String str) {
        int n = str.length();
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u001f' && ch < '\u007f' && !HttpHeaderParser.isSeparator(ch)) continue;
            return false;
        }
        return true;
    }
}

