/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.org.codehaus.jackson.map.Module;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectReader;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectWriter;
import com.google.appengine.repackaged.org.codehaus.jackson.map.SerializationConfig;
import com.google.appengine.repackaged.org.codehaus.jackson.map.annotate.JsonSerialize;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfiguredObjectMapper {
    @VisibleForTesting
    final ObjectMapper delegate;

    private ConfiguredObjectMapper(ObjectMapper delegate) {
        this.delegate = delegate;
    }

    public ObjectReader reader() {
        return this.delegate.reader();
    }

    public ObjectWriter writer() {
        return this.delegate.writer();
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    static class CacheKey {
        private final ApiSerializationConfig apiSerializationConfig;
        private final ImmutableSet<Module> modulesSet;

        private CacheKey(ApiSerializationConfig config, ImmutableSet<Module> modules) {
            this.apiSerializationConfig = config;
            this.modulesSet = modules;
        }

        public int hashCode() {
            return Objects.hash(this.apiSerializationConfig, this.modulesSet);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CacheKey) {
                CacheKey that = (CacheKey)object;
                return Objects.equals(this.apiSerializationConfig, that.apiSerializationConfig) && this.modulesSet.equals(that.modulesSet);
            }
            return false;
        }
    }

    public static class Builder {
        private static final Logger logger = Logger.getLogger(Builder.class.getName());
        private int maxCacheSize;
        private ApiSerializationConfig config;
        private ImmutableSet.Builder<Module> modules = ImmutableSet.builder();
        private static final Map<CacheKey, ConfiguredObjectMapper> globalCache = Maps.newConcurrentMap();
        private final Map<CacheKey, ConfiguredObjectMapper> cache;

        private Builder() {
            this(globalCache, 1000);
        }

        @VisibleForTesting
        Builder(Map<CacheKey, ConfiguredObjectMapper> mutableCache, int maxCacheSize) {
            Preconditions.checkArgument((maxCacheSize > 0 ? 1 : 0) != 0, (Object)"cache should be positive");
            this.cache = (Map)Preconditions.checkNotNull(mutableCache, (Object)"cache should not be null");
            this.maxCacheSize = maxCacheSize;
        }

        public Builder apiSerializationConfig(ApiSerializationConfig config) {
            this.config = config == null ? null : new ApiSerializationConfig(config);
            return this;
        }

        public Builder addRegisteredModules(Iterable<? extends Module> modules) {
            this.modules.addAll(modules);
            return this;
        }

        public ConfiguredObjectMapper build() {
            CacheKey key = new CacheKey(this.config, this.modules.build());
            ConfiguredObjectMapper instance = this.cache.get(key);
            if (instance == null) {
                ObjectMapper mapper = ObjectMapperUtil.createStandardObjectMapper(key.apiSerializationConfig);
                mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                mapper.disable(SerializationConfig.Feature.WRITE_EMPTY_JSON_ARRAYS);
                for (Module module : key.modulesSet) {
                    mapper.registerModule(module);
                }
                instance = new ConfiguredObjectMapper(mapper);
                if (this.maxCacheSize <= this.cache.size()) {
                    this.cache.clear();
                }
                this.cache.put(key, instance);
                logger.logp(Level.FINE, "com.google.api.server.spi.ConfiguredObjectMapper$Builder", "build", "Cache miss, created ObjectMapper");
            } else {
                logger.logp(Level.FINE, "com.google.api.server.spi.ConfiguredObjectMapper$Builder", "build", "Cache hit, reusing ObjectMapper");
            }
            return instance;
        }
    }
}

