/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;

public class ResourceSchema {
    private final String name;
    private final ImmutableMap<String, ResourcePropertySchema> properties;

    private ResourceSchema(String name, ImmutableMap<String, ResourcePropertySchema> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ResourcePropertySchema> getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceSchema)) {
            return false;
        }
        ResourceSchema that = (ResourceSchema)obj;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.properties});
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass()).add("_name", (Object)this.name);
        for (Map.Entry property : this.properties.entrySet()) {
            helper.add((String)property.getKey(), property.getValue());
        }
        return helper.toString();
    }

    public static Builder builderForType(Type type) {
        return new Builder((Type)Preconditions.checkNotNull((Object)type));
    }

    public static class Builder {
        private String name;
        private ImmutableMap.Builder<String, ResourcePropertySchema> properties = ImmutableMap.builder();

        public Builder(Type type) {
            Preconditions.checkNotNull((Object)type);
            this.name = TypeLoader.getSimpleName(type);
        }

        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public Builder addProperty(String name, ResourcePropertySchema propertySchema) {
            this.properties.put((Object)name, (Object)propertySchema);
            return this;
        }

        public ResourceSchema build() {
            return new ResourceSchema(this.name, this.properties.build());
        }
    }
}

