/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.Serializer;
import com.google.api.server.spi.config.Serializers;
import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApiSerializationConfig {
    private final Map<Type, SerializerConfig> configs;

    public ApiSerializationConfig() {
        this.configs = new LinkedHashMap<Type, SerializerConfig>();
    }

    public ApiSerializationConfig(ApiSerializationConfig original) {
        this.configs = new LinkedHashMap<Type, SerializerConfig>(original.configs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiSerializationConfig) {
            ApiSerializationConfig config = (ApiSerializationConfig)o;
            return this.configs.equals(config.configs);
        }
        return false;
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public void addSerializationConfig(Class<? extends Serializer<?, ?>> serializer) {
        Type sourceType = Serializers.getSourceType(serializer);
        this.configs.put(sourceType, new SerializerConfig(sourceType, serializer));
    }

    public List<SerializerConfig> getSerializerConfigs() {
        return new ArrayList<SerializerConfig>(this.configs.values());
    }

    public SerializerConfig getSerializerConfig(Type type) {
        return this.configs.get(TypeToken.of(type).getRawType());
    }

    public static class SerializerConfig {
        private final Type sourceType;
        private final Class<? extends Serializer<?, ?>> serializer;

        public SerializerConfig(Type sourceType, Class<? extends Serializer<?, ?>> serializer) {
            this.sourceType = sourceType;
            this.serializer = serializer;
        }

        public Type getSourceType() {
            return this.sourceType;
        }

        public Class<? extends Serializer<?, ?>> getSerializer() {
            return this.serializer;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SerializerConfig) {
                SerializerConfig other = (SerializerConfig)obj;
                return this.sourceType.equals(other.sourceType) && this.serializer.equals(other.serializer);
            }
            return false;
        }
    }
}

