/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet.ee10;

import com.google.apphosting.utils.servlet.ee10.MultipartMimeUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class ParseBlobUploadFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ParseBlobUploadFilter.class.getName());
    static final String UPLOAD_HEADER = "X-AppEngine-BlobUpload";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";
    static final String UPLOADED_BLOBINFO_ATTR = "com.google.appengine.api.blobstore.upload.blobinfos";
    static final String UPLOAD_CREATION_HEADER = "X-AppEngine-Upload-Creation";
    static final String CLOUD_STORAGE_OBJECT_HEADER = "X-AppEngine-Cloud-Storage-Object";
    static final String CONTENT_LENGTH_HEADER = "Content-Length";

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (req.getHeader(UPLOAD_HEADER) != null) {
            HashMap<String, List> blobKeys = new HashMap<String, List>();
            HashMap<String, List> blobInfos = new HashMap<String, List>();
            HashMap<String, List<String>> otherParams = new HashMap<String, List<String>>();
            try {
                MimeMultipart multipart = MultipartMimeUtils.parseMultipartRequest(req);
                int parts = multipart.getCount();
                for (int i = 0; i < parts; ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    String fieldName = MultipartMimeUtils.getFieldName(part);
                    if (part.getFileName() != null) {
                        ContentType contentType = new ContentType(part.getContentType());
                        if (!"message/external-body".equals(contentType.getBaseType())) continue;
                        String blobKeyString = contentType.getParameter("blob-key");
                        List keys = blobKeys.computeIfAbsent(fieldName, k -> new ArrayList());
                        keys.add(blobKeyString);
                        List infos = blobInfos.computeIfAbsent(fieldName, k -> new ArrayList());
                        infos.add(this.getInfoFromBody(MultipartMimeUtils.getTextContent(part), blobKeyString));
                        continue;
                    }
                    List values = otherParams.computeIfAbsent(fieldName, k -> new ArrayList());
                    values.add(MultipartMimeUtils.getTextContent(part));
                }
                req.setAttribute(UPLOADED_BLOBKEY_ATTR, blobKeys);
                req.setAttribute(UPLOADED_BLOBINFO_ATTR, blobInfos);
            }
            catch (MessagingException ex) {
                logger.log(Level.WARNING, "Could not parse multipart message:", ex);
            }
            chain.doFilter((ServletRequest)new ParameterServletWrapper(request, otherParams), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private Map<String, String> getInfoFromBody(String bodyContent, String key) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart((InputStream)new ByteArrayInputStream(bodyContent.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("key", key);
        info.put("content-type", part.getContentType());
        info.put("creation-date", part.getHeader(UPLOAD_CREATION_HEADER)[0]);
        info.put("filename", part.getFileName());
        info.put("size", part.getHeader(CONTENT_LENGTH_HEADER)[0]);
        info.put("md5-hash", part.getContentMD5());
        String[] headers = part.getHeader(CLOUD_STORAGE_OBJECT_HEADER);
        if (headers != null && headers.length == 1) {
            info.put("gs-name", headers[0]);
        }
        return info;
    }

    private static class ParameterServletWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, List<String>> otherParams;

        ParameterServletWrapper(ServletRequest request, Map<String, List<String>> otherParams) {
            super((HttpServletRequest)request);
            this.otherParams = otherParams;
        }

        public Map<String, String[]> getParameterMap() {
            Map parameters = super.getParameterMap();
            if (this.otherParams.isEmpty()) {
                return parameters;
            }
            HashMap map = new HashMap(parameters);
            this.otherParams.forEach((k, v) -> map.put(k, v.toArray(new String[0])));
            return Collections.unmodifiableMap(map);
        }

        public Enumeration<String> getParameterNames() {
            ArrayList allNames = new ArrayList(Collections.list(super.getParameterNames()));
            allNames.addAll(this.otherParams.keySet());
            return Collections.enumeration(allNames);
        }

        public String[] getParameterValues(String name) {
            if (this.otherParams.containsKey(name)) {
                return this.otherParams.get(name).toArray(new String[0]);
            }
            return super.getParameterValues(name);
        }

        public String getParameter(String name) {
            if (this.otherParams.containsKey(name)) {
                return this.otherParams.get(name).get(0);
            }
            return super.getParameter(name);
        }
    }
}

