/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.ee10;

import com.google.apphosting.api.ApiProxy;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;

public class DeferredTaskContext {
    public static final String RUNNABLE_TASK_CONTENT_TYPE = "application/x-binary-app-engine-java-runnable-task";
    public static final String DEFAULT_DEFERRED_URL = "/_ah/queue/__deferred__";
    static final String DEFERRED_TASK_SERVLET_KEY = DeferredTaskContext.class.getName() + ".httpServlet";
    static final String DEFERRED_TASK_REQUEST_KEY = DeferredTaskContext.class.getName() + ".httpServletRequest";
    static final String DEFERRED_TASK_RESPONSE_KEY = DeferredTaskContext.class.getName() + ".httpServletResponse";
    static final String DEFERRED_DO_NOT_RETRY_KEY = DeferredTaskContext.class.getName() + ".doNotRetry";
    static final String DEFERRED_MARK_RETRY_KEY = DeferredTaskContext.class.getName() + ".markRetry";

    public static HttpServlet getCurrentServlet() {
        Map attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        return (HttpServlet)attributes.get(DEFERRED_TASK_SERVLET_KEY);
    }

    public static HttpServletRequest getCurrentRequest() {
        Map attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        return (HttpServletRequest)attributes.get(DEFERRED_TASK_REQUEST_KEY);
    }

    public static HttpServletResponse getCurrentResponse() {
        Map attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        return (HttpServletResponse)attributes.get(DEFERRED_TASK_RESPONSE_KEY);
    }

    public static void setDoNotRetry(boolean value) {
        Map attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        attributes.put(DEFERRED_DO_NOT_RETRY_KEY, value);
    }

    public static void markForRetry() {
        Map attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        attributes.put(DEFERRED_MARK_RETRY_KEY, true);
    }

    private static ApiProxy.Environment getCurrentEnvironmentOrThrow() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new IllegalStateException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        return environment;
    }

    private DeferredTaskContext() {
    }
}

