/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.base.protos.Codes;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;

@AppEngineInternal
public final class RequestStatusUtil {
    private static final ImmutableMap<SearchServicePb.SearchServiceError.ErrorCode, Codes.Code> REQUEST_STATUS_TO_CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put((Object)SearchServicePb.SearchServiceError.ErrorCode.OK, (Object)Codes.Code.OK).put((Object)SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, (Object)Codes.Code.INVALID_ARGUMENT).put((Object)SearchServicePb.SearchServiceError.ErrorCode.TRANSIENT_ERROR, (Object)Codes.Code.UNAVAILABLE).put((Object)SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, (Object)Codes.Code.INTERNAL).put((Object)SearchServicePb.SearchServiceError.ErrorCode.PERMISSION_DENIED, (Object)Codes.Code.PERMISSION_DENIED).put((Object)SearchServicePb.SearchServiceError.ErrorCode.TIMEOUT, (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)SearchServicePb.SearchServiceError.ErrorCode.CONCURRENT_TRANSACTION, (Object)Codes.Code.ABORTED).buildOrThrow();

    public static Codes.Code toCanonicalCode(SearchServicePb.SearchServiceError.ErrorCode appCode) {
        return (Codes.Code)Preconditions.checkNotNull((Object)((Codes.Code)REQUEST_STATUS_TO_CANONICAL_ERROR_MAPPING.get((Object)appCode)));
    }

    public static SearchServicePb.RequestStatus.Builder newStatusBuilder(SearchServicePb.SearchServiceError.ErrorCode code, String message) {
        SearchServicePb.RequestStatus.Builder builder = SearchServicePb.RequestStatus.newBuilder();
        builder.setCode(code).setCanonicalCode(RequestStatusUtil.toCanonicalCode(code).getNumber());
        if (message != null) {
            builder.setErrorDetail(message);
        }
        return builder;
    }

    public static SearchServicePb.RequestStatus newStatus(SearchServicePb.SearchServiceError.ErrorCode code, String message) {
        return RequestStatusUtil.newStatusBuilder(code, message).build();
    }

    public static SearchServicePb.RequestStatus newStatus(SearchServicePb.SearchServiceError.ErrorCode code) {
        return RequestStatusUtil.newStatusBuilder(code, null).build();
    }

    public static SearchServicePb.RequestStatus newInvalidRequestStatus(IllegalArgumentException e) {
        Preconditions.checkNotNull((Object)e.getMessage());
        return RequestStatusUtil.newStatus(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, e.getMessage());
    }

    public static SearchServicePb.RequestStatus newUnknownIndexStatus(SearchServicePb.IndexSpec indexSpec) {
        return RequestStatusUtil.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK, String.format("Index '%s' in namespace '%s' does not exist", indexSpec.getName(), indexSpec.getNamespace()));
    }

    public static SearchServicePb.RequestStatus reduce(Collection<SearchServicePb.RequestStatus> statuses) {
        if (statuses.isEmpty()) {
            return RequestStatusUtil.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK);
        }
        if (statuses.size() == 1) {
            return (SearchServicePb.RequestStatus)Iterables.getOnlyElement(statuses);
        }
        SearchServicePb.SearchServiceError.ErrorCode errorCode = SearchServicePb.SearchServiceError.ErrorCode.OK;
        HashSet<String> errorDetails = null;
        for (SearchServicePb.RequestStatus status : statuses) {
            if (status.getCode() == SearchServicePb.SearchServiceError.ErrorCode.OK) continue;
            if (errorDetails == null) {
                errorDetails = new HashSet<String>();
            }
            errorDetails.add(status.getErrorDetail());
            if (status.getCode().getNumber() <= errorCode.getNumber()) continue;
            errorCode = status.getCode();
        }
        if (errorDetails == null) {
            return RequestStatusUtil.newStatus(errorCode);
        }
        return RequestStatusUtil.newStatus(errorCode, Joiner.on((String)"; ").join(errorDetails));
    }
}

